/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentFactoryHelper;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.sl.usermodel.SlideShowProvider;
import org.apache.poi.util.Internal;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFTextParagraph;

@Internal
public class XSLFSlideShowFactory
implements SlideShowProvider<XSLFShape, XSLFTextParagraph> {
    public boolean accepts(FileMagic fm) {
        return fm == FileMagic.OOXML;
    }

    public XMLSlideShow create() {
        return new XMLSlideShow();
    }

    public XMLSlideShow create(DirectoryNode root, String password) throws IOException {
        try {
            XMLSlideShow xMLSlideShow;
            block9: {
                InputStream stream = DocumentFactoryHelper.getDecryptedStream((DirectoryNode)root, (String)password);
                try {
                    xMLSlideShow = this.create(stream);
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stream.close();
            }
            return xMLSlideShow;
        }
        finally {
            root.getFileSystem().close();
        }
    }

    public XMLSlideShow create(InputStream inp, String password) throws IOException {
        InputStream bufInp = FileMagic.prepareToCheckMagic((InputStream)inp);
        FileMagic fm = FileMagic.valueOf((InputStream)bufInp);
        if (fm == FileMagic.OLE2) {
            try (POIFSFileSystem poifs = new POIFSFileSystem(bufInp);){
                XMLSlideShow xMLSlideShow;
                block13: {
                    InputStream stream = DocumentFactoryHelper.getDecryptedStream((DirectoryNode)poifs.getRoot(), (String)password);
                    try {
                        xMLSlideShow = this.create(stream);
                        if (stream == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    stream.close();
                }
                return xMLSlideShow;
            }
        }
        if (fm == FileMagic.OOXML) {
            return this.create(bufInp);
        }
        return null;
    }

    public XMLSlideShow create(InputStream stream) throws IOException {
        try {
            OPCPackage pkg = OPCPackage.open(stream);
            return XSLFSlideShowFactory.createSlideShow(pkg);
        }
        catch (InvalidFormatException e) {
            throw new IOException(e);
        }
    }

    public static XMLSlideShow createSlideShow(OPCPackage pkg) throws IOException {
        try {
            return new XMLSlideShow(pkg);
        }
        catch (RuntimeException ioe) {
            pkg.revert();
            throw ioe;
        }
    }

    public XMLSlideShow create(File file, String password, boolean readOnly) throws IOException {
        FileMagic fm = FileMagic.valueOf((File)file);
        if (fm == FileMagic.OLE2) {
            try (POIFSFileSystem poifs = new POIFSFileSystem(file, true);){
                XMLSlideShow xMLSlideShow;
                block14: {
                    InputStream stream = DocumentFactoryHelper.getDecryptedStream((DirectoryNode)poifs.getRoot(), (String)password);
                    try {
                        xMLSlideShow = this.create(stream);
                        if (stream == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    stream.close();
                }
                return xMLSlideShow;
            }
        }
        try {
            OPCPackage pkg = OPCPackage.open(file, readOnly ? PackageAccess.READ : PackageAccess.READ_WRITE);
            return XSLFSlideShowFactory.createSlideShow(pkg);
        }
        catch (InvalidFormatException e) {
            throw new IOException(e);
        }
    }
}

