/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel;

import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.CompleteChannelFuture;

public class FailedChannelFuture
extends CompleteChannelFuture {
    private final Throwable cause;

    public FailedChannelFuture(Channel channel, Throwable cause) {
        super(channel);
        if (cause == null) {
            throw new NullPointerException("cause");
        }
        this.cause = cause;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    @Override
    public boolean isSuccess() {
        return false;
    }

    @Override
    public ChannelFuture rethrowIfFailed() throws Exception {
        if (this.cause instanceof Exception) {
            throw (Exception)this.cause;
        }
        if (this.cause instanceof Error) {
            throw (Error)this.cause;
        }
        throw new RuntimeException(this.cause);
    }

    @Override
    public ChannelFuture sync() throws InterruptedException {
        this.rethrow();
        return this;
    }

    @Override
    public ChannelFuture syncUninterruptibly() {
        this.rethrow();
        return this;
    }

    private void rethrow() {
        if (this.cause instanceof RuntimeException) {
            throw (RuntimeException)this.cause;
        }
        if (this.cause instanceof Error) {
            throw (Error)this.cause;
        }
        throw new ChannelException(this.cause);
    }
}

