/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.HttpCodecUtil;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.util.internal.StringUtil;

public class DefaultHttpMessage
implements HttpMessage {
    private final HttpHeaders headers = new HttpHeaders();
    private HttpVersion version;
    private ChannelBuffer content = ChannelBuffers.EMPTY_BUFFER;
    private boolean chunked;

    protected DefaultHttpMessage(HttpVersion version) {
        this.setProtocolVersion(version);
    }

    @Override
    public void addHeader(String name, Object value) {
        this.headers.addHeader(name, value);
    }

    @Override
    public void setHeader(String name, Object value) {
        this.headers.setHeader(name, value);
    }

    @Override
    public void setHeader(String name, Iterable<?> values) {
        this.headers.setHeader(name, values);
    }

    @Override
    public void removeHeader(String name) {
        this.headers.removeHeader(name);
    }

    @Override
    @Deprecated
    public long getContentLength() {
        return HttpHeaders.getContentLength(this);
    }

    @Override
    @Deprecated
    public long getContentLength(long defaultValue) {
        return HttpHeaders.getContentLength(this, defaultValue);
    }

    @Override
    public boolean isChunked() {
        if (this.chunked) {
            return true;
        }
        return HttpCodecUtil.isTransferEncodingChunked(this);
    }

    @Override
    public void setChunked(boolean chunked) {
        this.chunked = chunked;
        if (chunked) {
            this.setContent(ChannelBuffers.EMPTY_BUFFER);
        }
    }

    @Override
    @Deprecated
    public boolean isKeepAlive() {
        return HttpHeaders.isKeepAlive(this);
    }

    @Override
    public void clearHeaders() {
        this.headers.clearHeaders();
    }

    @Override
    public void setContent(ChannelBuffer content) {
        if (content == null) {
            content = ChannelBuffers.EMPTY_BUFFER;
        }
        if (content.readable() && this.isChunked()) {
            throw new IllegalArgumentException("non-empty content disallowed if this.chunked == true");
        }
        this.content = content;
    }

    @Override
    public String getHeader(String name) {
        return this.headers.getHeader(name);
    }

    @Override
    public List<String> getHeaders(String name) {
        return this.headers.getHeaders(name);
    }

    @Override
    public List<Map.Entry<String, String>> getHeaders() {
        return this.headers.getHeaders();
    }

    @Override
    public boolean containsHeader(String name) {
        return this.headers.containsHeader(name);
    }

    @Override
    public Set<String> getHeaderNames() {
        return this.headers.getHeaderNames();
    }

    @Override
    public HttpVersion getProtocolVersion() {
        return this.version;
    }

    @Override
    public void setProtocolVersion(HttpVersion version) {
        if (version == null) {
            throw new NullPointerException("version");
        }
        this.version = version;
    }

    @Override
    public ChannelBuffer getContent() {
        return this.content;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append("(version: ");
        buf.append(this.getProtocolVersion().getText());
        buf.append(", keepAlive: ");
        buf.append(this.isKeepAlive());
        buf.append(", chunked: ");
        buf.append(this.isChunked());
        buf.append(')');
        buf.append(StringUtil.NEWLINE);
        this.appendHeaders(buf);
        buf.setLength(buf.length() - StringUtil.NEWLINE.length());
        return buf.toString();
    }

    void appendHeaders(StringBuilder buf) {
        for (Map.Entry<String, String> e : this.getHeaders()) {
            buf.append(e.getKey());
            buf.append(": ");
            buf.append(e.getValue());
            buf.append(StringUtil.NEWLINE);
        }
    }
}

