/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.execution;

import java.util.concurrent.Executor;
import org.jboss.netty.handler.execution.ChannelEventRunnable;
import org.jboss.netty.handler.execution.ChannelEventRunnableFilter;
import org.jboss.netty.util.ExternalResourceReleasable;
import org.jboss.netty.util.internal.ExecutorUtil;

public class ChainedExecutor
implements Executor,
ExternalResourceReleasable {
    private final Executor cur;
    private final Executor next;
    private final ChannelEventRunnableFilter filter;

    public ChainedExecutor(ChannelEventRunnableFilter filter, Executor cur, Executor next) {
        if (filter == null) {
            throw new NullPointerException("filter");
        }
        if (cur == null) {
            throw new NullPointerException("cur");
        }
        if (next == null) {
            throw new NullPointerException("next");
        }
        this.filter = filter;
        this.cur = cur;
        this.next = next;
    }

    @Override
    public void execute(Runnable command) {
        assert (command instanceof ChannelEventRunnable);
        if (this.filter.filter((ChannelEventRunnable)command)) {
            this.cur.execute(command);
        } else {
            this.next.execute(command);
        }
    }

    @Override
    public void releaseExternalResources() {
        ExecutorUtil.terminate(this.cur, this.next);
        ChainedExecutor.releaseExternal(this.cur);
        ChainedExecutor.releaseExternal(this.next);
    }

    private static void releaseExternal(Executor executor) {
        if (executor instanceof ExternalResourceReleasable) {
            ((ExternalResourceReleasable)((Object)executor)).releaseExternalResources();
        }
    }
}

