/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.util;

import java.nio.ByteBuffer;
import java.util.Collection;
import org.snmp4j.CommandResponder;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageException;
import org.snmp4j.PDU;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.TransportStateReference;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.mp.PduHandle;
import org.snmp4j.mp.PduHandleCallback;
import org.snmp4j.mp.StateReference;
import org.snmp4j.mp.StatusInformation;
import org.snmp4j.smi.Address;
import org.snmp4j.util.WorkerPool;
import org.snmp4j.util.WorkerTask;

public class MultiThreadedMessageDispatcher
implements MessageDispatcher {
    private MessageDispatcher dispatcher;
    private WorkerPool threadPool;

    public MultiThreadedMessageDispatcher(WorkerPool workerPool, MessageDispatcher decoratedDispatcher) {
        this.threadPool = workerPool;
        this.dispatcher = decoratedDispatcher;
    }

    @Override
    public int getNextRequestID() {
        return this.dispatcher.getNextRequestID();
    }

    @Override
    public void addMessageProcessingModel(MessageProcessingModel model) {
        this.dispatcher.addMessageProcessingModel(model);
    }

    @Override
    public void removeMessageProcessingModel(MessageProcessingModel model) {
        this.dispatcher.removeMessageProcessingModel(model);
    }

    @Override
    public MessageProcessingModel getMessageProcessingModel(int messageProcessingModel) {
        return this.dispatcher.getMessageProcessingModel(messageProcessingModel);
    }

    @Override
    public void addTransportMapping(TransportMapping transport) {
        this.dispatcher.addTransportMapping(transport);
    }

    @Override
    public TransportMapping removeTransportMapping(TransportMapping transport) {
        return this.dispatcher.removeTransportMapping(transport);
    }

    @Override
    public Collection<TransportMapping> getTransportMappings() {
        return this.dispatcher.getTransportMappings();
    }

    @Override
    public void addCommandResponder(CommandResponder listener) {
        this.dispatcher.addCommandResponder(listener);
    }

    @Override
    public void removeCommandResponder(CommandResponder listener) {
        this.dispatcher.removeCommandResponder(listener);
    }

    @Override
    public PduHandle sendPdu(Target target, PDU pdu, boolean expectResponse) throws MessageException {
        return this.dispatcher.sendPdu(target, pdu, expectResponse);
    }

    @Override
    public PduHandle sendPdu(TransportMapping transportMapping, Target target, PDU pdu, boolean expectResponse) throws MessageException {
        return this.dispatcher.sendPdu(transportMapping, target, pdu, expectResponse);
    }

    @Override
    public PduHandle sendPdu(TransportMapping transportMapping, Target target, PDU pdu, boolean expectResponse, PduHandleCallback<PDU> callback) throws MessageException {
        return this.dispatcher.sendPdu(transportMapping, target, pdu, expectResponse, callback);
    }

    @Override
    public int returnResponsePdu(int messageProcessingModel, int securityModel, byte[] securityName, int securityLevel, PDU pdu, int maxSizeResponseScopedPDU, StateReference stateReference, StatusInformation statusInformation) throws MessageException {
        return this.dispatcher.returnResponsePdu(messageProcessingModel, securityModel, securityName, securityLevel, pdu, maxSizeResponseScopedPDU, stateReference, statusInformation);
    }

    @Override
    public void releaseStateReference(int messageProcessingModel, PduHandle pduHandle) {
        this.dispatcher.releaseStateReference(messageProcessingModel, pduHandle);
    }

    @Override
    public TransportMapping getTransport(Address destAddress) {
        return this.dispatcher.getTransport(destAddress);
    }

    @Override
    public void processMessage(TransportMapping sourceTransport, Address incomingAddress, ByteBuffer wholeMessage, TransportStateReference tmStateReference) {
        MessageTask task = new MessageTask(sourceTransport, incomingAddress, wholeMessage, tmStateReference);
        this.threadPool.execute(task);
    }

    class MessageTask
    implements WorkerTask {
        private TransportMapping sourceTransport;
        private Address incomingAddress;
        private ByteBuffer wholeMessage;
        private TransportStateReference tmStateReference;

        public MessageTask(TransportMapping sourceTransport, Address incomingAddress, ByteBuffer wholeMessage, TransportStateReference tmStateReference) {
            this.sourceTransport = sourceTransport;
            this.incomingAddress = incomingAddress;
            this.wholeMessage = wholeMessage;
            this.tmStateReference = tmStateReference;
        }

        @Override
        public void run() {
            MultiThreadedMessageDispatcher.this.dispatcher.processMessage(this.sourceTransport, this.incomingAddress, this.wholeMessage, this.tmStateReference);
        }

        @Override
        public void terminate() {
        }

        @Override
        public void join() throws InterruptedException {
        }

        @Override
        public void interrupt() {
        }
    }
}

