/*
 * Decompiled with CFR 0.152.
 */
package inform.adt;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Collections {
    public static void join(Iterable<?> elements, char separator, StringBuilder result) {
        Iterator<?> i = elements.iterator();
        if (i.hasNext()) {
            result.append(i.next());
        }
        while (i.hasNext()) {
            result.append(separator).append(i.next());
        }
    }

    public static void join(Object[] elements, char separator, StringBuilder result) {
        int l = elements.length;
        if (l > 0) {
            result.append(elements[0]);
        }
        for (int i = 1; i < l; ++i) {
            result.append(separator).append(elements[i]);
        }
    }

    public static <T> T[] toArray(List<? extends T> list, Class<T> clazz) {
        Object[] result = (Object[])Array.newInstance(clazz, list.size());
        list.toArray(result);
        return result;
    }

    public static <T> T[] append(T[] original, T ... elements) {
        T[] result = Arrays.copyOf(original, original.length + elements.length);
        System.arraycopy(elements, 0, result, original.length, elements.length);
        return result;
    }

    public static <T, U> Iterator<T> castingIterator(Iterator<U> iterator, final Class<T> cls) {
        return new IteratorDecorator<T, U>(iterator){

            @Override
            public T next() {
                return cls.cast(this.iterator.next());
            }
        };
    }

    public static class Timeline<T extends Slice>
    implements Iterable<T> {
        private final Object[] slices;
        private int position;

        public Timeline(int capacity) {
            this.slices = new Object[capacity];
        }

        public T last() {
            int p = this.position - 1;
            return (T)((Slice)this.slices[p < 0 ? this.slices.length + p : p]);
        }

        public void append(T slice) {
            this.slices[this.position] = slice;
            this.position = (this.position + 1) % this.slices.length;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private T current;
                private int pos;
                private int phase;
                {
                    this.pos = position;
                }

                @Override
                public boolean hasNext() {
                    while (this.current == null) {
                        switch (this.phase) {
                            case 0: {
                                if (this.pos >= slices.length || slices[this.pos] == null) {
                                    this.phase = 1;
                                    this.pos = 0;
                                } else {
                                    this.current = (Slice)slices[this.pos++];
                                    return true;
                                }
                            }
                            case 1: {
                                if (this.pos == position) {
                                    return false;
                                }
                                this.current = (Slice)slices[this.pos++];
                                return true;
                            }
                        }
                    }
                    return true;
                }

                @Override
                public T next() {
                    if (this.current == null && this.pos >= slices.length) {
                        throw new NoSuchElementException();
                    }
                    Object r = this.current;
                    this.current = null;
                    return r;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public static interface Slice {
            public long time();
        }
    }

    public static abstract class IteratorDecorator<T, U>
    implements Iterator<T> {
        protected final Iterator<U> iterator;

        public IteratorDecorator(Iterator<U> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public abstract T next();

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

