/*
 * Decompiled with CFR 0.152.
 */
package inform.adt;

import inform.adt.LittleEndian;
import java.util.Arrays;

public class Memory {
    public static boolean startsWith(byte[] searched, byte[] memory, int index) {
        if (searched == memory) {
            return index == 0;
        }
        if (searched == null || memory == null) {
            return false;
        }
        if (memory.length < index + searched.length) {
            return false;
        }
        for (int i = 0; i < searched.length; ++i) {
            if (searched[i] == memory[index + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWith(byte[] searched, byte[] memory) {
        return Memory.startsWith(searched, memory, 0);
    }

    public static int indexOf(byte[] word, byte[] memory) {
        if (word == null || memory == null || word.length <= 0) {
            return -1;
        }
        int len = memory.length - word.length;
        byte first = word[0];
        block0: for (int i = 0; i <= len; ++i) {
            byte c = memory[i];
            if (c != first) continue;
            for (int j = 1; j < word.length; ++j) {
                if (word[j] != memory[i + j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static Matcher matcher(byte[] word) {
        assert (word != null);
        if (word.length < 8) {
            return new SimpleMatcher(word);
        }
        return new BmhMatcher(word);
    }

    public static Matcher matcherIgnoreCase(byte[] word) {
        assert (word != null);
        if (word.length < 8) {
            return new SimpleIgnoreCaseMatcher(word);
        }
        return new BmhIgnoreCaseMatcher(word);
    }

    private static int[] makeComparable(byte[] a) {
        int[] r = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            r[i] = Memory.toComparable(a[i]);
        }
        return r;
    }

    public static boolean isNumber(byte[] memory) {
        if (memory == null || memory.length <= 0) {
            return false;
        }
        for (int i = 0; i < memory.length; ++i) {
            int b = memory[i] & 0xFF;
            if (b >= 48 && b <= 57) continue;
            return false;
        }
        return true;
    }

    public static long toLong(byte[] memory) {
        long r = 0L;
        for (int i = 0; i < memory.length; ++i) {
            int b = (memory[i] & 0xFF) - 48;
            r = r * 10L + (long)b;
        }
        return r;
    }

    public static boolean containsNumber(long number, byte[] memory) {
        byte[] intBin;
        if (number <= Integer.MAX_VALUE && number >= Integer.MIN_VALUE && Memory.indexOf(intBin = LittleEndian.intToBinary((int)number), memory) >= 0) {
            return true;
        }
        byte[] numBin = LittleEndian.doubleToBinary(number);
        return Memory.indexOf(numBin, memory) >= 0;
    }

    public static int indexOfIgnoreCase(byte[] word, byte[] memory) {
        if (word == null || memory == null || word.length <= 0) {
            return -1;
        }
        int len = memory.length - word.length;
        int first = Memory.toComparable(word[0]);
        block0: for (int i = 0; i <= len; ++i) {
            int c = Memory.toComparable(memory[i]);
            if (c != first) continue;
            for (int j = 1; j < word.length; ++j) {
                if (!Memory.equalsIgnoreCase(word[j], memory[i + j])) continue block0;
            }
            return i;
        }
        return -1;
    }

    static int toComparable(byte a_) {
        int a = a_ & 0xFF;
        if (a >= 97 && a <= 122) {
            return a - 32;
        }
        if (a >= 224 && a <= 255) {
            return a - 32;
        }
        if (a == 168 || a == 184) {
            return 197;
        }
        return a;
    }

    public static boolean equalsIgnoreCase(byte a_, byte b_) {
        int b;
        int a = Memory.toComparable(a_);
        return a == (b = Memory.toComparable(b_));
    }

    public static byte[] trim(byte[] buffer, int length) {
        if (buffer == null || buffer.length == length) {
            return buffer;
        }
        return Arrays.copyOf(buffer, length);
    }

    public static int length(byte[] bytes) {
        return bytes != null ? bytes.length : 0;
    }

    public static boolean isVoid(byte[] values) {
        return values == null || values.length == 0;
    }

    public static boolean isVoid(int[] values) {
        return values == null || values.length == 0;
    }

    public static boolean isVoid(double[] values) {
        return values == null || values.length == 0;
    }

    public static class BmhIgnoreCaseMatcher
    extends Matcher {
        byte[] word;
        int[] cmpWord;
        int[] shift = new int[256];

        BmhIgnoreCaseMatcher(byte[] word) {
            assert (word != null);
            this.word = word;
            this.prepare();
        }

        private void prepare() {
            this.cmpWord = Memory.makeComparable(this.word);
            for (int i = 0; i < this.shift.length; ++i) {
                this.shift[i] = this.word.length;
            }
            int last = this.word.length - 1;
            for (int i = 0; i < last; ++i) {
                this.shift[Memory.toComparable((byte)this.word[i])] = last - i;
            }
        }

        @Override
        public int findIndex(byte[] memory) {
            if (memory == null || this.word == null || this.word.length <= 0) {
                return -1;
            }
            int last = this.word.length - 1;
            int searchLen = memory.length - this.word.length;
            block0: for (int s = 0; s <= searchLen; s += this.shift[Memory.toComparable(memory[s + last])]) {
                for (int i = last; i >= 0; --i) {
                    int a = this.cmpWord[i];
                    int b = Memory.toComparable(memory[s + i]);
                    if (a == b) continue;
                    continue block0;
                }
                return s;
            }
            return -1;
        }
    }

    public static class BmhMatcher
    extends Matcher {
        byte[] word;
        int[] shift = new int[256];

        BmhMatcher(byte[] word) {
            assert (word != null);
            this.word = word;
            this.prepare();
        }

        private void prepare() {
            for (int i = 0; i < this.shift.length; ++i) {
                this.shift[i] = this.word.length;
            }
            int last = this.word.length - 1;
            for (int i = 0; i < last; ++i) {
                this.shift[this.word[i] & 0xFF] = last - i;
            }
        }

        @Override
        public int findIndex(byte[] memory) {
            if (memory == null || this.word == null || this.word.length <= 0) {
                return -1;
            }
            int last = this.word.length - 1;
            int searchLen = memory.length - this.word.length;
            int[] shift = this.shift;
            byte[] word = this.word;
            block0: for (int s = 0; s <= searchLen; s += shift[memory[s + last] & 0xFF]) {
                for (int i = last; i >= 0; --i) {
                    byte b = memory[s + i];
                    if (word[i] == b) continue;
                    continue block0;
                }
                return s;
            }
            return -1;
        }
    }

    public static class SimpleIgnoreCaseMatcher
    extends Matcher {
        int[] cmpWord;

        SimpleIgnoreCaseMatcher(byte[] word) {
            assert (word.length > 0);
            this.cmpWord = Memory.makeComparable(word);
        }

        @Override
        public int findIndex(byte[] memory) {
            if (memory == null || this.cmpWord.length <= 0) {
                return -1;
            }
            int len = memory.length - this.cmpWord.length;
            int first = this.cmpWord[0];
            block0: for (int i = 0; i <= len; ++i) {
                int c = Memory.toComparable(memory[i]);
                if (c != first) continue;
                for (int j = 1; j < this.cmpWord.length; ++j) {
                    if (this.cmpWord[j] != Memory.toComparable(memory[i + j])) continue block0;
                }
                return i;
            }
            return -1;
        }
    }

    public static class SimpleMatcher
    extends Matcher {
        byte[] word;

        SimpleMatcher(byte[] word) {
            this.word = word;
        }

        @Override
        public int findIndex(byte[] memory) {
            return Memory.indexOf(this.word, memory);
        }
    }

    public static abstract class Matcher {
        public abstract int findIndex(byte[] var1);
    }
}

