/*
 * Decompiled with CFR 0.152.
 */
package inform.adt;

import inform.adt.InformException;
import inform.adt.collections.ObjectSet;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class ObjectSizer {
    private static final HashMap<Class, ObjectSizer> sizers = new HashMap();
    private static final Field[] EMPTY_FIELDS = new Field[0];
    private Field[] fields = EMPTY_FIELDS;
    private int primitiveSize;

    private static synchronized ObjectSizer getSizer(Class type) {
        ObjectSizer result = sizers.get(type);
        if (result == null) {
            result = new ObjectSizer(type, null);
            sizers.put(type, result);
        }
        return result;
    }

    public static synchronized void registerSizer(String className, String[] sharedFields) throws ClassNotFoundException {
        Class<?> type = Class.forName(className);
        if (type == null) {
            return;
        }
        ObjectSizer result = sizers.get(type);
        if (result == null) {
            result = new ObjectSizer(type, sharedFields);
            sizers.put(type, result);
        }
    }

    private static final Field[] getDeclaredFields(Class type) {
        Field[] fields = EMPTY_FIELDS;
        try {
            fields = type.getDeclaredFields();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return fields;
    }

    private ObjectSizer(Class type, String[] sharedFields) {
        HashSet<String> shared = new HashSet<String>();
        if (sharedFields != null) {
            shared.addAll(Arrays.asList(sharedFields));
        } else {
            HintSharedProperties hsp = this.getHspAnnotation(type);
            if (hsp != null) {
                shared.addAll(Arrays.asList(hsp.value()));
            }
        }
        this.primitiveSize = 16;
        ArrayList<Field> flds = new ArrayList<Field>();
        do {
            for (Field f : ObjectSizer.getDeclaredFields(type)) {
                if ((f.getModifiers() & 8) != 0) continue;
                Class<?> t = f.getType();
                if (t.isPrimitive()) {
                    this.primitiveSize += ObjectSizer.calculatePrimitiveSize(t);
                    continue;
                }
                this.primitiveSize += 8;
                if (f.getAnnotation(HintShared.class) != null || shared.contains(f.getName()) || t.getAnnotation(HintSharedClass.class) != null) continue;
                flds.add(f);
            }
        } while ((type = type.getSuperclass()) != null);
        if (!flds.isEmpty()) {
            this.fields = new Field[flds.size()];
            flds.toArray(this.fields);
            AccessibleObject.setAccessible(this.fields, true);
        }
    }

    private HintSharedProperties getHspAnnotation(Class type) {
        return type.getAnnotation(HintSharedProperties.class);
    }

    public static long calculateObjectSize(Object object, Objects set, boolean force) {
        if (object == null) {
            return 0L;
        }
        if (!set.add(object) && !force) {
            return 0L;
        }
        long result = 0L;
        Stack stack = new Stack();
        while (object != null) {
            Object o;
            Class<?> cls = object.getClass();
            if (cls.isArray()) {
                result += 24L;
                Class<?> t = cls.getComponentType();
                if (t.isPrimitive()) {
                    result += (long)(Array.getLength(object) * ObjectSizer.calculatePrimitiveSize(t));
                } else {
                    Object[] objects = (Object[])object;
                    result += (long)(8 * objects.length);
                    Object[] objectArray = objects;
                    int n = objectArray.length;
                    for (int i = 0; i < n; ++i) {
                        o = objectArray[i];
                        ObjectSizer.processObject(o, set, stack);
                    }
                }
            } else {
                ObjectSizer sizer = ObjectSizer.getSizer(cls);
                result += (long)sizer.primitiveSize;
                for (Field f : sizer.fields) {
                    try {
                        o = f.get(object);
                    }
                    catch (IllegalAccessException e) {
                        throw InformException.wrap(e);
                    }
                    ObjectSizer.processObject(o, set, stack);
                }
            }
            object = stack.poll();
        }
        return result;
    }

    private static void processObject(Object object, Objects set, Stack stack) {
        if (object == null) {
            return;
        }
        if (!set.add(object)) {
            return;
        }
        stack.push(object);
    }

    public static int calculatePrimitiveSize(Class type) {
        if (type == Byte.TYPE) {
            return 1;
        }
        if (type == Boolean.TYPE) {
            return 1;
        }
        if (type == Character.TYPE) {
            return 2;
        }
        if (type == Short.TYPE) {
            return 2;
        }
        if (type == Integer.TYPE) {
            return 4;
        }
        if (type == Float.TYPE) {
            return 4;
        }
        if (type == Long.TYPE) {
            return 8;
        }
        if (type == Double.TYPE) {
            return 8;
        }
        throw new IllegalArgumentException();
    }

    public static boolean isPrimitiveClass(Class type) {
        if (type == Byte.class) {
            return true;
        }
        if (type == Boolean.class) {
            return true;
        }
        if (type == Character.class) {
            return true;
        }
        if (type == Short.class) {
            return true;
        }
        if (type == Integer.class) {
            return true;
        }
        if (type == Float.class) {
            return true;
        }
        if (type == Long.class) {
            return true;
        }
        return type == Double.class;
    }

    public static class Objects
    extends ObjectSet {
        @Override
        protected int hash(Object o) {
            return System.identityHashCode(o);
        }

        @Override
        protected boolean equals(Object a, Object b) {
            return a == b;
        }
    }

    private static class Stack
    extends ArrayDeque<Object> {
        private Stack() {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface HintSharedClass {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface HintSharedProperties {
        public String[] value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface HintShared {
    }
}

