/*
 * Decompiled with CFR 0.152.
 */
package inform.adt;

import inform.adt.IO;
import inform.adt.InformException;
import inform.adt.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ReadOnDemandFileInputStream
extends InputStream {
    public static final int BUFFER_SIZE = 0x100000;
    public static final int MAX_BUFFER_SIZE = 0x400000;
    private File file;
    private final String mountPoint;
    private long position = 0L;
    private long actualPosition = 0L;
    private byte[] buffer;
    private boolean fullyCached = false;
    private long bufferPosition = 0L;
    private int bufferSize = 0;
    private final Object closeLock = new Object();

    public ReadOnDemandFileInputStream(String mountPoint, File file) {
        if (Strings.isVoid(mountPoint)) {
            throw new InformException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0438\u043c\u044f \u0444\u0430\u0439\u043b\u0430");
        }
        this.file = file;
        this.mountPoint = mountPoint;
    }

    @Override
    public int read() throws IOException {
        this.fill();
        int bufferOffset = (int)(this.actualPosition - this.bufferPosition);
        int readSize = this.bufferSize - bufferOffset;
        if (readSize <= 0) {
            return -1;
        }
        ++this.position;
        return this.buffer[bufferOffset] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.fill();
        int bufferOffset = (int)(this.actualPosition - this.bufferPosition);
        int readSize = this.bufferSize - bufferOffset;
        if (readSize > len) {
            readSize = len;
        }
        if (readSize <= 0) {
            return -1;
        }
        this.position += (long)readSize;
        System.arraycopy(this.buffer, bufferOffset, b, off, readSize);
        return readSize;
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkOpened();
        long fileLength = this.length();
        long availableSkip = fileLength - this.actualPosition;
        if (n < availableSkip) {
            availableSkip = n < 0L ? 0L : n;
        }
        this.position = this.actualPosition + availableSkip;
        return availableSkip;
    }

    @Override
    public int available() throws IOException {
        this.checkOpened();
        long fileLength = this.length();
        long result = fileLength - this.actualPosition;
        return result <= Integer.MAX_VALUE ? (int)result : Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            this.file = null;
            this.buffer = null;
        }
    }

    private void checkOpened() throws IOException {
        if (this.file == null) {
            throw new IOException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u0437\u0430\u043a\u0440\u044b\u0442\u043e\u043c\u0443 \u0444\u0430\u0439\u043b\u0443 " + this.mountPoint);
        }
    }

    private long length() {
        long fileLength = this.fullyCached ? (long)this.buffer.length : this.file.length();
        this.actualPosition = this.position < fileLength ? this.position : fileLength;
        return fileLength;
    }

    private void fill() throws IOException {
        this.checkOpened();
        long fileLength = this.length();
        if (this.buffer == null) {
            if (fileLength <= 0x400000L) {
                this.buffer = new byte[(int)fileLength];
                this.bufferPosition = 0L;
                this.bufferSize = this.buffer.length;
                this.fullyCached = true;
                try (FileInputStream inputStream = new FileInputStream(this.file);){
                    IO.readFully(inputStream, this.buffer, 0, this.buffer.length);
                }
            }
            this.buffer = new byte[0x100000];
            this.bufferPosition = 0L;
            this.bufferSize = 0;
            this.bufferPosition = this.actualPosition;
            this.bufferSize = this.buffer.length;
            try (FileInputStream inputStream = new FileInputStream(this.file);){
                ((InputStream)inputStream).skip(this.bufferPosition);
                IO.readFully(inputStream, this.buffer, 0, this.bufferSize);
            }
            return;
        }
        if (!this.fullyCached) {
            long bufferEnd = this.bufferPosition + (long)this.bufferSize;
            if (bufferEnd > fileLength) {
                bufferEnd = fileLength;
            }
            if (this.bufferPosition <= this.actualPosition && this.actualPosition < bufferEnd) {
                return;
            }
            this.bufferPosition = this.actualPosition;
            this.bufferSize = Math.min((int)Math.min(fileLength - this.actualPosition, Integer.MAX_VALUE), this.buffer.length);
            if (this.bufferSize == 0) {
                return;
            }
            try (FileInputStream inputStream = new FileInputStream(this.file);){
                ((InputStream)inputStream).skip(this.bufferPosition);
                IO.readFully(inputStream, this.buffer, 0, this.bufferSize);
            }
        }
    }
}

