/*
 * Decompiled with CFR 0.152.
 */
package inform.adt.collections;

import inform.adt.collections.AbstractList;
import inform.adt.collections.Cursor;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DoubleList
extends AbstractList
implements Iterable<Cursor> {
    private double[] data;

    public DoubleList(int initialCapacity) {
        super(initialCapacity);
        this.data = new double[this.capacity];
    }

    public DoubleList(DoubleList list) {
        super(list.size);
        this.size = list.size;
        this.data = Arrays.copyOf(list.data, this.size);
    }

    public void add(double v) {
        this.upgrow();
        this.data[this.size++] = v;
    }

    public void add(int index, double v) {
        this.upgrow();
        System.arraycopy(this.data, index, this.data, index + 1, this.size - index);
        this.data[index] = v;
        ++this.size;
    }

    public void remove(int index) {
        if (index + 1 > this.size) {
            return;
        }
        if (index + 1 < this.size) {
            System.arraycopy(this.data, index + 1, this.data, index, this.size - index - 1);
        }
        --this.size;
    }

    public double get(int index) {
        return this.data[index];
    }

    public void set(int index, double value) {
        this.data[index] = value;
    }

    @Override
    public Iterator<Cursor> iterator() {
        return new Itr();
    }

    public void shrink() {
        if (this.capacity == this.size) {
            return;
        }
        double[] tmp = new double[this.size];
        System.arraycopy(this.data, 0, tmp, 0, this.size);
        this.data = tmp;
    }

    public double[] internalArray() {
        return this.data;
    }

    public double[] toArray() {
        return Arrays.copyOf(this.data, this.size);
    }

    @Override
    protected void grow() {
        double[] tmp = new double[this.capacity];
        System.arraycopy(this.data, 0, tmp, 0, this.size);
        this.data = tmp;
    }

    @Override
    protected void itemToString(int index, StringBuilder out) {
        out.append(this.data[index]);
    }

    private class Itr
    extends Cursor
    implements Iterator<Cursor> {
        private Itr() {
            this.index = -1;
        }

        @Override
        public final boolean hasNext() {
            return this.index < DoubleList.this.size - 1;
        }

        @Override
        public final Cursor next() {
            if (this.index >= DoubleList.this.size) {
                throw new NoSuchElementException();
            }
            this.value = DoubleList.this.data[++this.index];
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Cursor
    extends Cursor.Double {
        public int index;
    }
}

