/*
 * Decompiled with CFR 0.152.
 */
package inform.adt.collections;

import inform.adt.collections.AbstractSet;
import inform.adt.collections.Cursor;
import inform.adt.collections.Hashing;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DoubleSet
extends AbstractSet
implements Iterable<Cursor.Double> {
    public static final DoubleSet EMPTY = new DoubleSet();
    private static final double ZERO = 0.0;
    private double[] keys;

    public DoubleSet() {
        this.keys = new double[this.capacity << 1];
    }

    public boolean add(double v) {
        if (v == 0.0) {
            return this.addZero();
        }
        this.rehashIfNeed();
        boolean r = this.place(v);
        if (r) {
            ++this.size;
        }
        return r;
    }

    public boolean contains(double k) {
        double e;
        if (k == 0.0) {
            return this.zero;
        }
        int m = this.keys.length - 1;
        int i = (this.hash(k) & this.mask) << 1;
        while ((e = this.keys[i]) != 0.0) {
            if (this.equals(e, k)) {
                return true;
            }
            i = i + 1 & m;
        }
        return false;
    }

    public boolean remove(double k) {
        double e;
        if (k == 0.0) {
            return this.remZero();
        }
        int m = this.keys.length - 1;
        int i = (this.hash(k) & this.mask) << 1;
        while ((e = this.keys[i]) != 0.0) {
            if (this.equals(e, k)) {
                this.deleteAt(i);
                return true;
            }
            i = i + 1 & m;
        }
        return false;
    }

    @Override
    public void clear() {
        super.clear();
        int len = this.keys.length;
        for (int i = 0; i < len; ++i) {
            this.keys[i] = 0.0;
        }
    }

    @Override
    public Iterator<Cursor.Double> iterator() {
        return new Iterator<Cursor.Double>(){
            final Cursor.Double cursor = new Cursor.Double();
            final int keysLen;
            boolean has;
            int idx;
            {
                this.keysLen = DoubleSet.this.keys.length;
                this.has = DoubleSet.this.zero;
            }

            @Override
            public boolean hasNext() {
                while (!this.has && this.idx < this.keysLen) {
                    this.has = (this.cursor.value = DoubleSet.this.keys[this.idx++]) != 0.0;
                }
                return this.has;
            }

            @Override
            public Cursor.Double next() {
                if (this.idx > this.keysLen) {
                    throw new NoSuchElementException();
                }
                this.has = false;
                return this.cursor;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public double[] toArray() {
        double[] r = new double[this.size];
        int i = 0;
        if (this.zero) {
            r[i++] = 0.0;
        }
        for (double v : this.keys) {
            if (v == 0.0) continue;
            r[i++] = v;
        }
        return r;
    }

    private boolean place(double k) {
        double e;
        int m = this.keys.length - 1;
        int i = (this.hash(k) & this.mask) << 1;
        while ((e = this.keys[i]) != 0.0) {
            if (this.equals(e, k)) {
                return false;
            }
            i = i + 1 & m;
        }
        this.keys[i] = k;
        return true;
    }

    @Override
    protected void rehash() {
        double[] old = this.keys;
        this.keys = new double[this.capacity << 1];
        for (double v : old) {
            if (v == 0.0) continue;
            this.place(v);
        }
    }

    protected final void deleteAt(int index) {
        double v;
        assert (this.keys[index] != 0.0);
        this.keys[index] = 0.0;
        --this.size;
        int m = this.keys.length - 1;
        int i = index + 1 & m;
        while ((v = this.keys[i]) != 0.0) {
            this.keys[i] = 0.0;
            this.place(v);
            i = i + 1 & m;
        }
    }

    protected int hash(double v) {
        return Hashing.hash(v);
    }

    protected boolean equals(double a, double b) {
        return Hashing.equals(a, b);
    }

    @Override
    protected final boolean toString_appendZero(StringBuilder out) {
        if (!this.zero) {
            return false;
        }
        out.append(0.0);
        return true;
    }

    @Override
    protected final boolean toString_appendItem(int index, StringBuilder out) {
        double e = this.keys[index];
        if (e == 0.0) {
            return false;
        }
        out.append(e);
        return true;
    }

    public int fillFactor() {
        int f = 0;
        int m = 0;
        for (double v : this.keys) {
            if (v != 0.0) {
                ++f;
                continue;
            }
            if (m < f) {
                m = f;
            }
            f = 0;
        }
        if (m < f) {
            m = f;
        }
        return m;
    }
}

