/*
 * Decompiled with CFR 0.152.
 */
package inform.adt.collections;

import inform.adt.collections.AbstractSet;
import java.util.Iterator;

public class IntHashMap<T>
extends AbstractSet
implements Iterable<Cursor<T>> {
    private T zerov;
    private int[] keys;
    private Object[] vals;
    private Object lc;

    public IntHashMap() {
        this.keys = new int[this.capacity];
        this.vals = new Object[this.capacity];
    }

    @Override
    public void clear() {
        super.clear();
        for (int i = 0; i < this.capacity; ++i) {
            this.keys[i] = 0;
        }
    }

    public void put(int k, T v) {
        if (k == 0) {
            this.zerov = v;
            this.addZero();
            return;
        }
        this.rehashIfNeed();
        if (this.place(k, v)) {
            ++this.size;
        }
    }

    public T get(int k) {
        int e;
        if (k == 0) {
            return this.zerov;
        }
        int m = this.mask;
        int i = k & m;
        while ((e = this.keys[i]) != 0) {
            if (e == k) {
                return (T)this.vals[i];
            }
            i = i + 1 & m;
        }
        return null;
    }

    public boolean contains(int k) {
        int e;
        if (k == 0) {
            this.lc = this.zerov;
            return this.zero;
        }
        int m = this.mask;
        int i = k & m;
        while ((e = this.keys[i]) != 0) {
            if (e == k) {
                this.lc = this.vals[i];
                return true;
            }
            i = i + 1 & m;
        }
        return false;
    }

    public T lget() {
        return (T)this.lc;
    }

    public boolean remove(int k) {
        int e;
        if (k == 0) {
            return this.remZero();
        }
        int m = this.mask;
        int i = k & m;
        while ((e = this.keys[i]) != 0) {
            if (e == k) {
                --this.size;
                this.sck(i);
                return true;
            }
            i = i + 1 & m;
        }
        return false;
    }

    @Override
    public Iterator<Cursor<T>> iterator() {
        return new Iterator<Cursor<T>>(){
            final Cursor<T> cursor = new Cursor();
            boolean has;
            int idx;
            {
                this.has = IntHashMap.this.zero;
                this.cursor.value = IntHashMap.this.zerov;
            }

            @Override
            public final boolean hasNext() {
                while (!this.has && this.idx < IntHashMap.this.capacity) {
                    this.cursor.key = IntHashMap.this.keys[this.idx];
                    this.has = this.cursor.key != 0;
                    if (this.has) {
                        this.cursor.value = IntHashMap.this.vals[this.idx];
                    }
                    ++this.idx;
                }
                return this.has;
            }

            @Override
            public final Cursor<T> next() {
                this.has = false;
                return this.cursor;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private boolean place(int k, Object v) {
        int e;
        int m = this.mask;
        int i = k & m;
        while ((e = this.keys[i]) != 0) {
            if (e == k) {
                this.vals[i] = v;
                return false;
            }
            i = i + 1 & m;
        }
        this.keys[i] = k;
        this.vals[i] = v;
        return true;
    }

    @Override
    protected void rehash() {
        int[] ok = this.keys;
        Object[] ov = this.vals;
        this.keys = new int[this.capacity];
        this.vals = new Object[this.capacity];
        for (int i = ok.length - 1; i >= 0; --i) {
            int k = ok[i];
            if (k == 0) continue;
            this.place(k, ov[i]);
        }
    }

    private void sck(int i) {
        int m = this.mask;
        while (true) {
            int e;
            int p = i;
            i = i + 1 & m;
            while ((e = this.keys[i]) != 0) {
                int o = e & m;
                if (p <= i ? p >= o || o > i : p >= o && o > i) break;
                i = i + 1 & m;
            }
            if (this.keys[i] == 0) break;
            this.keys[p] = this.keys[i];
            this.vals[p] = this.vals[i];
        }
        this.keys[p] = 0;
    }

    @Override
    protected boolean toString_appendZero(StringBuilder out) {
        if (!this.zero) {
            return false;
        }
        out.append(this.zerov);
        return true;
    }

    @Override
    protected final boolean toString_appendItem(int index, StringBuilder out) {
        int k = this.keys[index];
        if (k == 0) {
            return false;
        }
        out.append(k).append(':').append(this.vals[index]);
        return true;
    }

    public static class Cursor<T> {
        public int key;
        public T value;

        public String toString() {
            return Integer.toString(this.key) + "=>" + String.valueOf(this.value);
        }
    }
}

