/*
 * Decompiled with CFR 0.152.
 */
package inform.adt.collections;

import inform.adt.collections.AbstractSet;
import inform.adt.collections.Hashing;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ObjectIntegerMap
extends AbstractSet
implements Iterable<Cursor> {
    private int zerov;
    private Object[] keys;
    private int[] vals;
    private int lc;

    public ObjectIntegerMap() {
        int len = this.capacity << 1;
        this.keys = new Object[len];
        this.vals = new int[len];
    }

    @Override
    public void clear() {
        super.clear();
        int len = this.keys.length;
        for (int i = 0; i < len; ++i) {
            this.keys[i] = 0;
        }
    }

    public void put(Object k, int v) {
        if (this.zero(k)) {
            this.zerov = v;
            this.addZero();
            return;
        }
        this.rehashIfNeed();
        if (this.place(k, v)) {
            ++this.size;
        }
    }

    public boolean contains(Object k) {
        Object e;
        if (this.zero(k)) {
            this.lc = this.zerov;
            return this.zero;
        }
        int m = this.keys.length - 1;
        int i = (this.hash(k) & this.mask) << 1;
        while (!this.zero(e = this.keys[i])) {
            if (this.equals(e, k)) {
                this.lc = this.vals[i];
                return true;
            }
            i = i + 1 & m;
        }
        return false;
    }

    public int get(Object k, int defaultValue) {
        Object e;
        if (this.zero(k)) {
            return this.zerov;
        }
        int m = this.keys.length - 1;
        int i = (this.hash(k) & this.mask) << 1;
        while (!this.zero(e = this.keys[i])) {
            if (this.equals(e, k)) {
                return this.vals[i];
            }
            i = i + 1 & m;
        }
        return defaultValue;
    }

    public int lget() {
        return this.lc;
    }

    public boolean remove(Object k) {
        Object e;
        if (this.zero(k)) {
            return this.remZero();
        }
        int m = this.keys.length - 1;
        int i = (this.hash(k) & this.mask) << 1;
        while (!this.zero(e = this.keys[i])) {
            if (this.equals(e, k)) {
                this.deleteAt(i);
                return true;
            }
            i = i + 1 & m;
        }
        return false;
    }

    @Override
    public Iterator<Cursor> iterator() {
        return new Iterator<Cursor>(){
            final Cursor cursor = new Cursor();
            final int keysLen;
            boolean has;
            int idx;
            {
                this.keysLen = ObjectIntegerMap.this.keys.length;
                this.has = ObjectIntegerMap.this.zero;
                this.cursor.value = ObjectIntegerMap.this.zerov;
            }

            @Override
            public final boolean hasNext() {
                while (!this.has && this.idx < this.keysLen) {
                    this.cursor.key = ObjectIntegerMap.this.keys[this.idx];
                    this.has = !ObjectIntegerMap.this.zero(this.cursor.key);
                    if (this.has) {
                        this.cursor.value = ObjectIntegerMap.this.vals[this.idx];
                    }
                    ++this.idx;
                }
                return this.has;
            }

            @Override
            public final Cursor next() {
                if (this.idx > this.keysLen) {
                    throw new NoSuchElementException();
                }
                this.has = false;
                return this.cursor;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private boolean place(Object k, int v) {
        Object e;
        int m = this.keys.length - 1;
        int i = (this.hash(k) & this.mask) << 1;
        while (!this.zero(e = this.keys[i])) {
            if (this.equals(e, k)) {
                this.vals[i] = v;
                return false;
            }
            i = i + 1 & m;
        }
        this.keys[i] = k;
        this.vals[i] = v;
        return true;
    }

    @Override
    protected void rehash() {
        Object[] ok = this.keys;
        int[] ov = this.vals;
        int newLen = this.capacity << 1;
        this.keys = new Object[newLen];
        this.vals = new int[newLen];
        for (int i = ok.length - 1; i >= 0; --i) {
            Object k = ok[i];
            if (this.zero(k)) continue;
            this.place(k, ov[i]);
        }
    }

    protected final void deleteAt(int index) {
        Object k;
        assert (!this.zero(this.keys[index]));
        this.keys[index] = 0;
        --this.size;
        int m = this.keys.length - 1;
        int i = index + 1 & m;
        while (!this.zero(k = this.keys[i])) {
            int v = this.vals[i];
            this.keys[i] = 0;
            this.place(k, v);
            i = i + 1 & m;
        }
    }

    private boolean zero(Object k) {
        return k == Hashing.zero_Object;
    }

    protected int hash(Object k) {
        return Hashing.hash(k);
    }

    protected boolean equals(Object a, Object b) {
        return Hashing.equals(a, b);
    }

    @Override
    protected final boolean toString_appendZero(StringBuilder out) {
        if (!this.zero) {
            return false;
        }
        out.append((Object)0).append(':').append(this.zerov);
        return true;
    }

    @Override
    protected final boolean toString_appendItem(int index, StringBuilder out) {
        Object k = this.keys[index];
        if (this.zero(k)) {
            return false;
        }
        out.append(k).append(':').append(this.vals[index]);
        return true;
    }

    public int fillFactor() {
        int f = 0;
        int m = 0;
        for (Object k : this.keys) {
            if (!this.zero(k)) {
                ++f;
                continue;
            }
            if (m < f) {
                m = f;
            }
            f = 0;
        }
        if (m < f) {
            m = f;
        }
        return m;
    }

    public static class Cursor {
        public Object key;
        public int value;

        public String toString() {
            return this.key + "=>" + this.value;
        }
    }
}

