/*
 * Decompiled with CFR 0.152.
 */
package inform.adt.taggedio;

import inform.adt.LittleEndian;
import inform.adt.taggedio.AbstractTaggedReader;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;

public class TagReader
implements AbstractTaggedReader {
    private static final int DATA_BUFFER_SIZE = 16384;
    private int tag;
    private int currentSize;
    private byte[] data;

    public TagReader() {
        this(0, null, 0);
    }

    public TagReader(TagReader t) {
        this.tag = t.tag;
        this.data = t.data;
        this.currentSize = t.currentSize;
    }

    public TagReader(int tag, byte[] data) {
        this(tag, data, data == null ? 0 : data.length);
    }

    public TagReader(int tag, byte[] data, int dataSize) {
        this.tag = tag;
        this.currentSize = dataSize;
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getTag() {
        return this.tag;
    }

    public void setTag(int tag) {
        this.tag = tag;
    }

    public int getDataSize() {
        return this.currentSize;
    }

    public void setDataSize(int dataSize) {
        int length;
        this.currentSize = dataSize;
        int n = length = this.data == null ? 0 : this.data.length;
        if (length > 16384 || length < dataSize) {
            this.data = new byte[dataSize];
        }
    }

    @Override
    public int getCurrentTag() {
        return this.tag;
    }

    @Override
    public int getCurrentTagSize() {
        return this.currentSize;
    }

    @Override
    public void checkCurrentTag(int tag) {
        if (this.tag != tag) {
            TaggedReader.throwInvalidTag();
        }
    }

    @Override
    public void checkCurrentTag(int tag, int tagSize) throws TaggedReaderException {
        if (this.tag != tag) {
            TaggedReader.throwInvalidTag();
        }
        if (this.currentSize != tagSize) {
            TaggedReader.throwInvalidTagSize(this.tag, this.currentSize, tagSize);
        }
    }

    @Override
    public void getSignature() throws TaggedReaderException {
        if (this.tag != 201 || this.currentSize != 6) {
            TaggedReader.throwInvalidFormat();
        }
        if (this.data[0] != 116 || this.data[1] != 105 || this.data[2] != 111 || this.data[3] != 0 || this.data[5] != 0 || this.data[4] != 1) {
            TaggedReader.throwInvalidFormat();
        }
    }

    @Override
    public void getRaw(byte[] data, int data_size) {
        if (this.currentSize != data_size) {
            TaggedReader.throwInvalidTagSize();
        }
        for (int i = 0; i < data_size; ++i) {
            data[i] = this.data[i];
        }
    }

    @Override
    public boolean getBoolean() {
        switch (this.currentSize) {
            case 0: {
                return true;
            }
            case 1: {
                return this.data[0] != 0;
            }
        }
        TaggedReader.throwInvalidTagSize();
        return false;
    }

    @Override
    public boolean getBooleanDef(boolean def) {
        switch (this.currentSize) {
            case 0: {
                return def;
            }
            case 1: {
                return this.data[0] != 0;
            }
        }
        TaggedReader.throwInvalidTagSize();
        return false;
    }

    @Override
    public byte getByte() {
        if (this.currentSize != 1) {
            TaggedReader.throwInvalidTagSize();
        }
        return this.data[0];
    }

    @Override
    public int getInt() throws TaggedReaderException {
        if (this.currentSize != 4) {
            TaggedReader.throwInvalidTagSize();
        }
        return LittleEndian.getInt(this.data, 0);
    }

    @Override
    public long getUnsignedInt() {
        if (this.currentSize != 4) {
            TaggedReader.throwInvalidTagSize();
        }
        return LittleEndian.getUInt(this.data, 0);
    }

    @Override
    public double getDouble() {
        if (this.currentSize != 8) {
            TaggedReader.throwInvalidTagSize();
        }
        return LittleEndian.getDouble(this.data, 0);
    }

    @Override
    public String getAnsi() {
        return new String(this.data, 0, this.currentSize, TaggedWriter.ANSI);
    }

    @Override
    public String getString() {
        String val = this.currentSize > 2 && this.data[0] == 7 && this.data[1] == 11 ? new String(this.data, 2, this.currentSize - 2, TaggedWriter.UTF8) : new String(this.data, 0, this.currentSize, TaggedWriter.ANSI);
        return val;
    }

    @Override
    public String getUnicode() {
        return new String(this.data, 0, this.currentSize, TaggedWriter.UTF16LE);
    }

    @Override
    public byte[] getRaw() {
        if (this.currentSize == this.data.length) {
            return this.data;
        }
        return Arrays.copyOf(this.data, this.currentSize);
    }

    @Override
    public InputStream getStream() {
        return new ByteArrayInputStream(this.getRaw());
    }

    @Override
    public TaggedReader getStreamReader() {
        return new TaggedReader(this.getStream());
    }

    @Override
    public void transferTag(TaggedWriter writer) throws Exception {
        writer.putRaw(this.tag, this.getRaw());
    }
}

