/*
 * Decompiled with CFR 0.152.
 */
package inform.agent;

import inform.adt.collections.LongHash;
import inform.agent.Core;
import java.util.ArrayList;
import java.util.Iterator;

public class ActionHooks {
    public static final int MAX_LONG_TIMEOUT = 2280000;
    private static final LongHash<ThreadHooks> threadsHooks = new LongHash();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(Hook hook) {
        ThreadHooks hooks;
        hook.autohookTime = Long.MAX_VALUE;
        hook.hooked = 0;
        ThreadHooks threadHooks = hooks = ActionHooks.threadHooks();
        synchronized (threadHooks) {
            hooks.add(hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ThreadHooks threadHooks() {
        ThreadHooks hooks;
        Thread thread = Thread.currentThread();
        long threadId = thread.getId();
        LongHash<ThreadHooks> longHash = threadsHooks;
        synchronized (longHash) {
            hooks = threadsHooks.get(threadId);
            if (hooks == null) {
                hooks = new ThreadHooks(thread);
                threadsHooks.add(hooks);
            }
        }
        return hooks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(Hook hook) {
        ThreadHooks hooks;
        ThreadHooks threadHooks = hooks = ActionHooks.threadHooks();
        synchronized (threadHooks) {
            if (!hooks.remove(hook)) {
                throw new IllegalArgumentException("Hook \"" + hook + "\" not registered for thread " + Thread.currentThread());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void hookThreadActions(long threadId, String cause) {
        ThreadHooks hooks;
        Core.logger.debug("Hook thread [{}]", threadId);
        LongHash<ThreadHooks> longHash = threadsHooks;
        synchronized (longHash) {
            hooks = threadsHooks.get(threadId);
            if (hooks == null) {
                return;
            }
        }
        long autohookTime = System.currentTimeMillis() + 3000L;
        ThreadHooks threadHooks = hooks;
        synchronized (threadHooks) {
            for (Hook h : hooks) {
                h.setAutohookTime(autohookTime, cause);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Duration maxThreadDuration(long threadId) {
        ThreadHooks hooks;
        Iterable<ThreadHooks> iterable = threadsHooks;
        synchronized (iterable) {
            hooks = threadsHooks.get(threadId);
        }
        if (hooks == null) {
            return Duration.NORMAL;
        }
        iterable = hooks;
        synchronized (iterable) {
            Duration max = Duration.NORMAL;
            for (Hook h : hooks) {
                Duration d = h.duration;
                if (d.ordinal() <= max.ordinal()) continue;
                max = d;
            }
            return max;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void autoHook(long time) {
        LongHash<ThreadHooks> longHash = threadsHooks;
        synchronized (longHash) {
            Iterator iterator = threadsHooks.iterator();
            while (iterator.hasNext()) {
                ThreadHooks hooks;
                ThreadHooks threadHooks = hooks = (ThreadHooks)iterator.next();
                synchronized (threadHooks) {
                    boolean notified = false;
                    for (Hook h : hooks) {
                        try {
                            Hook hook = h;
                            synchronized (hook) {
                                if (time < h.autohookTime) {
                                    continue;
                                }
                                if (!notified) {
                                    notified = true;
                                    Core.logger.info("AutoHooks({},{})", (Object)hooks.name, (Object)h.who);
                                }
                                h.hook();
                                ++h.hooked;
                                h.autohookTime = time + 60000L;
                            }
                        }
                        catch (Throwable e) {
                            Core.logger.error("AutoHooks->hook", e);
                        }
                    }
                }
            }
        }
    }

    private static class ThreadHooks
    extends ArrayList<Hook>
    implements LongHash.Entry {
        private final long id;
        private final String name;

        public ThreadHooks(Thread t) {
            this.id = t.getId();
            this.name = t.getName();
        }

        @Override
        public long key() {
            return this.id;
        }
    }

    public static abstract class Hook {
        private final String who;
        private volatile Duration duration = Duration.NORMAL;
        private long autohookTime;
        protected int hooked;
        protected String cause;

        public Hook(String who) {
            this.who = who;
        }

        public void beginLongOperation(long time, long timeout) {
            if (timeout > 0L) {
                this.setAutohookTime(time + timeout, "timeout");
            }
            this.duration = timeout > 2280000L ? Duration.VERY_LONG : Duration.LONG;
        }

        public void endLongOperation() {
            this.duration = Duration.NORMAL;
            if (this.autohookTime != Long.MAX_VALUE) {
                this.setAutohookTime(Long.MAX_VALUE, null);
            }
        }

        protected abstract void hook() throws Throwable;

        protected synchronized void setAutohookTime(long time, String cause) {
            this.cause = cause;
            this.autohookTime = time;
        }
    }

    public static enum Duration {
        NORMAL,
        LONG,
        VERY_LONG;

    }
}

