/*
 * Decompiled with CFR 0.152.
 */
package inform.agent;

import com.sun.security.auth.callback.TextCallbackHandler;
import inform.adt.IO;
import inform.adt.InformException;
import inform.adt.Strings;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TagReader;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.net.AgentConnection;
import inform.common.Base64BinString;
import inform.common.Empty;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.util.HashMap;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.Oid;

public abstract class ActiveDirectory {
    protected boolean _logAD = true;

    public static String getComputerDomainName() {
        if (Ini.Unix || !Strings.isVoid(Ini.ComputerDomainName)) {
            return Ini.ComputerDomainName;
        }
        return Windows.getCompDomainName();
    }

    public static ActiveDirectory createInstance(int authorizationType) {
        InetSocketAddress address;
        if (!Strings.isVoid(Ini.ADProxy) && !(address = AgentConnection.s2a(Ini.ADProxy)).isUnresolved()) {
            return new ADProxy(address);
        }
        if (Ini.Unix) {
            if (authorizationType == 0) {
                return new Unix();
            }
            return new Windows(authorizationType);
        }
        return new Windows(authorizationType);
    }

    public static ActiveDirectory createInstance() {
        return ActiveDirectory.createInstance(0);
    }

    public abstract void close();

    public abstract byte[] process(byte[] var1);

    public abstract byte[] processRaw(byte[] var1);

    public abstract boolean isSuccessful();

    public abstract String getUserName();

    private static class SaslGss
    extends ActiveDirectory {
        final String domain;
        final GSSManager manager;
        final GSSContext context;
        String userName = "";
        int frameNo = -1;

        SaslGss(String domainName) {
            this.domain = domainName;
            try {
                this.manager = GSSManager.getInstance();
                Oid kerberosOid = new Oid("1.2.840.113554.1.2.2");
                Oid spnegoOid = new Oid("1.3.6.1.5.5.2");
                Oid spnegoOid2 = new Oid("1.2.840.113554.1.2.2.3");
                Oid ntlmsppOid = new Oid("1.3.6.1.4.1.311.2.2.10");
                Object mechs = null;
                GSSCredential credential = this.manager.createCredential(this.manager.createName(domainName, null), 0, ntlmsppOid, 2);
                this.context = this.manager.createContext(credential);
            }
            catch (GSSException e) {
                throw InformException.wrap(e);
            }
        }

        @Override
        public void close() {
            try {
                this.context.dispose();
            }
            catch (GSSException e) {
                throw InformException.wrap(e);
            }
        }

        @Override
        public byte[] process(byte[] data) {
            try {
                TaggedReader reader = new TaggedReader(data);
                while (reader.next()) {
                    if (reader.getCurrentTag() != 1) continue;
                    reader.skipInt();
                    data = reader.getRaw(202);
                    data = this.processRaw(data);
                    ByteArrayOutputStream result = new ByteArrayOutputStream();
                    TaggedWriter writer = new TaggedWriter(result);
                    writer.putInt32(1, ++this.frameNo);
                    writer.putRaw(202, data);
                    writer.flush();
                    return result.toByteArray();
                }
            }
            catch (IOException e) {
                throw InformException.wrap(e);
            }
            throw new Error("TAG_AD_ATHORIZATION_DATA not found");
        }

        @Override
        public byte[] processRaw(byte[] data) {
            try {
                return this.context.acceptSecContext(data, 0, data.length);
            }
            catch (GSSException e) {
                throw InformException.wrap(e);
            }
        }

        @Override
        public boolean isSuccessful() {
            return this.context.isEstablished();
        }

        @Override
        public String getUserName() {
            try {
                return this.context.getSrcName().toString();
            }
            catch (GSSException e) {
                throw InformException.wrap(e);
            }
        }
    }

    private static class SaslGSSAPI
    extends ActiveDirectory {
        final String domain;
        final SaslServer server;
        int frameNo = -1;

        SaslGSSAPI(String domainName) {
            this.domain = Strings.isVoid(domainName) ? Ini.ComputerDomainName : domainName;
            try {
                this.server = Sasl.createSaslServer("GSSAPI", "ppp@" + domainName, null, null, new TextCallbackHandler());
            }
            catch (SaslException e) {
                throw InformException.wrap(e);
            }
        }

        @Override
        public void close() {
            try {
                this.server.dispose();
            }
            catch (SaslException e) {
                throw InformException.wrap(e);
            }
        }

        @Override
        public byte[] process(byte[] data) {
            try {
                TaggedReader reader = new TaggedReader(data);
                while (reader.next()) {
                    if (reader.getCurrentTag() != 1) continue;
                    reader.skipInt();
                    data = reader.getRaw(202);
                    data = this.processRaw(data);
                    ByteArrayOutputStream result = new ByteArrayOutputStream();
                    TaggedWriter writer = new TaggedWriter(result);
                    writer.putInt32(1, ++this.frameNo);
                    writer.putRaw(202, data);
                    writer.flush();
                    return result.toByteArray();
                }
            }
            catch (IOException e) {
                throw InformException.wrap(e);
            }
            throw new Error("TAG_AD_ATHORIZATION_DATA not found");
        }

        @Override
        public byte[] processRaw(byte[] data) {
            try {
                return this.server.evaluateResponse(data);
            }
            catch (SaslException e) {
                throw InformException.wrap(e);
            }
        }

        @Override
        public boolean isSuccessful() {
            return this.server.isComplete();
        }

        @Override
        public String getUserName() {
            return this.server.getAuthorizationID();
        }
    }

    private static class SaslNtlm
    extends ActiveDirectory {
        final String domain;
        final SaslServer server;
        int frameNo = -1;

        SaslNtlm(String domainName) {
            System.setProperty("ntlm.debug", "true");
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("com.sun.security.sasl.ntlm.version", "LMv2/NTLMv2");
            this.domain = Strings.isVoid(domainName) ? Ini.ComputerDomainName : domainName;
            try {
                this.server = Sasl.createSaslServer("NTLM", "pl/PL." + domainName, domainName, null, new TextCallbackHandler());
            }
            catch (SaslException e) {
                throw InformException.wrap(e);
            }
        }

        @Override
        public void close() {
            try {
                this.server.dispose();
            }
            catch (SaslException e) {
                throw InformException.wrap(e);
            }
        }

        @Override
        public byte[] process(byte[] data) {
            try {
                TaggedReader reader = new TaggedReader(data);
                while (reader.next()) {
                    if (reader.getCurrentTag() != 1) continue;
                    reader.skipInt();
                    data = reader.getRaw(202);
                    data = this.processRaw(data);
                    ByteArrayOutputStream result = new ByteArrayOutputStream();
                    TaggedWriter writer = new TaggedWriter(result);
                    writer.putInt32(1, ++this.frameNo);
                    writer.putRaw(202, data);
                    writer.flush();
                    return result.toByteArray();
                }
            }
            catch (IOException e) {
                throw InformException.wrap(e);
            }
            throw new Error("TAG_AD_ATHORIZATION_DATA not found");
        }

        @Override
        public byte[] processRaw(byte[] data) {
            try {
                return this.server.evaluateResponse(data);
            }
            catch (SaslException e) {
                throw InformException.wrap(e);
            }
        }

        @Override
        public boolean isSuccessful() {
            return this.server.isComplete();
        }

        @Override
        public String getUserName() {
            return this.server.getAuthorizationID();
        }
    }

    private static class ADProxy
    extends ActiveDirectory {
        private final InetSocketAddress address;
        private AgentConnection.TaggedSocket socket = null;
        private int no = 0;
        private boolean successful = false;
        private String userName = null;
        private static final int TAG_AD_PROXY_DATA = 1;
        private static final int TAG_AD_PROXY_ERROR = 2;
        private static final int TAG_AD_PROXY_USER_NAME = 3;

        public ADProxy(InetSocketAddress address) {
            this.address = address;
        }

        @Override
        public void close() {
            if (this.socket != null) {
                AgentConnection.TaggedSocket s = this.socket;
                this.socket = null;
                try {
                    s.close();
                }
                catch (IOException e) {
                    Core.logger.error(null, e);
                }
            }
        }

        @Override
        public byte[] process(byte[] data) {
            try {
                if (this.socket == null) {
                    this.socket = new AgentConnection.TaggedSocket(null, this.address);
                    this.socket.out.putSignature();
                    this.socket.out.putInt32(7, 10);
                    this.socket.out.putRaw(130, data);
                    this.socket.out.flush();
                    this.socket.waitTag().getSignature();
                    int version = this.socket.waitTag(7).getInt();
                    if (version != 10) {
                        throw new InformException(String.format("\u041d\u0435\u0441\u043e\u0432\u043f\u0430\u0434\u0435\u043d\u0438\u0435 \u0432\u0435\u0440\u0441\u0438\u0439 \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0430 \u0432\u0437\u0430\u0438\u043c\u043e\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e(%d) \u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430(%d)", 10, version));
                    }
                } else {
                    this.socket.out.putRaw(130, data);
                    this.socket.out.flush();
                }
                data = Empty.byteArray;
                boolean processing = true;
                while (processing) {
                    TagReader reader = this.socket.waitTag();
                    switch (reader.getTag()) {
                        case 13: {
                            throw new InformException(reader.getString());
                        }
                        case 130: {
                            TaggedReader in = reader.getStreamReader();
                            while (in.next()) {
                                switch (in.getCurrentTag()) {
                                    case 1: {
                                        data = in.getRaw();
                                        break;
                                    }
                                    case 3: {
                                        this.userName = in.getString();
                                        this.successful = true;
                                        break;
                                    }
                                    case 2: {
                                        throw new InformException(in.getString());
                                    }
                                }
                            }
                            processing = false;
                        }
                    }
                }
                return data;
            }
            catch (Exception e) {
                throw InformException.wrap(e);
            }
        }

        @Override
        public byte[] processRaw(byte[] data) {
            ByteArrayOutputStream out = new ByteArrayOutputStream(data.length + 64);
            TaggedWriter w = new TaggedWriter(out);
            try {
                w.putInt32(1, this.no++);
                w.putRaw(202, data);
                w.flush();
            }
            catch (IOException e) {
                throw InformException.wrap(e);
            }
            byte[] response = this.process(out.toByteArray());
            TaggedReader r = new TaggedReader(response);
            try {
                while (r.next()) {
                    if (r.getCurrentTag() != 202) continue;
                    return r.getRaw();
                }
            }
            catch (IOException e) {
                throw InformException.wrap(e);
            }
            return Empty.byteArray;
        }

        @Override
        public boolean isSuccessful() {
            return this.successful;
        }

        @Override
        public String getUserName() {
            return this.userName;
        }
    }

    private static class Unix
    extends ActiveDirectory {
        static String[] CMD_ARRAY = new String[]{"ntlm_auth", "--helper-protocol=gss-spnego"};
        final Process handle;
        final BufferedReader input;
        final InputStream error;
        final Writer output;
        int no;
        boolean initialized;
        String fineUserName;

        private Unix() {
            try {
                this.handle = Runtime.getRuntime().exec(CMD_ARRAY);
                this.input = new BufferedReader(new InputStreamReader(this.handle.getInputStream()));
                this.error = this.handle.getErrorStream();
                this.output = new OutputStreamWriter(this.handle.getOutputStream());
                if (this._logAD) {
                    Core.logger.info("AD: launch process {} {}", CMD_ARRAY);
                }
            }
            catch (Throwable e) {
                throw InformException.wrap(e);
            }
        }

        @Override
        public void close() {
            this.handle.destroy();
            if (this._logAD) {
                Core.logger.info("AD: close process {}", (Object)CMD_ARRAY);
            }
        }

        @Override
        public byte[] process(byte[] data) {
            try {
                TaggedReader reader = new TaggedReader(data);
                while (reader.next()) {
                    if (reader.getCurrentTag() != 1) continue;
                    reader.skipInt();
                    data = reader.getRaw(202);
                    data = this.processRaw(data);
                    ByteArrayOutputStream result = new ByteArrayOutputStream();
                    TaggedWriter writer = new TaggedWriter(result);
                    writer.putInt32(1, this.no++);
                    writer.putRaw(202, data);
                    writer.flush();
                    return result.toByteArray();
                }
            }
            catch (IOException e) {
                throw InformException.wrap(e);
            }
            throw new Error("TAG_ADA_ATHORIZATION_DATA not found");
        }

        @Override
        public byte[] processRaw(byte[] data) {
            try {
                String response;
                String rq;
                if (!this.initialized) {
                    this.initialized = true;
                    rq = "YR ";
                } else {
                    rq = "KK ";
                }
                Core.logger.info("ad-rq: {}[length={}]", (Object)rq, (Object)data.length);
                this.output.append(rq);
                this.output.append(Base64BinString.Encode(data)).append('\n').flush();
                if (this._logAD) {
                    Core.logger.info("AD: {} << {}", (Object)CMD_ARRAY[0], (Object)Base64BinString.Encode(data));
                }
                if ((response = this.input.readLine()) == null) {
                    throw new Error("Unexpected end of stream");
                }
                if (this._logAD) {
                    Core.logger.info("AD: {} >> {}", (Object)CMD_ARRAY[0], (Object)response);
                }
                String type = response.substring(0, 2);
                String payload = response.length() > 2 ? response.substring(3) : "";
                Core.logger.info("ad-rs: {} [length={}]", (Object)type, (Object)payload.length());
                if ("AF".equals(type)) {
                    this.fineUserName = response.split("\\\\")[1];
                    return Base64BinString.Decode(payload.split(" ")[0]);
                }
                if (!"TT".equals(type)) {
                    throw new Error(response);
                }
                return Base64BinString.Decode(payload);
            }
            catch (Exception e) {
                ByteArrayOutputStream tail = new ByteArrayOutputStream();
                try {
                    IO.readAvailable(this.error, tail);
                }
                catch (Exception e2) {
                    Core.logger.error("read-error-stream", e2);
                }
                if (tail.size() != 0) {
                    throw InformException.detail(e, "tail='" + new String(tail.internalBuffer(), 0, tail.size()) + "'");
                }
                throw InformException.wrap(e);
            }
        }

        @Override
        public boolean isSuccessful() {
            return this.fineUserName != null;
        }

        @Override
        public String getUserName() {
            return this.fineUserName;
        }
    }

    private static class Windows
    extends ActiveDirectory {
        private long handle;
        private int no;

        private native long open(int var1);

        private native void close(long var1);

        private static native byte[] process(long var0, byte[] var2);

        private native boolean isSuccessful(long var1);

        private native String getUserName(long var1);

        private static native String getCompDomainName();

        Windows(int authType) {
            this.handle = this.open(authType);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Windows windows = this;
            synchronized (windows) {
                this.close(this.handle);
                this.handle = 0L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] process(byte[] data) {
            Windows windows = this;
            synchronized (windows) {
                return Windows.process(this.handle, data);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] processRaw(byte[] data) {
            Windows windows = this;
            synchronized (windows) {
                ByteArrayOutputStream out = new ByteArrayOutputStream(data.length + 64);
                TaggedWriter w = new TaggedWriter(out);
                try {
                    w.putInt32(1, this.no++);
                    w.putRaw(202, data);
                    w.flush();
                }
                catch (IOException e) {
                    throw InformException.wrap(e);
                }
                byte[] response = Windows.process(this.handle, out.toByteArray());
                if (response == null) {
                    Core.logger.warn("ActiveDirectory.Windows.processRaw native AD process return null result");
                } else {
                    TaggedReader r = new TaggedReader(response);
                    try {
                        while (r.next()) {
                            if (r.getCurrentTag() != 202) continue;
                            return r.getRaw();
                        }
                    }
                    catch (IOException e) {
                        throw InformException.wrap(e);
                    }
                }
            }
            return Empty.byteArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isSuccessful() {
            Windows windows = this;
            synchronized (windows) {
                return this.isSuccessful(this.handle);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getUserName() {
            Windows windows = this;
            synchronized (windows) {
                return this.getUserName(this.handle);
            }
        }
    }

    public static class Error
    extends InformException {
        public Error(String message) {
            super(message);
        }

        public Error(String message, String detailing) {
            super(message);
            this.detail(detailing);
        }
    }
}

