/*
 * Decompiled with CFR 0.152.
 */
package inform.agent;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.PhaThread;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.DatabaseInfo;
import inform.agent.db.connect.DatabaseType;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.common.IdGenerator;
import inform.common.TemplateIDGenerator;
import java.sql.SQLException;

public class AsmoTemplateIDGenerator
extends TemplateIDGenerator {
    private DatabaseDescriptor database;
    private static AsmoTemplateIDGenerator g;
    private static final int COUNT_DOWN_ESCALATION = 10;
    private static final int FREE_ASMO_TEMPLATE_COUNT = 10;
    private static final double ASMO_TEMPLATE_SEQUENCE_SHIFT = 100.0;
    private static final double ASMO_TEMPLATE_NO_SHIFT = 1.0E11;
    private static final double ASMO_TEMPLATE_MAX_SEQUENCE = 9.99999999E8;
    private static final double ASMO_TEMPLATE_MAX_FUNCTION = 9.999999999999E12;
    private static final double firstTemplatePart;
    private final Object mutex = new Object();
    private final double[] freeTemplates = new double[20];
    private int freeTemplateCount = 0;
    private String errorMessage = null;
    private int startEscalation = 10;

    private AsmoTemplateIDGenerator() throws InformException, SQLException {
        DatabaseInfo dbInfo = new DatabaseInfo();
        dbInfo.databaseId = -2.0;
        dbInfo.databaseType = DatabaseType.get(Ini.ServerIdGeneratorDBKind);
        dbInfo.server = Ini.ServerIdGeneratorDB;
        dbInfo.userName = Ini.ServerIdGeneratorSchem;
        dbInfo.password = Ini.ServerIdGeneratorPassword;
        this.database = DatabaseDescriptor.getDatabase(dbInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check() throws InformException, SQLException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.freeTemplateCount > 0) {
                return;
            }
        }
        this.database.connectPrivileged("AsmoTemplateIDGenerator::check").close();
    }

    public static void init() throws InformException, SQLException {
        if (Ini.ServerIdGeneratorNo <= 0 && Strings.isVoid(Ini.ServerIdGeneratorFunction)) {
            Core.logger.info("Standard ID generator");
            return;
        }
        if (Ini.ServerIdGeneratorNo > 0 && !Strings.isVoid(Ini.ServerIdGeneratorFunction)) {
            throw new InformException("\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 \u0442\u0438\u043f\u043e\u0432 \u0433\u0435\u043d\u0435\u0440\u0430\u0442\u043e\u043f\u043e\u0432 ID: \u0437\u0430\u0434\u0430\u043d\u044b \u043e\u0434\u043d\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043e \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0442\u0438\u043f\u043e\u0432 \u0433\u0435\u043d\u0435\u0440\u0430\u0442\u043e\u0440\u043e\u0432");
        }
        if (Ini.ServerIdGeneratorNo > 0) {
            Core.logger.info("Sequence ID generator(no: {} db_type: {} db: {} login: {} sequence: GEN{})", Ini.ServerIdGeneratorNo, Ini.ServerIdGeneratorDBType, Ini.ServerIdGeneratorDB, Ini.ServerIdGeneratorSchem, Ini.ServerIdGeneratorNo);
        } else {
            Core.logger.info("Function ID generator(function: {} db_type: {} db: {} login: {} sequence: GEN{})", Ini.ServerIdGeneratorFunction, Ini.ServerIdGeneratorDBType, Ini.ServerIdGeneratorDB, Ini.ServerIdGeneratorSchem, Ini.ServerIdGeneratorNo);
        }
        g = new AsmoTemplateIDGenerator();
        PhaThread.daemonize(new AsmoIDTemplateChecker(g));
        IdGenerator.setTemplateGenerator(g);
    }

    public static void checkReady() throws InformException, SQLException {
        if (g != null) {
            g.check();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double generateTemplate() throws InformException {
        double sequence;
        Object object = this.mutex;
        synchronized (object) {
            while (this.freeTemplateCount == 0) {
                if (this.errorMessage != null) {
                    throw new InformException(this.errorMessage);
                }
                try {
                    this.mutex.wait(1000L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw InformException.wrap(ex);
                }
            }
            sequence = this.freeTemplates[--this.freeTemplateCount];
            this.mutex.notifyAll();
        }
        return firstTemplatePart + sequence * 100.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateTemplates() throws InformException, SQLException {
        double maxTemplateValue;
        int count;
        Object object = this.mutex;
        synchronized (object) {
            if (this.startEscalation > 0) {
                count = 1;
                --this.startEscalation;
            } else {
                count = 10 - this.freeTemplateCount;
            }
        }
        if (count <= 0) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select ");
        DatabaseCaps caps = this.database.getDatabaseType().caps();
        if (Ini.ServerIdGeneratorNo > 0) {
            maxTemplateValue = 9.99999999E8;
            String sn = "GEN" + Ini.ServerIdGeneratorNo;
            caps.appendSequenceToFields(this.database, sn, sql);
            sql.append(" as f");
        } else {
            maxTemplateValue = 9.999999999999E12;
            caps.appendSequenceToFields(this.database, Ini.ServerIdGeneratorFunction, sql);
            sql.append(" as f");
        }
        sql.append(" from (");
        String dlm = "";
        for (int i = 0; i < count; ++i) {
            sql.append(dlm);
            sql.append("select 1 as f0");
            sql.append(caps.getEmptyFromSQL());
            dlm = " union all ";
        }
        sql.append(") q");
        double[] templates = new double[10];
        try (DatabaseConnection connection = this.database.connectPrivileged("AsmoTemplateIDGenerator::updateTemplates");){
            try (PreparedStatement statement = connection.prepareStatement("AsmoIDTemplateChecker updateTemplates", sql.toString());
                 ResultSet resultSet = statement.executeQuery(null);){
                for (int i = 0; i < count; ++i) {
                    if (!resultSet.next()) {
                        Object object2 = this.mutex;
                        synchronized (object2) {
                            this.errorMessage = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0448\u0430\u0431\u043b\u043e\u043d\u0430 ID: \u0441\u0435\u0440\u0432\u0435\u0440 \u0411\u0414 \u043d\u0435 \u0432\u0435\u0440\u043d\u0443\u043b \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u0432";
                            Core.logger.error(this.errorMessage);
                            return;
                        }
                    }
                    double value = resultSet.getDouble(1);
                    if (resultSet.wasNull()) {
                        Object object3 = this.mutex;
                        synchronized (object3) {
                            this.errorMessage = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0448\u0430\u0431\u043b\u043e\u043d\u0430 ID: \u0441\u0435\u0440\u0432\u0435\u0440 \u0411\u0414 \u0432\u0435\u0440\u043d\u0443\u043b null-\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0448\u0430\u0431\u043b\u043e\u043d\u0430";
                            Core.logger.error(this.errorMessage);
                            return;
                        }
                    }
                    templates[i] = value + 1.0;
                    if (!(templates[i] > maxTemplateValue)) continue;
                    Object object4 = this.mutex;
                    synchronized (object4) {
                        this.errorMessage = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0448\u0430\u0431\u043b\u043e\u043d\u0430 ID: \u043f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u043e \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0448\u0430\u0431\u043b\u043e\u043d\u0430";
                        Core.logger.error(this.errorMessage);
                        return;
                    }
                }
            }
            connection.commit();
        }
        Object object5 = this.mutex;
        synchronized (object5) {
            this.errorMessage = null;
            for (int i = 0; i < count; ++i) {
                this.freeTemplates[this.freeTemplateCount++] = templates[i];
            }
            this.mutex.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkTemplateQueue() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.freeTemplateCount == 10) {
                this.mutex.wait(1000L);
            }
            if (this.freeTemplateCount > 0 && (this.freeTemplateCount == 10 || this.startEscalation > 0)) {
                this.mutex.wait(1000L);
                return;
            }
        }
        for (int tryCounter = 0; tryCounter < 2; ++tryCounter) {
            try {
                this.updateTemplates();
                break;
            }
            catch (Throwable ex) {
                Core.logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0448\u0430\u0431\u043b\u043e\u043d\u0430 ID:", ex);
                Object object2 = this.mutex;
                synchronized (object2) {
                    this.errorMessage = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0448\u0430\u0431\u043b\u043e\u043d\u0430 ID: " + ex.toString();
                    continue;
                }
            }
        }
    }

    static {
        firstTemplatePart = (double)Ini.ServerIdGeneratorNo * 1.0E11;
    }

    private static class AsmoIDTemplateChecker
    implements Runnable {
        final AsmoTemplateIDGenerator generator;

        public AsmoIDTemplateChecker(AsmoTemplateIDGenerator generator) {
            this.generator = generator;
        }

        @Override
        public void run() {
            try {
                boolean first = true;
                while (true) {
                    this.generator.checkTemplateQueue();
                    if (!Strings.isVoid(this.generator.errorMessage)) {
                        if (first) break;
                        Thread.sleep(1000L);
                    }
                    first = false;
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                Core.logger.error(null, ex);
            }
        }
    }
}

