/*
 * Decompiled with CFR 0.152.
 */
package inform.agent;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.ProductInfo;
import inform.agent.VersionInfo;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ClientUpdateInfo {
    public static final int TAG_VERSION_MAJOR = 1;
    public static final int TAG_VERSION_MINOR = 2;
    public static final int TAG_VERSION_RELEASE = 3;
    public static final int TAG_VERSION_FILE_SIZE = 4;
    public static final int TAG_VERSION_FILE_NAME = 5;
    public static final int TAG_VERSION_ABSENT = 6;
    public static final int TAG_VERSION_BAD_LIST = 7;
    public static final int TAG_VERSION_MIRROR = 8;
    public static final int TAG_VERSION_CHANGES = 9;
    public static final int TAG_PRODUCT_INFO = 10;
    private static final FileExtentionFilter badFilter = new FileExtentionFilter(".bad");
    private static final FileExtentionFilter zipFilter = new FileExtentionFilter(".zip");
    private static VersionInfo dictionaryVersion;
    private static byte[] dictionary;

    public static ArrayList<VersionInfo> getBadVersions(ProductInfo product) throws IOException {
        ArrayList<VersionInfo> versions = new ArrayList<VersionInfo>();
        File dir = new File(Ini.PatchPath, product.folder());
        if (!dir.isDirectory()) {
            return versions;
        }
        String[] files = dir.list(badFilter);
        VersionInfo info = new VersionInfo();
        for (String file : files) {
            if (!info.parse(file, true)) continue;
            versions.add(new VersionInfo(info));
        }
        return versions;
    }

    public static File getMaxVersion(VersionInfo currentVersion, ArrayList<VersionInfo> badVersions, VersionInfo maxVersion, ProductInfo product) throws IOException {
        maxVersion.clear();
        File dir = new File(Ini.PatchPath, product.folder());
        if (!dir.isDirectory()) {
            return null;
        }
        File maxFile = null;
        File[] files = dir.listFiles(zipFilter);
        VersionInfo info = new VersionInfo();
        for (File file : files) {
            if (file.isDirectory() || !info.parse(file.getName(), true) || currentVersion != null && Ini.StrictUpdateClient && (currentVersion.getMajor() != info.getMajor() || currentVersion.getMinor() != info.getMinor()) || info.lessThen(maxVersion) || file.length() == 0L) continue;
            boolean isBad = false;
            for (VersionInfo bad : badVersions) {
                if (!info.equals(bad)) continue;
                isBad = true;
                break;
            }
            if (isBad || !Core.checkFileSafeOpen(file.getAbsolutePath())) continue;
            maxVersion.assign(info);
            maxFile = file;
        }
        return maxFile;
    }

    /*
     * Exception decompiling
     */
    public static String getChanges(File file, VersionInfo from) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[WHILELOOP]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static File getMaxRenewal(String folder, VersionInfo maxVersion) throws IOException {
        File dir = new File(new File(Ini.PatchPath), folder);
        File[] fileList = dir.listFiles(zipFilter);
        if (fileList == null) {
            return null;
        }
        VersionInfo version = new VersionInfo();
        File maxFile = null;
        for (File file : fileList) {
            if (file.isDirectory() || !version.parse(file.getName(), false) || version.equals(maxVersion) || version.lessThen(maxVersion) || file.length() == 0L) continue;
            maxVersion.assign(version);
            maxFile = file;
        }
        return maxFile;
    }

    public static synchronized byte[] getDictionaryRenewal(String folder, VersionInfo maxVersion) throws IOException {
        if (dictionaryVersion == null) {
            dictionaryVersion = new VersionInfo();
            File dir = new File(new File(Ini.HomePath), folder);
            File[] fileList = dir.listFiles(new FilenameExtFilter("dic", "aff", "words", "no"));
            if (fileList == null) {
                dir = new File(new File(Ini.RootPath), folder);
                fileList = dir.listFiles(new FilenameExtFilter("dic", "aff", "words", "no"));
            }
            if (fileList != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try (ZipOutputStream zos = new ZipOutputStream(baos);){
                    for (File file : fileList) {
                        byte[] bytes = Files.readAllBytes(file.toPath());
                        String name = file.getName();
                        ZipEntry entry = new ZipEntry(name);
                        zos.putNextEntry(entry);
                        zos.write(bytes);
                        zos.closeEntry();
                        if (!"version.no".equalsIgnoreCase(name)) continue;
                        String str = new String(bytes, StandardCharsets.UTF_8);
                        dictionaryVersion.parse(str, false);
                    }
                }
                dictionary = baos.toByteArray();
            }
        }
        if (dictionaryVersion.equals(maxVersion) || dictionaryVersion.lessThen(maxVersion)) {
            return null;
        }
        return dictionary;
    }

    public static File getRecommendedVersion(VersionInfo currentVersion, VersionInfo maxVersion, ProductInfo product) throws IOException {
        ArrayList<VersionInfo> badVersions = ClientUpdateInfo.getBadVersions(product);
        return ClientUpdateInfo.getMaxVersion(currentVersion, badVersions, maxVersion, product);
    }

    public static void getClientUpdateInfo(VersionInfo currentVersion, ProductInfo product, TaggedWriter out) throws IOException {
        long fileSize;
        VersionInfo maxVersion;
        File maxFile;
        ArrayList<VersionInfo> badVersions = ClientUpdateInfo.getBadVersions(product);
        ByteArrayOutputStream badStream = null;
        if (!badVersions.isEmpty()) {
            badStream = new ByteArrayOutputStream();
            TaggedWriter stream = new TaggedWriter(badStream);
            for (VersionInfo version : badVersions) {
                stream.putInt32(1, version.getMajor());
                stream.putInt32(2, version.getMinor());
                stream.putInt32(3, version.getRelease());
            }
            stream.flush();
        }
        if (badStream != null) {
            out.putRaw(7, badStream);
        }
        if ((maxFile = ClientUpdateInfo.getMaxVersion(currentVersion, badVersions, maxVersion = new VersionInfo(), product)) == null || (fileSize = maxFile.length()) == 0L) {
            out.putEmpty(6);
        } else {
            String changes;
            out.putInt32(1, maxVersion.getMajor());
            out.putInt32(2, maxVersion.getMinor());
            out.putInt32(3, maxVersion.getRelease());
            out.putInt32(4, (int)fileSize);
            out.putAnsi(5, maxFile.getAbsolutePath());
            product.storeTo(10, out);
            if (currentVersion == null) {
                return;
            }
            try {
                changes = ClientUpdateInfo.getChanges(maxFile, currentVersion);
            }
            catch (Throwable e) {
                Core.logger.error("cannot fetch update changes", e);
                changes = null;
            }
            if (changes != null) {
                out.putAnsi(9, changes);
            }
        }
    }

    public static byte[] getClientUpdateInfo(VersionInfo currentVersion, ProductInfo product) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        ClientUpdateInfo.getClientUpdateInfo(currentVersion, product, out);
        out.flush();
        return result.toByteArray();
    }

    private static class FileExtentionFilter
    implements FilenameFilter {
        String ends;

        public FileExtentionFilter(String ends) {
            this.ends = ends;
        }

        @Override
        public boolean accept(File d, String name) {
            return name.endsWith(this.ends);
        }
    }

    public static class FilenameExtFilter
    implements FilenameFilter {
        private final String[] exts;

        public FilenameExtFilter(String ... exts) {
            this.exts = exts;
        }

        @Override
        public boolean accept(File dir, String name) {
            for (String ext : this.exts) {
                if (!name.endsWith(ext)) continue;
                return true;
            }
            return false;
        }
    }
}

