/*
 * Decompiled with CFR 0.152.
 */
package inform.agent;

import inform.adt.taggedio.TaggedWriter;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class DataFormat {
    private static final byte[] SIG_PNG = "PNG".getBytes(TaggedWriter.ANSI);
    private static final byte[] SIG_GIF = "GIF".getBytes(TaggedWriter.ANSI);
    private static final byte[] SIG_BMP = "BM".getBytes(TaggedWriter.ANSI);
    private static final byte[] SIG_JPG0 = "JFIF".getBytes(TaggedWriter.ANSI);
    private static final byte[] SIG_JPG1 = "Exif".getBytes(TaggedWriter.ANSI);
    public static final DataFormat UNKNOWN = new DataFormat("application/octet-stream");
    public static final DataFormat PNG = new Image("image/png", true);
    public static final DataFormat GIF = new Image("image/gif", true);
    public static final DataFormat BMP = new Image("image/bmp", false);
    public static final DataFormat JPG = new Image("image/jpeg", true);
    public final String mime;

    private DataFormat(String mime) {
        this.mime = mime;
    }

    public String toString() {
        return "#" + this.mime;
    }

    public static DataFormat determine(byte[] data, int offs, int length) {
        if (DataFormat.match(data, offs, length, SIG_PNG, 1)) {
            return PNG;
        }
        if (DataFormat.match(data, offs, length, SIG_GIF, 0)) {
            return GIF;
        }
        if (DataFormat.match(data, offs, length, SIG_BMP, 0)) {
            return BMP;
        }
        if (DataFormat.match(data, offs, length, SIG_JPG0, 6) || DataFormat.match(data, offs, length, SIG_JPG1, 6)) {
            return JPG;
        }
        return UNKNOWN;
    }

    private static boolean match(byte[] data, int offs, int length, byte[] pattern, int poffs) {
        if (poffs + pattern.length > length) {
            return false;
        }
        for (int i = 0; i < pattern.length; ++i) {
            if (data[offs + i + poffs] == pattern[i]) continue;
            return false;
        }
        return true;
    }

    private static class Image
    extends DataFormat
    implements WebPreview {
        final boolean webready;

        public Image(String mime, boolean webready) {
            super(mime);
            this.webready = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void preview(byte[] data, int offset, int length, OutputStream out, int width, int height) throws IOException {
            BufferedImage src = ImageIO.read(new ByteArrayInputStream(data, offset, length));
            int sw = src.getWidth();
            int sh = src.getHeight();
            int nh = width * sh / sw;
            if (nh < height) {
                height = nh;
            } else {
                width = height * sw / sh;
            }
            if (this.webready && sw / 2 <= width && sh / 2 <= height) {
                out.write(data);
                return;
            }
            boolean hasAlpha = src.getColorModel().hasAlpha();
            BufferedImage dst = new BufferedImage(width, height, hasAlpha ? 6 : 5);
            Graphics2D g = dst.createGraphics();
            try {
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                g.drawImage(src, 0, 0, width, height, null);
            }
            finally {
                g.dispose();
            }
            ImageIO.write((RenderedImage)dst, hasAlpha ? "png" : "jpg", out);
        }
    }

    public static interface WebPreview {
        public void preview(byte[] var1, int var2, int var3, OutputStream var4, int var5, int var6) throws IOException;
    }
}

