/*
 * Decompiled with CFR 0.152.
 */
package inform.agent;

import inform.adt.InformException;
import inform.agent.Core;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;

public class EdDsa {
    public static native byte[] createSign(String var0, byte[] var1, int var2);

    public static native void openSign(byte[] var0, int var1, String var2, byte[] var3, int var4);

    public static native void verifySign(byte[] var0, int var1, byte[] var2, int var3);

    public static native boolean isSignValid(byte[] var0, int var1, byte[] var2, int var3);

    public static native boolean verifyAuthorizedKey(String var0, byte[] var1, int var2, byte[] var3, int var4);

    public static byte[] createSignature(String ppkPath, byte[] data, int dataSize) {
        try {
            File ppkFile = Core.mountfs.resolve(new File(ppkPath));
            String ppk = new String(Files.readAllBytes(Paths.get(ppkFile.toURI())), StandardCharsets.UTF_8);
            return EdDsa.createSign(ppk, data, dataSize);
        }
        catch (Throwable e) {
            throw InformException.wrap(e);
        }
    }

    public static void openSignature(byte[] signature, int signatureSize, String ppkPath, byte[] data, int dataSize) {
        try {
            File ppkFile = Core.mountfs.resolve(new File(ppkPath));
            String ppk = new String(Files.readAllBytes(Paths.get(ppkFile.toURI())), StandardCharsets.UTF_8);
            EdDsa.openSign(signature, signatureSize, ppk, data, dataSize);
        }
        catch (Throwable e) {
            throw InformException.wrap(e);
        }
    }

    public static void verifySignature(byte[] signature, int signatureSize, byte[] data, int dataSize) {
        try {
            EdDsa.verifySign(signature, signatureSize, data, dataSize);
        }
        catch (Throwable e) {
            throw InformException.wrap(e, "\u041b\u0438\u0446\u0435\u043d\u0437\u0438\u044f \u043d\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u0430");
        }
    }
}

