/*
 * Decompiled with CFR 0.152.
 */
package inform.agent;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

public class ProductInfo {
    private String name = null;
    private String platform = null;
    private String architecture = null;
    private String folder = null;
    private String prefix = null;
    private String suffix = null;
    private final FilenameFilter filenameFilter = new UpdateFilter(this);

    public ProductInfo() {
    }

    public ProductInfo(String name, String platform, String architecture) {
        this.set(name, platform, architecture);
    }

    public void load(TaggedReader in) throws IOException {
        String name = in.getAnsi(1);
        String platform = in.getAnsi(2);
        String architecture = in.getAnsi(3);
        this.set(name, platform, architecture);
    }

    public void storeTo(int tag, TaggedWriter out) throws IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        TaggedWriter stream = new TaggedWriter(data);
        stream.putAnsi(1, this.name);
        stream.putAnsi(2, this.platform);
        stream.putAnsi(3, this.architecture);
        stream.flush();
        out.putRaw(tag, data);
    }

    public void set(String name, String platform, String architecture) {
        assert (name != null);
        assert (platform != null);
        assert (architecture != null);
        this.name = name;
        this.platform = platform;
        this.architecture = architecture;
        this.prefix = this.name + "-";
        this.suffix = "-" + this.platform + "-" + this.architecture + ".zip";
        this.folder = this.name + "-" + this.platform + "-" + this.architecture;
    }

    public String folder() {
        this.init();
        return this.folder;
    }

    public String name() {
        this.init();
        return this.name;
    }

    public String prefix() {
        this.init();
        return this.prefix;
    }

    public String suffix() {
        this.init();
        return this.suffix;
    }

    public FilenameFilter filenameFilter() {
        this.init();
        return this.filenameFilter;
    }

    private void init() {
        if (this.name == null) {
            this.set("phx", "windows", "x32");
        }
    }

    private static class UpdateFilter
    implements FilenameFilter {
        final ProductInfo info;

        private UpdateFilter(ProductInfo info) {
            this.info = info;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith(this.info.prefix) && name.endsWith(this.info.suffix);
        }
    }
}

