/*
 * Decompiled with CFR 0.152.
 */
package inform.agent;

import inform.adt.InformException;
import inform.agent.Request;
import inform.agent.RequestHeader;
import inform.agent.am.AMRequest;
import inform.agent.am.AgentConsole;
import inform.agent.am.AgentStatistics;
import inform.agent.am.GetAgentInfo;
import inform.agent.am.GetJavaInfo;
import inform.agent.am.JavaRunGC;
import inform.agent.am.KillAllClients;
import inform.agent.am.KillClient;
import inform.agent.barcode.BarcodeRequest;
import inform.agent.db.commit.CommitRequest;
import inform.agent.db.request.CheckConstraints;
import inform.agent.db.request.CheckDatabaseCompatibility;
import inform.agent.db.request.CheckDeleteRow;
import inform.agent.db.request.CheckFindNode;
import inform.agent.db.request.CheckMtdTreeTables;
import inform.agent.db.request.CheckSystemTables;
import inform.agent.db.request.CheckTableStructure;
import inform.agent.db.request.DataFilter;
import inform.agent.db.request.DescribePhysicalTable;
import inform.agent.db.request.DescribePhysicalTableIndices;
import inform.agent.db.request.DropTable;
import inform.agent.db.request.ExecuteSearch;
import inform.agent.db.request.ExecuteSql;
import inform.agent.db.request.ExecuteSqlScriptNode;
import inform.agent.db.request.ExecuteStoredProcedure;
import inform.agent.db.request.GatherTableStats;
import inform.agent.db.request.GenerateFieldValue;
import inform.agent.db.request.GetBlobData;
import inform.agent.db.request.GetCachedBlobData;
import inform.agent.db.request.GetDatabaseDrivers;
import inform.agent.db.request.GetDatabaseProps;
import inform.agent.db.request.GetDirectoryRecordContents;
import inform.agent.db.request.GetDistinctValues;
import inform.agent.db.request.GetMD5;
import inform.agent.db.request.GetMD5Fields;
import inform.agent.db.request.GetMultipleDistinctValues;
import inform.agent.db.request.GetNonImportedFields;
import inform.agent.db.request.GetNonImportedTables;
import inform.agent.db.request.GetPhysicalTablesInfo;
import inform.agent.db.request.GetRecordContent;
import inform.agent.db.request.GetRequestMonitor;
import inform.agent.db.request.GetSQLText;
import inform.agent.db.request.GetSqlForTable;
import inform.agent.db.request.GetSqlForView;
import inform.agent.db.request.GetTableRecordsRef;
import inform.agent.db.request.LinksLookup;
import inform.agent.db.request.LookupHasDataLink;
import inform.agent.db.request.MultiLinksLookup;
import inform.agent.db.request.PivotConf;
import inform.agent.db.request.QuickDBIndicesCheck;
import inform.agent.db.request.RecordRefsCountRequest;
import inform.agent.db.request.ReplaceRecordRefsRequest;
import inform.agent.db.request.ResolveDBConf;
import inform.agent.db.request.RestructureIndices;
import inform.agent.db.request.SearchInTree;
import inform.agent.db.request.SetDBContentWithDBConf;
import inform.agent.db.request.SqlRepresentation;
import inform.agent.db.request.TestDatabaseConnection;
import inform.agent.db.request.TraceSql;
import inform.agent.db.request.TransformToQuery;
import inform.agent.db.request.ps.ClosePersonalSession;
import inform.agent.db.request.ps.CommitTransaction;
import inform.agent.db.request.ps.CreatePersonalSession;
import inform.agent.db.request.ps.RollbackTransaction;
import inform.agent.files.request.BlobFSDiagnostics;
import inform.agent.files.request.BlobFileSize;
import inform.agent.files.request.DownloadBlobFile;
import inform.agent.files.request.GetUploadBlobFileInfo;
import inform.agent.files.request.UploadBlobFile;
import inform.agent.mtd.NodeContentKind;
import inform.agent.mtd.request.AddNode;
import inform.agent.mtd.request.AuditImport;
import inform.agent.mtd.request.CalculateAccessMask;
import inform.agent.mtd.request.ChangeUserPassword;
import inform.agent.mtd.request.CheckAuthentication;
import inform.agent.mtd.request.CheckSchemeEdit;
import inform.agent.mtd.request.CheckTableUser;
import inform.agent.mtd.request.ConversionService;
import inform.agent.mtd.request.CopyNode;
import inform.agent.mtd.request.CreateUser;
import inform.agent.mtd.request.DeleteNode;
import inform.agent.mtd.request.EmptyTrash;
import inform.agent.mtd.request.GetAccountNode;
import inform.agent.mtd.request.GetAccountNodeInfo;
import inform.agent.mtd.request.GetAccountPermissions;
import inform.agent.mtd.request.GetAccountStartup;
import inform.agent.mtd.request.GetActualConstantsForAccount;
import inform.agent.mtd.request.GetAuditInfo;
import inform.agent.mtd.request.GetAuditReplications;
import inform.agent.mtd.request.GetBlobFSNames;
import inform.agent.mtd.request.GetConfiguration;
import inform.agent.mtd.request.GetDSLPresentation;
import inform.agent.mtd.request.GetDependentNodes;
import inform.agent.mtd.request.GetFindNodeByIdent;
import inform.agent.mtd.request.GetGlobalDependency;
import inform.agent.mtd.request.GetHistoryItem;
import inform.agent.mtd.request.GetInheritedConstantsForAccount;
import inform.agent.mtd.request.GetLogEntryAttrs;
import inform.agent.mtd.request.GetMultipleNodeContents;
import inform.agent.mtd.request.GetNodeChildrenInfo;
import inform.agent.mtd.request.GetNodeChildsByUserAndPerms;
import inform.agent.mtd.request.GetNodeContent;
import inform.agent.mtd.request.GetNodeHistory;
import inform.agent.mtd.request.GetNodeInfo;
import inform.agent.mtd.request.GetNodesDependency;
import inform.agent.mtd.request.GetRecordHistory;
import inform.agent.mtd.request.GetTableDirectoryDependencis;
import inform.agent.mtd.request.GetTicket;
import inform.agent.mtd.request.GetUserAccessRightsHistory;
import inform.agent.mtd.request.GetUserListFor;
import inform.agent.mtd.request.GetValHistory;
import inform.agent.mtd.request.GlobalServerVariableOperation;
import inform.agent.mtd.request.LockNode;
import inform.agent.mtd.request.ModifyNode;
import inform.agent.mtd.request.ModifyUser;
import inform.agent.mtd.request.RedistributeACL;
import inform.agent.mtd.request.RegSchemeEdit;
import inform.agent.mtd.request.RegistrateAuditEvent;
import inform.agent.mtd.request.RegistrateReplication;
import inform.agent.mtd.request.ReplaceNodeDependencies;
import inform.agent.mtd.request.RestoreDeletedNode;
import inform.agent.mtd.request.RestoreNode;
import inform.agent.mtd.request.RestoreNodeFromHistory;
import inform.agent.mtd.request.SearchMetatreeNode;
import inform.agent.mtd.request.SendClientLogs;
import inform.agent.mtd.request.SetConfiguration;
import inform.agent.mtd.request.SetEffectiveUser;
import inform.agent.mtd.request.SetNodeContent;
import inform.agent.mtd.request.SetUserConf;
import inform.agent.mtd.request.TemporaryLockUserStatus;
import inform.agent.mtd.request.TryReadUserNode;
import inform.agent.mtd.request.UnlockNode;
import inform.agent.mtd.request.UnregSchemeEdit;
import inform.agent.mtd.request.UpdateHistoryEntries;
import inform.agent.mtd.request.ValidateLicense;
import inform.agent.net.ClientProtocol;
import inform.agent.net.request.DownloadClient;
import inform.agent.net.request.DownloadRenewal;
import inform.agent.net.request.GetActiveClientList;
import inform.agent.net.request.GetAllIconIds;
import inform.agent.net.request.GetFonts;
import inform.agent.net.request.GetHelpContent;
import inform.agent.net.request.GetIDTemplate;
import inform.agent.net.request.GetIcons;
import inform.agent.net.request.GetServerInfo;
import inform.agent.net.request.Ping;
import inform.agent.net.request.RevokeRoles;
import inform.agent.net.request.SendBroadcastMessage;
import inform.agent.net.request.SendExchangeMessage;
import inform.agent.net.request.SendMessageToUsers;
import inform.agent.net.request.SendNotification;
import inform.agent.obsolete.GuiStyleOperation;
import inform.agent.replication.request.ApplyReplica;
import inform.agent.replication.request.CheckReplicationChanel;
import inform.agent.replication.request.CheckReplicationReceiver;
import inform.agent.replication.request.DownloadNode;
import inform.agent.replication.request.DownloadTableData;
import inform.agent.replication.request.ExecuteReplication;
import inform.agent.replication.request.GetLastReplicationSlice;
import inform.agent.replication.request.GetMetadataNodeDifference;
import inform.agent.replication.request.GetReplicaNodes;
import inform.agent.replication.request.UploadNode;
import inform.agent.sched.GetAgentSchedInfo;
import inform.agent.sched.GetSchedInfoRequest;
import inform.agent.schemes.SchemeExportRequest;
import inform.agent.schemes.SchemeImportRequest;
import inform.agent.schemes.SchemeModificationRequest;
import inform.agent.schemes.SchemeOpenRequest;
import inform.agent.schemes.SchemeShapesOrderedFormatRequest;
import inform.agent.schemes.SchemeSizeRequest;
import inform.agent.schemes.SchemeUpdatesRequest;
import inform.agent.scripts.ExecuteQueryNodeRequest;
import inform.agent.scripts.GetServerSideTableDataRequest;
import inform.agent.scripts.GetSqlQueryNodeRequest;
import inform.agent.scripts.ServerTaskRequest;
import inform.agent.spell.request.CheckSpellingRequest;
import inform.agent.spell.request.SpellSuggestRequest;
import inform.agent.web.reports.GenerateReportRequest;

public final class RequestFactory {
    public static void check(ClientProtocol.ClientType clientType, int request) {
        switch (request) {
            case 1: 
            case 512: 
            case 518: 
            case 570: {
                if (clientType != ClientProtocol.ClientType.Replication) break;
                return;
            }
            case 73: 
            case 135: 
            case 501: {
                if (clientType != ClientProtocol.ClientType.ServerScript) break;
                return;
            }
            case 567: {
                if (clientType != ClientProtocol.ClientType.Service) break;
                return;
            }
        }
        throw new InformException("\u0417\u0430\u043f\u0440\u043e\u0441 \u043a \u0430\u0433\u0435\u043d\u0442\u0443 (rq: " + request + ") \u043f\u043e \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044e \"" + clientType.title + "\" \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d");
    }

    public static Request create(RequestHeader rq) throws InformException {
        switch (rq.request) {
            case 1: {
                return new GetNodeInfo(rq);
            }
            case 2: {
                return new AddNode(rq);
            }
            case 3: {
                return new DeleteNode(rq);
            }
            case 4: {
                return new ModifyNode(rq);
            }
            case 5: {
                return new GetNodeChildrenInfo(rq);
            }
            case 6: {
                return new CopyNode(rq);
            }
            case 7: {
                return new EmptyTrash(rq);
            }
            case 8: {
                return new RestoreNode(rq);
            }
            case 10: {
                return new GetNodeContent(rq, GetNodeContent.Type.Binary, false);
            }
            case 11: {
                return new SetNodeContent(rq, NodeContentKind.Binary);
            }
            case 13: {
                return new GetNodeContent(rq, GetNodeContent.Type.Translated, false);
            }
            case 14: {
                return new GetActualConstantsForAccount(rq);
            }
            case 15: {
                return new GetInheritedConstantsForAccount(rq);
            }
            case 16: {
                return new GetNodesDependency(rq);
            }
            case 18: {
                return new GetFindNodeByIdent(rq);
            }
            case 19: {
                return new RedistributeACL(rq);
            }
            case 20: {
                return new TestDatabaseConnection(rq);
            }
            case 21: {
                return new GetDatabaseProps(rq);
            }
            case 23: {
                return new CheckSystemTables(rq);
            }
            case 24: {
                return new CreatePersonalSession(rq);
            }
            case 25: {
                return new ClosePersonalSession(rq);
            }
            case 26: {
                return new DropTable(rq);
            }
            case 27: {
                return new DescribePhysicalTable(rq);
            }
            case 28: {
                return new ExecuteStoredProcedure(rq);
            }
            case 30: {
                return new GetRecordContent(rq);
            }
            case 31: {
                return new GetTableRecordsRef(rq);
            }
            case 32: {
                return new CommitRequest(rq);
            }
            case 33: {
                return new GetBlobData(rq);
            }
            case 34: {
                return new GetDistinctValues(rq);
            }
            case 35: {
                return new CheckDeleteRow(rq);
            }
            case 36: {
                return new GetSQLText(rq);
            }
            case 37: {
                return new SearchMetatreeNode(rq);
            }
            case 45: {
                return new LinksLookup(rq, 1);
            }
            case 46: {
                return new LinksLookup(rq, 0);
            }
            case 47: {
                return new MultiLinksLookup(rq);
            }
            case 48: {
                return new LookupHasDataLink(rq);
            }
            case 51: {
                return new CommitTransaction(rq);
            }
            case 52: {
                return new RollbackTransaction(rq);
            }
            case 63: {
                return new DownloadTableData(rq);
            }
            case 66: {
                return new DownloadNode(rq);
            }
            case 67: {
                return new UploadNode(rq);
            }
            case 69: {
                return new DownloadClient(rq);
            }
            case 70: {
                return new LockNode(rq);
            }
            case 71: {
                return new UnlockNode(rq);
            }
            case 72: {
                return new SendBroadcastMessage(rq);
            }
            case 73: {
                return new GetActiveClientList(rq);
            }
            case 75: {
                return new SendMessageToUsers(rq);
            }
            case 77: {
                return new GetGlobalDependency(rq);
            }
            case 78: {
                return new GetServerInfo(rq);
            }
            case 80: {
                return new ExecuteSql(rq);
            }
            case 81: {
                return new GlobalServerVariableOperation(rq);
            }
            case 82: {
                return new CalculateAccessMask(rq);
            }
            case 83: {
                return new ExecuteSearch(rq);
            }
            case 85: {
                return new GuiStyleOperation(rq);
            }
            case 86: {
                return new GetPhysicalTablesInfo(rq);
            }
            case 87: {
                return new CheckTableStructure(rq);
            }
            case 88: {
                return new GetNodeContent(rq, GetNodeContent.Type.Binary, true);
            }
            case 90: {
                return new GetAccountPermissions(rq);
            }
            case 91: {
                return new RestructureIndices(rq);
            }
            case 93: {
                return new GetNodeHistory(rq);
            }
            case 94: {
                return new RestoreDeletedNode(rq);
            }
            case 95: {
                return new GetLogEntryAttrs(rq);
            }
            case 96: {
                return new GenerateFieldValue(rq);
            }
            case 97: {
                return new GetDependentNodes(rq);
            }
            case 98: {
                return new ReplaceNodeDependencies(rq);
            }
            case 99: {
                return new ExecuteSqlScriptNode(rq);
            }
            case 100: {
                return new GetCachedBlobData(rq, false);
            }
            case 101: {
                return new GetSqlForView(rq);
            }
            case 102: {
                return new CheckFindNode(rq);
            }
            case 103: {
                return new GetAccountNodeInfo(rq);
            }
            case 104: {
                return new SendExchangeMessage(rq);
            }
            case 106: {
                return new ChangeUserPassword(rq);
            }
            case 107: {
                return new GetNodeContent(rq, GetNodeContent.Type.Binary, false);
            }
            case 108: {
                return new AuditImport(rq);
            }
            case 110: {
                return new DownloadRenewal(rq);
            }
            case 111: {
                return new GetUserListFor(rq);
            }
            case 112: {
                return new RegistrateAuditEvent(rq);
            }
            case 115: {
                return new GetAccountNode(rq);
            }
            case 116: {
                return new GetAccountStartup(rq);
            }
            case 117: {
                return new TryReadUserNode(rq);
            }
            case 118: {
                return new GetIDTemplate(rq);
            }
            case 119: {
                return new RegistrateReplication(rq);
            }
            case 109: {
                return new UpdateHistoryEntries(rq);
            }
            case 200: {
                return new GenerateReportRequest(rq);
            }
            case 501: {
                return new ServerTaskRequest(rq);
            }
            case 502: {
                return new SchemeModificationRequest(rq);
            }
            case 503: {
                return new SchemeUpdatesRequest(rq);
            }
            case 504: {
                return new GetServerSideTableDataRequest(rq);
            }
            case 505: {
                return new GetSqlQueryNodeRequest(rq);
            }
            case 506: {
                return new ExecuteQueryNodeRequest(rq);
            }
            case 507: {
                return new GetSchedInfoRequest(rq);
            }
            case 508: {
                return new GetDatabaseDrivers(rq);
            }
            case 509: {
                return new SchemeOpenRequest(rq);
            }
            case 1024: {
                return new Ping(rq);
            }
            case 510: {
                return new SchemeSizeRequest(rq);
            }
            case 120: {
                return new GetRecordHistory(rq);
            }
            case 121: {
                return new GetValHistory(rq);
            }
            case 122: {
                return new GetHistoryItem(rq);
            }
            case 123: {
                return new GetNodeChildsByUserAndPerms(rq);
            }
            case 124: {
                return new GetUserAccessRightsHistory(rq);
            }
            case 125: {
                return new TransformToQuery(rq);
            }
            case 126: {
                return new RegSchemeEdit(rq);
            }
            case 127: {
                return new UnregSchemeEdit(rq);
            }
            case 128: {
                return new CheckSchemeEdit(rq);
            }
            case 130: {
                return new RevokeRoles(rq);
            }
            case 131: {
                return new QuickDBIndicesCheck(rq);
            }
            case 132: {
                return new GetAuditInfo(rq);
            }
            case 133: {
                return new CheckConstraints(rq);
            }
            case 134: {
                return new SetUserConf(rq);
            }
            case 135: {
                return new SendNotification(rq);
            }
            case 136: {
                return new GetSqlForTable(rq);
            }
            case 137: {
                return new GetConfiguration(rq);
            }
            case 138: {
                return new SetConfiguration(rq);
            }
            case 139: {
                return new CheckAuthentication(rq);
            }
            case 511: {
                return new ExecuteReplication(rq);
            }
            case 512: {
                return new ApplyReplica(rq);
            }
            case 513: {
                return new CheckReplicationChanel(rq);
            }
            case 518: {
                return new GetMetadataNodeDifference(rq);
            }
            case 515: {
                return new GetLastReplicationSlice(rq);
            }
            case 516: {
                return new GetReplicaNodes(rq);
            }
            case 517: {
                return new SchemeShapesOrderedFormatRequest(rq);
            }
            case 519: {
                return new GetBlobFSNames(rq);
            }
            case 520: {
                return new UploadBlobFile(rq);
            }
            case 521: {
                return new GetUploadBlobFileInfo(rq);
            }
            case 522: {
                return new DownloadBlobFile(rq);
            }
            case 523: {
                return new BlobFSDiagnostics(rq, false);
            }
            case 524: {
                return new BlobFSDiagnostics(rq, true);
            }
            case 525: {
                return new BlobFileSize(rq);
            }
            case 526: {
                return new BarcodeRequest(rq);
            }
            case 527: {
                return new RestoreNodeFromHistory(rq);
            }
            case 528: {
                return new GetCachedBlobData(rq, true);
            }
            case 529: {
                return new GetMD5(rq);
            }
            case 530: {
                return new GetNonImportedTables(rq);
            }
            case 531: {
                return new CheckDatabaseCompatibility(rq);
            }
            case 532: {
                return new SendClientLogs(rq);
            }
            case 533: {
                return new TraceSql(rq);
            }
            case 534: {
                return new DataFilter(rq);
            }
            case 535: {
                return new GetNonImportedFields(rq);
            }
            case 536: {
                return new DescribePhysicalTableIndices(rq);
            }
            case 537: {
                return new CreateUser(rq);
            }
            case 538: {
                return new ModifyUser(rq);
            }
            case 539: {
                return new CheckTableUser(rq);
            }
            case 540: {
                return new GatherTableStats(rq);
            }
            case 541: {
                return new SearchInTree(rq);
            }
            case 542: {
                return new GetRequestMonitor(rq);
            }
            case 543: {
                return new RecordRefsCountRequest(rq);
            }
            case 544: {
                return new ReplaceRecordRefsRequest(rq);
            }
            case 545: {
                return new GetTableDirectoryDependencis(rq);
            }
            case 546: {
                return new GetMD5Fields(rq);
            }
            case 547: {
                return new PivotConf(rq);
            }
            case 548: {
                return new ResolveDBConf(rq);
            }
            case 549: {
                return new SetDBContentWithDBConf(rq);
            }
            case 550: {
                return new CheckMtdTreeTables(rq);
            }
            case 551: {
                return new GetAuditReplications(rq);
            }
            case 552: {
                return new GetMultipleNodeContents(rq, false);
            }
            case 554: {
                return new GetMultipleNodeContents(rq, true);
            }
            case 553: {
                return new GetDirectoryRecordContents(rq);
            }
            case 555: {
                return new CheckSpellingRequest(rq);
            }
            case 556: {
                return new SpellSuggestRequest(rq);
            }
            case 557: {
                return new GetFonts(rq);
            }
            case 558: {
                return new GetTicket(rq);
            }
            case 559: {
                return new SetEffectiveUser(rq);
            }
            case 560: {
                return new GetMultipleDistinctValues(rq);
            }
            case 561: {
                return new SchemeExportRequest(rq);
            }
            case 566: {
                return new SchemeImportRequest(rq);
            }
            case 562: {
                return new SqlRepresentation(rq);
            }
            case 563: {
                return new GetIcons(rq);
            }
            case 564: {
                return new GetAllIconIds(rq);
            }
            case 568: {
                return new GetHelpContent(rq);
            }
            case 565: {
                return new ValidateLicense(rq);
            }
            case 567: {
                return new ConversionService(rq);
            }
            case 569: {
                return new TemporaryLockUserStatus(rq);
            }
            case 570: {
                return new CheckReplicationReceiver(rq);
            }
            case 571: {
                return new GetDSLPresentation(rq);
            }
            case 572: {
                return new GetNodeContent(rq, GetNodeContent.Type.Design, false);
            }
            case 573: {
                return new SetNodeContent(rq, NodeContentKind.Text);
            }
            case 574: {
                return new GetNodeContent(rq, GetNodeContent.Type.Runtime, false);
            }
        }
        throw new InformException("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441 \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443 rq:" + rq.request);
    }

    public static AMRequest createAMRequest(int requestType, int flags) {
        switch (requestType) {
            case 14: {
                return new GetJavaInfo(requestType, flags);
            }
            case 23: {
                return new GetAgentSchedInfo(requestType, flags);
            }
            case 5: {
                return new GetAgentInfo(requestType, flags);
            }
            case 8: {
                return new KillClient(requestType, flags);
            }
            case 16: {
                return new AgentStatistics(requestType, flags);
            }
            case 21: {
                return new AgentConsole(requestType, flags);
            }
            case 24: {
                return new JavaRunGC(requestType, flags);
            }
            case 22: {
                return new KillAllClients(requestType, flags);
            }
        }
        throw new IllegalArgumentException("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441 \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443 rq:" + requestType);
    }
}

