/*
 * Decompiled with CFR 0.152.
 */
package inform.agent;

import inform.adt.taggedio.LittleEndianDataInputStream;
import inform.agent.Core;
import inform.agent.net.Client;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class RequestHeader {
    public final int id;
    public final int request;
    public final double nodeId;
    public final int sessionId;
    public final Client client;
    public boolean contentPacked = false;

    public RequestHeader(int id, int request, double nodeId, int sessionId, Client client) {
        this.id = id;
        this.request = request;
        this.nodeId = nodeId;
        this.sessionId = sessionId;
        this.client = client;
    }

    public static class Extra {
        private int id;
        private int request;
        private double nodeId;
        private int sessionId;
        private long clock;

        public void read(byte[] args) throws IOException {
            this.clock = Core.nanoClock();
            LittleEndianDataInputStream header = new LittleEndianDataInputStream(new ByteArrayInputStream(args));
            this.id = header.readInt();
            this.request = header.readInt();
            this.nodeId = header.readDouble();
            this.sessionId = header.readInt();
        }

        public void clear() {
            this.sessionId = 0;
            this.request = 0;
            this.id = 0;
            this.nodeId = 0;
        }

        public long getNanoClock() {
            return this.clock;
        }

        public boolean isExtraOf(RequestHeader h) {
            return this.id == h.id && this.request == h.request && this.sessionId == h.sessionId && this.nodeId == h.nodeId;
        }
    }
}

