/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.am;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.am.AMRequest;
import inform.agent.db.connect.RequestMonitor;
import inform.common.Exceptions;

public class AgentConsole
extends AMRequest {
    private static final String GET_SRQM_COUNT = "srqm.count";
    private static final String SET_SRQM_COUNT = "srqm.count=";
    private static final String CONSOLE_HELP = "\u041a\u043e\u043c\u0430\u043d\u0434\u044b:\n\thi               - \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0438 \u043f\u0430\u043c\u044f\u0442\u0438\n\tsrqm.count       - \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0435 sql \u0432 \u0442\u0440\u0430\u0441\u0441\u0435\n\tsrqm.count=count - \u0437\u0430\u0434\u0430\u0442\u044c \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e sql \u0432 \u0442\u0440\u0430\u0441\u0441\u0435\n\tdump             - \u0434\u0430\u043c\u043f \u043f\u0430\u043c\u044f\u0442\u0438\n\t?                - \u0441\u043f\u0440\u0430\u0432\u043a\u0430";

    public AgentConsole(int request, int flags) {
        super(request, flags);
    }

    @Override
    public byte[] run() throws Throwable {
        Object response;
        TaggedReader reader = this.createContentReader();
        String command = "";
        while (reader.next()) {
            if (reader.getCurrentTag() != 1) continue;
            command = reader.getAnsi();
        }
        if ("?".equals(command)) {
            response = CONSOLE_HELP;
        } else if ("hi".equals(command)) {
            response = AgentConsole.getHeapInfo();
        } else if ("dump".equals(command)) {
            response = Core.dumpHeap();
        } else if ("srql.count".equals(command)) {
            response = "" + RequestMonitor.getMaxRequestCount();
        } else if (command != null && command.startsWith(SET_SRQM_COUNT)) {
            try {
                String v = command.substring(SET_SRQM_COUNT.length());
                int count = Integer.parseInt(v);
                RequestMonitor.setMaxRequestCount(count);
                response = "" + RequestMonitor.getMaxRequestCount();
            }
            catch (Throwable e) {
                Core.logger.error(null, e);
                response = Exceptions.toFullString(e);
            }
        } else {
            response = "\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430 \"" + command + "\"";
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(out);
        writer.putAnsi(1, (String)response);
        return out.toByteArray();
    }

    public static native String getHeapInfo();
}

