/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.am;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.AgentJARVersion;
import inform.agent.ClientUpdateInfo;
import inform.agent.Core;
import inform.agent.ProductInfo;
import inform.agent.VersionInfo;
import inform.agent.am.AMRequest;
import inform.agent.net.Client;
import inform.agent.net.ClientSession;
import inform.agent.web.HttpServer;
import java.util.Date;

public class GetAgentInfo
extends AMRequest {
    public GetAgentInfo(int request, int flags) {
        super(request, flags);
    }

    @Override
    public byte[] run() throws Throwable {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        StringBuilder version = new StringBuilder();
        version.append("ASMO agent").append(" v.").append(AgentJARVersion.MAJOR).append(".").append(AgentJARVersion.MINOR).append(".").append(AgentJARVersion.RELEASE);
        switch (Core.platformVersion) {
            case 32: {
                version.append(" x32");
                break;
            }
            case 64: {
                version.append(" x64");
            }
        }
        out.putAnsi(10, version.toString());
        ByteArrayOutputStream updateInfo = new ByteArrayOutputStream();
        TaggedWriter stream = new TaggedWriter(updateInfo);
        ClientUpdateInfo.getClientUpdateInfo(null, new ProductInfo(), stream);
        stream.flush();
        out.putRaw(11, updateInfo);
        out.putDouble(15, Core.getApplicationId());
        for (Client client : ClientSession.getClients()) {
            out.putEmpty(1);
            out.putInt32(4, 0);
            out.putAnsi(3, client.getUserName());
            out.putAnsi(6, client.getHostUserName());
            out.putAnsi(5, client.getHostComputerName());
            out.putDouble(7, client.getUserId());
            out.putInt32(8, client.getClientId());
            out.putDouble(16, client.getSessionId());
            VersionInfo version2 = client.getVersion();
            if (version2 != null && version2.getMajor() != 0) {
                out.putAnsi(12, version2.toString());
            }
            out.putDate(13, new Date(client.loginTime()));
            out.putEmpty(2);
        }
        HttpServer.gatherWebUsers(out);
        out.flush();
        return result.toByteArray();
    }
}

