/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.am;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.PhaThread;
import inform.agent.am.AMRequest;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class GetJavaInfo
extends AMRequest {
    public GetJavaInfo(int request, int flags) {
        super(request, flags);
    }

    @Override
    public byte[] run() throws Throwable {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        out.putRaw(1, this.gatherThreadsInformation());
        out.putRaw(2, this.memoryUsage(ManagementFactory.getMemoryMXBean().getHeapMemoryUsage()));
        out.putRaw(3, this.memoryUsage(ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage()));
        for (DatabaseDescriptor.ConnectionInfo ci : DatabaseDescriptor.gatherActiveConnectionsInfo()) {
            out.putRaw(4, this.connectionInfo(ci));
        }
        out.putInt32(5, DatabaseConnection.getTotalConnectionCount());
        out.putRaw(6, this.getJavaVersionInfo());
        out.flush();
        return result.toByteArray();
    }

    private byte[] gatherThreadsInformation() throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        DeflaterOutputStream deflated = new DeflaterOutputStream((OutputStream)result, new Deflater(9, true));
        TaggedWriter out = new TaggedWriter(deflated);
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
            Thread thread = entry.getKey();
            StringBuilder stackTrace = new StringBuilder();
            PhaThread.dumpStackTrace(stackTrace, entry.getValue());
            out.putInt32(1, (int)thread.getId());
            out.putString(2, stackTrace.toString());
            String threadName = thread.getName();
            if (threadName == null || threadName.length() <= 0) continue;
            out.putString(3, threadName);
        }
        out.flush();
        deflated.finish();
        deflated.flush();
        return result.toByteArray();
    }

    private byte[] memoryUsage(MemoryUsage mem) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        out.putInt32(1, (int)(mem.getUsed() / 1024L));
        out.putInt32(2, (int)(mem.getMax() / 1024L));
        out.flush();
        return result.toByteArray();
    }

    private byte[] connectionInfo(DatabaseDescriptor.ConnectionInfo info) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        out.putInt32(1, info.id);
        if (info.active) {
            out.putEmpty(2);
        }
        out.putDouble(3, info.databaseId);
        out.putAnsi(4, info.driver.getPackage().getName().replace("inform.agent.db.connect.", ""));
        out.putDouble(5, info.creationTime);
        out.flush();
        return result.toByteArray();
    }

    private ByteArrayOutputStream getJavaVersionInfo() throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        out.putString(1, System.getProperty("java.runtime.name"));
        out.putString(2, System.getProperty("java.runtime.version"));
        out.putString(3, System.getProperty("java.vm.name"));
        out.putString(4, System.getProperty("java.vm.version"));
        out.flush();
        return result;
    }
}

