/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.ObjectSizer;
import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleHash;
import inform.adt.collections.DoubleList;
import inform.adt.collections.DoubleSet;
import inform.adt.collections.IntegerSet;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.ActionHooks;
import inform.agent.Core;
import inform.agent.RequestStatistics;
import inform.agent.ServerSideHost;
import inform.agent.db.BatchInsertEngine;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.ForwardOnlyRowset;
import inform.agent.db.GeneratedSql;
import inform.agent.db.Row;
import inform.agent.db.Rowset;
import inform.agent.db.ScrollableRowset;
import inform.agent.db.TableDescriptor;
import inform.agent.db.VirtualRowset;
import inform.agent.db.commit.AuditModification;
import inform.agent.db.commit.DeleteEngine;
import inform.agent.db.commit.TableDataAudit;
import inform.agent.db.connect.Connector;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ProxyDatabaseConnection;
import inform.agent.db.connect.ResultSetPostProcess;
import inform.agent.db.types.DataType;
import inform.agent.db.types.Geometry;
import inform.agent.db.types.SqlDataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.files.BFS;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.DatabaseNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.Datasource;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.stat.DatasourceProfile;
import inform.agent.scripts.textutils.ExtractionDataInfo;
import inform.agent.scripts.textutils.TextExtractor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.mozilla.javascript.Context;

public abstract class AbstractConnectionManager {
    public static final double METADATA_DB = 2.0;
    public static final double SEQUENCE_GENERATOR_DB = -2.0;
    private static final int BATCH_STATE_EMPTY = 0;
    private static final int BATCH_STATE_INSERT = 1;
    private static final int BATCH_STATE_UPDATE = 2;
    private final ArrayList<Row> modifiedRows = new ArrayList();
    private final DoubleHash<DatabaseConnection> connections = new DoubleHash();
    private final DoubleHash<ProxyDatabaseConnection> proxyConnections = new DoubleHash();
    private final Collection<DatabaseConnection> connlist = new ArrayList<DatabaseConnection>();
    private final String usedBy;
    private final boolean freshNeed;
    private ActionHooks.Hook _hook;
    @ObjectSizer.HintShared
    protected ServerSideHost ssHost;
    @ObjectSizer.HintShared
    public final SSContext context;
    private List<Datasource> batchModeDatasources;
    private boolean rootConnectionMode = false;

    public AbstractConnectionManager(SSContext context, String who, boolean freshNeed) {
        this.usedBy = who;
        this.freshNeed = freshNeed;
        this.context = context;
    }

    public boolean rootConnectionMode() {
        return this.rootConnectionMode;
    }

    public void rootConnectionMode(boolean value) {
        if (value && this.connections.empty()) {
            this.rootConnectionMode = true;
        }
    }

    public abstract boolean isPersonalSession();

    public ActionHooks.Hook hook() {
        if (this._hook == null) {
            this._hook = new ActionHooks.Hook(this.usedBy){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void hook() {
                    ArrayList<DatabaseConnection> _connlist;
                    if (this.hooked == 0) {
                        Core.logger.info("\u041e\u0442\u043c\u0435\u043d\u0430 SQL-\u0437\u0430\u043f\u0440\u043e\u0441\u043e\u0432 ({}), \u043f\u0440\u0438\u0447\u0438\u043d\u0430: {}", (Object)AbstractConnectionManager.this.usedBy, (Object)this.cause);
                    } else if (this.hooked <= 3) {
                        Core.logger.info("\u041f\u043e\u0432\u0442\u043e\u0440\u043d\u0430\u044f(\u043f\u043e\u043f\u044b\u0442\u043a\u0430:{}) \u043e\u0442\u043c\u0435\u043d\u0430 SQL-\u0437\u0430\u043f\u0440\u043e\u0441\u043e\u0432 ({}), \u043f\u0440\u0438\u0447\u0438\u043d\u0430: {}", this.hooked + 1, AbstractConnectionManager.this.usedBy, this.cause);
                    } else {
                        return;
                    }
                    Collection<DatabaseConnection> collection = AbstractConnectionManager.this.connlist;
                    synchronized (collection) {
                        if (AbstractConnectionManager.this.connlist.isEmpty()) {
                            return;
                        }
                        _connlist = new ArrayList<DatabaseConnection>(AbstractConnectionManager.this.connlist);
                    }
                    for (DatabaseConnection c : _connlist) {
                        Core.logger.info("\t\u043e\u0442\u043c\u0435\u043d\u0430 SQL-\u0437\u0430\u043f\u0440\u043e\u0441\u043e\u0432 \u0434\u043b\u044f: {}", (Object)c);
                        if (this.hooked == 3) {
                            AbstractConnectionManager.this.killSessionHelper(c, "\u043d\u0435 \u0440\u0435\u0430\u0433\u0438\u0440\u0443\u0435\u0442 \u043d\u0430 \u043e\u0442\u043c\u0435\u043d\u0443 sql-\u0437\u0430\u043f\u0440\u043e\u0441\u043e\u0432");
                            continue;
                        }
                        c.cancel();
                    }
                }
            };
            ActionHooks.register(this._hook);
        }
        return this._hook;
    }

    protected abstract void killSessionHelper(DatabaseConnection var1, String var2);

    public ServerSideHost getSSHost() {
        return this.ssHost;
    }

    public Rowset createRowset(SSContext ssContext, TableDescriptor table, GeneratedSql sql, Rowset.Kind kind, int blobReceiving, int nullSortKind, String who, boolean internStrings, DatasourceProfile profile) throws SQLException {
        PreparedStatement stmt = this.getConnection(table.getDbId(), who).prepareStatement("DatabaseManager.createRowset", sql.getSqlText());
        try {
            stmt.setQueryTimeout();
            stmt.setSqlInfo(sql);
            sql.setParametersTo(stmt);
            long startTime = 0L;
            Rowset rowset = null;
            if (profile != null) {
                startTime = System.currentTimeMillis();
            }
            boolean hasPrimaryKey = !sql.isAdvanced() || sql.hasPrimaryKeyExpression();
            ResultSetPostProcess postProcess = null;
            if (sql.hasPostProcess()) {
                if (kind == Rowset.Kind.FORWARD_ONLY) {
                    kind = Rowset.Kind.SCROLLABLE;
                }
                Context context = Core.asmoJsContextFactory.enterContext();
                postProcess = sql.createPostProcess(ssContext, context, this.ssHost, this, nullSortKind);
            }
            switch (kind) {
                case FORWARD_ONLY: {
                    rowset = new ForwardOnlyRowset(ssContext, this, table, stmt, blobReceiving, hasPrimaryKey, internStrings);
                    break;
                }
                case SCROLLABLE: {
                    rowset = new ScrollableRowset(ssContext, this, table, stmt, blobReceiving, hasPrimaryKey, internStrings, postProcess);
                    break;
                }
                case VIRTUAL: {
                    rowset = new VirtualRowset(ssContext, this, table, stmt, blobReceiving, hasPrimaryKey, postProcess);
                }
            }
            if (profile != null) {
                profile.addRequestTime(System.currentTimeMillis() - startTime);
                rowset.setProfile(profile);
            }
            return rowset;
        }
        catch (Throwable ex) {
            try {
                stmt.close();
            }
            catch (Throwable e) {
                Core.suppressErrorToLog(e);
            }
            if (ex instanceof SQLException) {
                throw (SQLException)ex;
            }
            throw InformException.wrap(ex);
        }
    }

    public Rowset createEmptyRowset(SSContext ssContext, TableDescriptor table, Rowset.Kind kind, int blobReceiving, boolean internStrings) {
        switch (kind) {
            case FORWARD_ONLY: {
                return new ForwardOnlyRowset(ssContext, this, table, blobReceiving, internStrings);
            }
            case SCROLLABLE: {
                return new ScrollableRowset(ssContext, this, table, blobReceiving, internStrings);
            }
            case VIRTUAL: {
                return new VirtualRowset(ssContext, this, table, blobReceiving);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseConnection getConnection(double dbId, String who) throws SQLException {
        DatabaseConnection result = this.connections.get(dbId);
        if (result == null || !result.attached(this)) {
            if (dbId == 2.0) {
                result = DatabaseDescriptor.getMetabase().connect(this, String.format("AbstractConnectionManager(%s)(%s)", this.usedBy, who), this.freshNeed);
            } else {
                if (this.rootConnectionMode && (result = (DatabaseConnection)this.proxyConnections.get(dbId)) != null) {
                    return result;
                }
                Node metadataNode = MtdEngine.getValidNode(dbId);
                if (!(metadataNode instanceof DatabaseNode)) {
                    MtdEngine.throwDetailError("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0443\u0437\u0435\u043b \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043a \u0431\u0430\u0437\u0435 \u0434\u0430\u043d\u043d\u044b\u0445", dbId);
                }
                DatabaseNode node = (DatabaseNode)metadataNode;
                DatabaseDescriptor databaseDescriptor = node.getDescriptor();
                if (this.rootConnectionMode && databaseDescriptor.getEffectiveDatabaseId() != databaseDescriptor.getNodeId()) {
                    DatabaseConnection rootConnection = this.getConnection(databaseDescriptor.getEffectiveDatabaseId(), who);
                    ProxyDatabaseConnection proxyConnection = new ProxyDatabaseConnection(databaseDescriptor, rootConnection);
                    this.proxyConnections.add(proxyConnection);
                    return proxyConnection;
                }
                result = databaseDescriptor.connect(this, String.format("AbstractConnectionManager(%s)(%s)", this.usedBy, who), this.freshNeed);
            }
            this.connections.add(result);
            Collection<DatabaseConnection> collection = this.connlist;
            synchronized (collection) {
                this.connlist.add(result);
            }
        } else {
            this.hook();
        }
        return result;
    }

    public Connector metadataConnector(final String who) {
        return new Connector.Lazy(){

            @Override
            protected DatabaseConnection connect() throws SQLException {
                return AbstractConnectionManager.this.getConnection(2.0, who);
            }
        };
    }

    void registerModifiedRow(Row modifiedRow) {
        assert (modifiedRow != null);
        this.getModifiedRows().add(modifiedRow);
    }

    protected int assignParameters(SSContext ssContext, int startParam, PreparedStatement stmt, Row r, Iterator<FieldDescriptor> i, SaveParams saveParams) throws Exception {
        int paramCount = startParam;
        while (i.hasNext()) {
            FieldDescriptor fd = i.next();
            if (fd.isAutoFill() || fd.getType() == DataType.VARIANT || fd.getKind() == 2) continue;
            if (r.getNullFlag(fd.getIndex())) {
                if (fd.getType() == DataType.FILE) {
                    if (saveParams.bfs == null) {
                        saveParams.bfs = new BFS();
                    }
                    saveParams.bfs.delete(ssContext, stmt.connection(), saveParams.table, fd, r.getId());
                    if (saveParams.modify) {
                        saveParams.audit.registrateSetNull(saveParams.table, r.getId(), AuditModification.MODIFY, fd.getId());
                    } else {
                        saveParams.audit.registrateSetNull(saveParams.table, r.getId(), AuditModification.APPEND, fd.getId());
                    }
                }
                stmt.setNull(paramCount, fd.getType().toSqlDataType());
                IntegerSet extractionTextFields = fd.getExtractionTextFields();
                if (extractionTextFields != null) {
                    paramCount = this.addExtractionTextSqlParamsAsNull(stmt, paramCount, r.getTableDescriptor(), extractionTextFields);
                }
            } else {
                switch (fd.getType()) {
                    case BOOLEAN: {
                        stmt.setBoolean(paramCount, r.getNumeric(fd.getIndex()) != 0.0);
                        break;
                    }
                    case DATE_TIME: {
                        stmt.setDateTime(paramCount, r.getNumeric(fd.getIndex()));
                        break;
                    }
                    case DIRECTORY: 
                    case FLOAT: 
                    case INTERVAL: 
                    case METATREE_NODE: 
                    case PRIMARY_KEY: {
                        stmt.setDouble(paramCount, r.getNumeric(fd.getIndex()));
                        break;
                    }
                    case INTEGER: {
                        stmt.setInt(paramCount, (int)r.getNumeric(fd.getIndex()));
                        break;
                    }
                    case BIG_NUMBER: 
                    case STRING: {
                        stmt.setString(paramCount, (String)r.getComplex(fd.getIndex()));
                        break;
                    }
                    case UNICODE: {
                        stmt.setNString(paramCount, (String)r.getComplex(fd.getIndex()));
                        break;
                    }
                    case BLOB: {
                        byte[] blobData = null;
                        Object blobValue = r.getComplex(fd.getIndex());
                        if (fd.blobRawType == FieldDescriptor.BlobRawType.TEXT || fd.getPostgreSQLReviewType() == FieldDescriptor.PostgreSQLReviewType.TSVECTOR) {
                            String value = ValueCaster.toString(blobValue);
                            stmt.setString(paramCount, value);
                            break;
                        }
                        if (blobValue instanceof BinaryObject) {
                            blobData = ((BinaryObject)blobValue).toByteArray();
                        } else if (blobValue instanceof String) {
                            blobData = ((String)blobValue).getBytes(TaggedWriter.ANSI);
                        }
                        if (blobData == null) {
                            stmt.setNull(paramCount, fd.getType().toSqlDataType());
                        } else {
                            stmt.setBlob(paramCount, blobData);
                        }
                        if (!fd.hasExtractionText()) break;
                        paramCount = this.addExtractionTextSqlParams(stmt, paramCount, r.getTableDescriptor(), fd, r.getId(), blobData);
                        break;
                    }
                    case FILE: {
                        String fieldValue;
                        Object value;
                        BFS.checkBlobFSField(saveParams.table, fd);
                        if (saveParams.bfs == null) {
                            saveParams.bfs = new BFS();
                        }
                        if ((value = r.getComplex(fd.getIndex())) == null) {
                            saveParams.bfs.delete(ssContext, stmt.connection(), saveParams.table, fd, r.getId());
                            stmt.setNull(paramCount, fd.getType().toSqlDataType());
                            if (saveParams.modify) {
                                saveParams.audit.registrateSetNull(saveParams.table, r.getId(), AuditModification.MODIFY, fd.getId());
                                break;
                            }
                            saveParams.audit.registrateSetNull(saveParams.table, r.getId(), AuditModification.APPEND, fd.getId());
                            break;
                        }
                        if (value instanceof BinaryObject) {
                            String blobPoint;
                            byte[] blob = ((BinaryObject)value).toByteArray();
                            try {
                                blobPoint = saveParams.modify ? saveParams.bfs.modify(this.context, stmt.connection(), r.getId(), saveParams.table, fd, blob) : saveParams.bfs.insert(saveParams.table.getNodeId(), fd, r.getId(), blob);
                            }
                            catch (IOException e) {
                                throw InformException.wrap(e);
                            }
                            stmt.setString(paramCount, blobPoint);
                            if (saveParams.modify) {
                                saveParams.audit.registrateSetString(saveParams.table, r.getId(), AuditModification.MODIFY, fd.getId(), blobPoint);
                            } else {
                                saveParams.audit.registrateSetString(saveParams.table, r.getId(), AuditModification.APPEND, fd.getId(), blobPoint);
                            }
                            if (!fd.hasExtractionText()) break;
                            paramCount = this.addExtractionTextSqlParams(stmt, paramCount, r.getTableDescriptor(), fd, r.getId(), blob);
                            break;
                        }
                        if (value instanceof BFS.BlobRef) {
                            BFS.BlobRef blobRef = (BFS.BlobRef)value;
                            stmt.setString(paramCount, blobRef.ref);
                            if (!fd.hasExtractionText()) break;
                            String dataPath = fd.getBlobFS() + ":/" + blobRef.ref;
                            String dataFile = Core.blobfs.resolvePath(dataPath);
                            File data = new File(dataFile);
                            paramCount = this.addExtractionTextSqlParams(stmt, paramCount, r.getTableDescriptor(), fd, r.getId(), data);
                            break;
                        }
                        if (value instanceof String) {
                            String blobPoint;
                            String text = (String)value;
                            byte[] blob = text.getBytes(TaggedWriter.ANSI);
                            try {
                                blobPoint = saveParams.modify ? saveParams.bfs.modify(this.context, stmt.connection(), r.getId(), saveParams.table, fd, blob) : saveParams.bfs.insert(saveParams.table.getNodeId(), fd, r.getId(), blob);
                            }
                            catch (IOException e) {
                                throw InformException.wrap(e);
                            }
                            stmt.setString(paramCount, blobPoint);
                            if (saveParams.modify) {
                                saveParams.audit.registrateSetString(saveParams.table, r.getId(), AuditModification.MODIFY, fd.getId(), blobPoint);
                            } else {
                                saveParams.audit.registrateSetString(saveParams.table, r.getId(), AuditModification.APPEND, fd.getId(), blobPoint);
                            }
                            if (!fd.hasExtractionText()) break;
                            paramCount = this.addExtractionTextSqlParams(stmt, paramCount, r.getTableDescriptor(), fd, r.getId(), blob);
                            break;
                        }
                        assert (value instanceof BFS.BlobDigest);
                        BFS.BlobDigest blobDigest = (BFS.BlobDigest)value;
                        try {
                            fieldValue = saveParams.bfs.upload(this.context, this.ssHost, saveParams.databaseConnection, saveParams.modify, r.getId(), saveParams.table, fd, blobDigest.digest);
                        }
                        catch (IOException e) {
                            StringBuilder detail = new StringBuilder();
                            detail.append("\u0422\u0430\u0431\u043b\u0438\u0446\u0430: ").append(saveParams.table.toString()).append(", \u043f\u043e\u043b\u0435: ");
                            fd.toErrorString(detail);
                            detail.append(", \u0437\u0430\u043f\u0438\u0441\u044c: ").append(NumberConverter.doubleToString(r.getId()));
                            throw InformException.detail(e, detail.toString());
                        }
                        stmt.setString(paramCount, fieldValue);
                        if (saveParams.modify) {
                            saveParams.audit.registrateSetString(saveParams.table, r.getId(), AuditModification.MODIFY, fd.getId(), fieldValue);
                        } else {
                            saveParams.audit.registrateSetString(saveParams.table, r.getId(), AuditModification.APPEND, fd.getId(), fieldValue);
                        }
                        if (!fd.hasExtractionText()) break;
                        String dataPath = fd.getBlobFS() + ":/" + fieldValue;
                        String dataFile = Core.blobfs.resolvePath(dataPath);
                        File data = new File(dataFile);
                        paramCount = this.addExtractionTextSqlParams(stmt, paramCount, r.getTableDescriptor(), fd, r.getId(), data);
                        break;
                    }
                    case GEOMETRY: {
                        Geometry g = (Geometry)r.getComplex(fd.getIndex());
                        if (g == null) {
                            stmt.setNull(paramCount, SqlDataType.GEOMETRY);
                            break;
                        }
                        stmt.setGeometry(paramCount, g);
                    }
                }
            }
            ++paramCount;
        }
        return paramCount - startParam;
    }

    private int addExtractionTextSqlParamsAsNull(PreparedStatement stmt, int parameterIndex, TableDescriptor td, IntegerSet extractionFields) throws SQLException {
        int count;
        int n = count = extractionFields == null ? 0 : extractionFields.size();
        for (int i = 0; i < count; ++i) {
            stmt.setString(++parameterIndex, null);
        }
        return parameterIndex;
    }

    private int addExtractionTextSqlParams(PreparedStatement stmt, int parameterIndex, TableDescriptor td, FieldDescriptor fld, double recordId, byte[] data) throws Exception {
        IntegerSet extractionFields;
        ExtractionDataInfo info;
        TextExtractor textExtractor;
        TextExtractor.DOCUMENT_FORMAT format;
        String text = null;
        if (data != null && (format = (textExtractor = new TextExtractor(data, info = new ExtractionDataInfo(td, fld, recordId))).getFormat()) != null && format != TextExtractor.DOCUMENT_FORMAT.DOCUMENT_BINARY) {
            text = textExtractor.extractText();
        }
        if ((extractionFields = fld.getExtractionTextFields()) == null) {
            return parameterIndex;
        }
        for (Cursor.Integer c : extractionFields) {
            int fieldId = c.value;
            FieldDescriptor fd = td.getExistingFieldDescriptor(fieldId);
            int size = TextExtractor.maxTextLength(fd);
            ++parameterIndex;
            if (size > 0 && text != null && text.length() > size) {
                stmt.setString(parameterIndex, text.substring(0, size));
                continue;
            }
            stmt.setString(parameterIndex, text);
        }
        return parameterIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addExtractionTextSqlParams(PreparedStatement stmt, int parameterIndex, TableDescriptor td, FieldDescriptor fld, double recordId, File data) throws Exception {
        IntegerSet extractionFields;
        String text = null;
        if (data != null) {
            try (FileInputStream is = new FileInputStream(data);){
                ExtractionDataInfo info = new ExtractionDataInfo(td, fld, recordId);
                TextExtractor textExtractor = new TextExtractor(is, info);
                TextExtractor.DOCUMENT_FORMAT format = textExtractor.getFormat();
                if (format != null && format != TextExtractor.DOCUMENT_FORMAT.DOCUMENT_BINARY) {
                    text = textExtractor.extractText();
                }
            }
        }
        if ((extractionFields = fld.getExtractionTextFields()) == null) {
            return parameterIndex;
        }
        for (Cursor.Integer c : extractionFields) {
            int fieldId = c.value;
            FieldDescriptor fd = td.getExistingFieldDescriptor(fieldId);
            int size = TextExtractor.maxTextLength(fd);
            ++parameterIndex;
            if (size > 0 && text != null && text.length() > size) {
                stmt.setString(parameterIndex, text.substring(0, size));
                continue;
            }
            stmt.setString(parameterIndex, text);
        }
        return parameterIndex;
    }

    private String getFQTN(DatabaseConnection db, TableDescriptor table) {
        return db.getDescriptor().getTableRawName(table.getRawName());
    }

    public ArrayList<Row> getModifiedRows() {
        return this.modifiedRows;
    }

    private static void throwUpdateCountError(TableDescriptor tableDescriptor, double[] recordIds) {
        if (recordIds != null && recordIds.length > 0) {
            StringBuilder detail = new StringBuilder();
            int sep = 58;
            if (recordIds.length == 1) {
                detail.append("[recordId");
            } else {
                detail.append("[recordIds");
            }
            for (double r : recordIds) {
                detail.append((char)sep).append(' ').append((long)r);
                sep = 44;
            }
            detail.append(']');
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0443\u0436\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u044b\u0435 \u0437\u0430\u043f\u0438\u0441\u0438 (\u0442\u0430\u0431\u043b\u0438\u0446\u0430:" + tableDescriptor.toString() + ")").detail(detail.toString());
        }
        throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0443\u0436\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u044b\u0435 \u0437\u0430\u043f\u0438\u0441\u0438 (\u0442\u0430\u0431\u043b\u0438\u0446\u0430:" + tableDescriptor.toString() + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushModification(SSContext ssContext, PreparedStatement stmt, boolean batch, DoubleList appliedIds) throws SQLException {
        if (stmt != null) {
            TableDescriptor tableDescriptor = stmt.getTableDescriptor();
            try {
                if (batch) {
                    stmt.addBatch();
                    int[] r = stmt.executeBatch(ssContext);
                    if (r != null) {
                        boolean checked = true;
                        for (int count : r) {
                            if (count < 0) {
                                checked = false;
                                break;
                            }
                            if (count == 1) continue;
                            AbstractConnectionManager.throwUpdateCountError(tableDescriptor, appliedIds.toArray());
                        }
                        if (checked) {
                            return;
                        }
                        int updateCount = stmt.getLastBatchUpdateCount();
                        if (r.length != updateCount) {
                            AbstractConnectionManager.throwUpdateCountError(tableDescriptor, appliedIds.toArray());
                        }
                    }
                } else {
                    int updateCount = stmt.executeUpdate(ssContext);
                    if (updateCount != 1) {
                        AbstractConnectionManager.throwUpdateCountError(tableDescriptor, appliedIds.toArray());
                    }
                }
            }
            finally {
                try {
                    appliedIds.clear();
                }
                catch (Throwable e) {
                    Core.logger.error(null, e);
                }
                try {
                    stmt.close();
                }
                catch (Throwable e) {
                    Core.logger.error(null, e);
                }
            }
        }
    }

    public void registerBatchModeDatasource(Datasource ds) {
        assert (ds != null);
        if (this.batchModeDatasources == null) {
            this.batchModeDatasources = new ArrayList<Datasource>();
        }
        if (!this.batchModeDatasources.contains(ds)) {
            this.batchModeDatasources.add(ds);
        }
    }

    public void unregisterBatchModeDatasource(Datasource ds) {
        assert (ds != null);
        if (this.batchModeDatasources != null) {
            this.batchModeDatasources.remove(ds);
            if (this.batchModeDatasources.isEmpty()) {
                this.batchModeDatasources = null;
            }
        }
    }

    protected PreparedStatement createInsertStatement(Iterator<FieldDescriptor> i, TableDescriptor tableDescriptor, DatabaseConnection db, DatabaseCaps caps, DoubleSet batchFields) throws SQLException {
        StringBuilder s = new StringBuilder();
        int dlm = 32;
        s.append("INSERT INTO ");
        s.append(this.getFQTN(db, tableDescriptor));
        if (tableDescriptor.getKind() == TableDescriptor.Kind.INTERNAL || i.hasNext()) {
            s.append(" (");
            if (tableDescriptor.getKind() == TableDescriptor.Kind.INTERNAL) {
                s.append((char)dlm);
                s.append(tableDescriptor.getRecordIdField().getRawName());
                dlm = 44;
            }
            ArrayList<String> params = new ArrayList<String>();
            while (i.hasNext()) {
                FieldDescriptor fd = i.next();
                if (fd.isAutoFill() || fd.getType() == DataType.VARIANT || fd.getKind() == 2) continue;
                if (batchFields != null) {
                    batchFields.add(fd.getId());
                }
                params.add(caps.tranformSqlParameter(fd));
                s.append((char)dlm);
                s.append(caps.enquoteIfNeed(fd.getRawName()));
                dlm = 44;
                IntegerSet extractionFields = fd.getExtractionTextFields();
                if (extractionFields == null) continue;
                for (Cursor.Integer c : extractionFields) {
                    int fldId = c.value;
                    if (batchFields != null) {
                        batchFields.add(fldId);
                    }
                    FieldDescriptor extractionFieldInfo = tableDescriptor.getExistingFieldDescriptor(fldId);
                    s.append(", ").append(caps.enquoteIfNeed(extractionFieldInfo.getRawName()));
                    params.add(caps.tranformSqlParameter(extractionFieldInfo));
                }
            }
            int paramsCount = params.size();
            s.append(") VALUES (");
            if (tableDescriptor.getKind() == TableDescriptor.Kind.INTERNAL) {
                s.append("?");
                if (paramsCount > 0) {
                    s.append(", ");
                }
            }
            for (int j = 0; j < paramsCount - 1; ++j) {
                s.append((String)params.get(j)).append(", ");
            }
            if (paramsCount > 0) {
                s.append((String)params.get(paramsCount - 1));
            }
            s.append(")");
        }
        PreparedStatement stmt = db.prepareStatement("DatabaseManager.createInsertStatement", s.toString());
        stmt.setTableDesc(tableDescriptor);
        stmt.setQueryTimeout();
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(SSContext ssContext) throws Exception {
        double modifierUserId = 0.0;
        double effectiveUserId = 0.0;
        double sessionId = 0.0;
        double ownerId = 0.0;
        RequestStatistics.Value rqstat_old = null;
        RequestStatistics.Value rqstat_new = null;
        long startTime = System.currentTimeMillis();
        try {
            if (this.ssHost != null) {
                modifierUserId = this.ssHost.getUserID();
                effectiveUserId = this.ssHost.getEffectiveUserID();
                sessionId = this.ssHost.getSessionID();
                ownerId = this.ssHost.getNodeID();
                rqstat_old = this.ssHost.rqstat();
                rqstat_new = new RequestStatistics.Value();
                rqstat_new.reset(-5, this.ssHost.getUserID(), 0.0);
                rqstat_new.ownerId = ownerId;
                this.ssHost.rqstat(rqstat_new);
            }
            DeleteEngine deleteEngine = null;
            PreparedStatement stmt = null;
            DoubleList appliedIds = new DoubleList(4);
            int batchState = 0;
            double batchNode = 0.0;
            DoubleSet batchFields = null;
            boolean batch = false;
            DatabaseConnection database = null;
            double committingDatabaseId = 0.0;
            TableDataAudit audit = null;
            TableDescriptor tableDescriptor = null;
            SaveParams saveParams = new SaveParams();
            if (this.batchModeDatasources != null) {
                for (Datasource ds : this.batchModeDatasources) {
                    DatabaseConnection conn = this.getConnection(ds.getTableDescriptor().getDbId(), "batchInsert");
                    BatchInsertEngine batchInsertEngine = conn.createBatchInsertEngine(this);
                    batchInsertEngine.batchInsert(this.context, ds, modifierUserId, sessionId, ownerId, effectiveUserId, conn);
                }
            }
            for (Row r : this.getModifiedRows()) {
                boolean currentBatch;
                tableDescriptor = r.getTableDescriptor();
                double databaseNodeId = tableDescriptor.getDbId();
                if (committingDatabaseId != databaseNodeId) {
                    if (deleteEngine != null) {
                        deleteEngine.applyDelete();
                    }
                    if (audit != null) {
                        audit.flush();
                    }
                    committingDatabaseId = databaseNodeId;
                    database = this.getConnection(databaseNodeId, "save");
                    if (database != null) {
                        audit = database.getTableDataAudit();
                        if (audit != null) {
                            deleteEngine = database.getDeleteEngine();
                        } else {
                            audit = new TableDataAudit(this.context, database, modifierUserId, effectiveUserId, 0.0, 0.0, sessionId);
                            database.transaction(audit);
                            audit.setBatchMode(true);
                            audit.setOwnerId(ownerId);
                            deleteEngine = new DeleteEngine(this.context, this, null, modifierUserId, this.ssHost);
                            deleteEngine.setAuditWriter(audit);
                            database.setDeleteEngine(deleteEngine);
                        }
                    } else {
                        deleteEngine = null;
                        audit = null;
                    }
                }
                if (tableDescriptor.getValueGeneratorCount() > 0) {
                    this.initAutoValueGeneratorFields(tableDescriptor, r, modifierUserId, effectiveUserId);
                }
                saveParams.databaseConnection = database;
                saveParams.table = tableDescriptor;
                saveParams.audit = audit;
                if (r.getId() == 0.0 || database == null) continue;
                DatabaseCaps caps = database.getDescriptor().getDatabaseType().caps();
                if (r.isModified() && tableDescriptor.getRecordIdField() != null) {
                    if (deleteEngine != null) {
                        deleteEngine.applyDelete();
                    }
                    boolean bl = currentBatch = batchState == 2 && batchFields != null && stmt != null && batchNode == tableDescriptor.getNodeId() && r.isChangedFieldsEquals(batchFields);
                    if (currentBatch) {
                        stmt.addBatch();
                        batch = true;
                    } else {
                        this.flushModification(ssContext, stmt, batch, appliedIds);
                        batchState = 2;
                        batchNode = tableDescriptor.getNodeId();
                        if (batchFields == null) {
                            batchFields = new DoubleSet();
                        } else {
                            batchFields.clear();
                        }
                        StringBuilder s = new StringBuilder();
                        char dlm = ' ';
                        s.append("UPDATE ");
                        s.append(this.getFQTN(database, tableDescriptor));
                        s.append(" SET ");
                        Iterator<FieldDescriptor> i = r.getChangedFieldsIterator();
                        while (i.hasNext()) {
                            IntegerSet flds;
                            FieldDescriptor fd = i.next();
                            int fieldId = fd.getId();
                            if (fd.isAutoFill()) continue;
                            batchFields.add(fieldId);
                            s.append(dlm);
                            dlm = ',';
                            s.append(caps.enquoteIfNeed(fd.getRawName()));
                            s.append(" = ").append(caps.tranformSqlParameter(fd));
                            if (!fd.hasExtractionText() || (flds = fd.getExtractionTextFields()) == null) continue;
                            for (Cursor.Integer c : flds) {
                                int fldId = c.value;
                                batchFields.add(fldId);
                                FieldDescriptor extractionFieldInfo = tableDescriptor.getExistingFieldDescriptor(fldId);
                                s.append(dlm).append(caps.enquoteIfNeed(extractionFieldInfo.getRawName()));
                                s.append(" = ").append(caps.tranformSqlParameter(extractionFieldInfo));
                            }
                        }
                        s.append(" WHERE ");
                        s.append(tableDescriptor.getRecordIdField().getRawName());
                        s.append(" = ?");
                        String sql = s.toString();
                        stmt = database.prepareStatement("DatabaseManager.save", sql);
                        stmt.setQueryTimeout();
                        stmt.setTableDesc(tableDescriptor);
                        batch = false;
                    }
                    saveParams.modify = true;
                    int paramCount = this.assignParameters(ssContext, 1, stmt, r, r.getChangedFieldsIterator(), saveParams);
                    stmt.setDouble(paramCount + 1, r.getId());
                } else if (r.isToBeDeleted() && tableDescriptor.getRecordIdField() != null) {
                    this.flushModification(ssContext, stmt, batch, appliedIds);
                    stmt = null;
                    batch = false;
                    batchState = 0;
                    batchNode = 0.0;
                    if (batchFields != null) {
                        batchFields.clear();
                    }
                    deleteEngine.deleteRow(tableDescriptor.getNodeId(), r.getId());
                } else if (r.isNew()) {
                    if (deleteEngine != null) {
                        deleteEngine.applyDelete();
                    }
                    boolean bl = currentBatch = batchState == 1 && batchFields != null && stmt != null && batchNode == tableDescriptor.getNodeId() && r.isChangedFieldsEquals(batchFields);
                    if (currentBatch) {
                        stmt.addBatch();
                        batch = true;
                    } else {
                        this.flushModification(ssContext, stmt, batch, appliedIds);
                        batchState = 1;
                        batchNode = tableDescriptor.getNodeId();
                        if (batchFields == null) {
                            batchFields = new DoubleSet();
                        } else {
                            batchFields.clear();
                        }
                        stmt = this.createInsertStatement(r.getChangedFieldsIterator(), tableDescriptor, database, caps, batchFields);
                        batch = false;
                    }
                    saveParams.modify = false;
                    if (tableDescriptor.getKind() == TableDescriptor.Kind.INTERNAL) {
                        stmt.setDouble(1, r.getId());
                        this.assignParameters(ssContext, 2, stmt, r, r.getChangedFieldsIterator(), saveParams);
                    } else {
                        this.assignParameters(ssContext, 1, stmt, r, r.getChangedFieldsIterator(), saveParams);
                    }
                }
                audit.registrateRow(r);
                appliedIds.add(r.getId());
            }
            if (deleteEngine != null) {
                deleteEngine.applyDelete();
            }
            if (audit != null) {
                audit.flush();
            }
            this.flushModification(ssContext, stmt, batch, appliedIds);
            stmt = null;
            for (Row r : this.getModifiedRows()) {
                r.saved();
            }
            this.getModifiedRows().clear();
            if (rqstat_new != null) {
                rqstat_new.apply(System.currentTimeMillis() - startTime);
            }
            if (this.ssHost != null) {
                this.ssHost.rqstat(rqstat_old);
            }
        }
        catch (Throwable throwable) {
            if (rqstat_new != null) {
                rqstat_new.apply(System.currentTimeMillis() - startTime);
            }
            if (this.ssHost != null) {
                this.ssHost.rqstat(rqstat_old);
            }
            throw throwable;
        }
    }

    public void commit() throws SQLException {
        this.commit(false);
    }

    public void commit(boolean force) throws SQLException {
        if (!force && this.isPersonalSession()) {
            return;
        }
        for (ProxyDatabaseConnection proxyDatabaseConnection : this.proxyConnections) {
            proxyDatabaseConnection.commit();
        }
        for (DatabaseConnection databaseConnection : this.connections) {
            if (!databaseConnection.attached(this)) continue;
            databaseConnection.commit();
        }
    }

    public void rollback() throws SQLException {
        for (DatabaseConnection c : this.connections) {
            if (!c.attached(this)) continue;
            c.rollback();
        }
        this.getModifiedRows().clear();
        if (this.batchModeDatasources != null) {
            for (Datasource ds : this.batchModeDatasources) {
                List<Row> rows = ds.getInsertedRows();
                if (rows == null || rows.isEmpty()) continue;
                rows.clear();
            }
        }
    }

    protected void releaseHook() {
        try {
            if (this._hook != null) {
                ActionHooks.unregister(this._hook);
                this._hook = null;
            }
        }
        catch (Throwable e) {
            Core.logger.error("unregister ACM hook", e);
        }
    }

    public void release() {
        for (DatabaseConnection c : this.connections) {
            if (!c.attached(this)) continue;
            c.close();
        }
        this.proxyConnections.clear();
        this.releaseHook();
    }

    public boolean hasModifications() {
        return !this.modifiedRows.isEmpty();
    }

    protected void initAutoValueGeneratorFields(TableDescriptor tableDescriptor, Row row, double modifierUserID, double effectiveUserId) {
        FieldDescriptor fd;
        Iterator<FieldDescriptor> i;
        ArrayList<FieldDescriptor> timeStamps = null;
        ArrayList<FieldDescriptor> users = null;
        for (FieldDescriptor field : tableDescriptor.getFields()) {
            FieldDescriptor.AutoValueGenerator generator = field.getAutoValueGenerator();
            if (!generator.isGenerateOnCommit() || field.isCalcValueGeneratorForInsertOnly() && !row.isNew()) continue;
            switch (generator) {
                case TIMESTAMP: {
                    if (field.type != DataType.DATE_TIME) break;
                    if (field.valueGeneratorField == 0) {
                        row.setNumeric(field.getIndex(), DateTime.currentDateTime());
                        break;
                    }
                    if (timeStamps == null) {
                        timeStamps = new ArrayList<FieldDescriptor>();
                    }
                    timeStamps.add(field);
                    break;
                }
                case USER: {
                    if (!field.type.isDoublePresentation() || this.ssHost == null) break;
                    if (field.valueGeneratorField == 0) {
                        row.setNumeric(field.getIndex(), modifierUserID);
                        break;
                    }
                    if (users == null) {
                        users = new ArrayList<FieldDescriptor>();
                    }
                    users.add(field);
                    break;
                }
                case EFFECTIVE_USER: {
                    if (!field.type.isDoublePresentation() || this.ssHost == null) break;
                    row.setNumeric(field.getIndex(), effectiveUserId);
                    break;
                }
                case COMPUTER_NAME: {
                    if (this.ssHost == null || this.ssHost.client() == null) {
                        row.setComplex(field.getIndex(), "???");
                        break;
                    }
                    row.setComplex(field.getIndex(), this.ssHost.client().getHostComputerName());
                    break;
                }
                case WINDOWS_USER_NAME: {
                    if (this.ssHost == null || this.ssHost.client() == null) {
                        row.setComplex(field.getIndex(), "???");
                        break;
                    }
                    row.setComplex(field.getIndex(), this.ssHost.client().getHostUserName());
                    break;
                }
                case COMPUTER_IP: {
                    if (this.ssHost == null || this.ssHost.client() == null) {
                        row.setComplex(field.getIndex(), "???");
                        break;
                    }
                    row.setComplex(field.getIndex(), this.ssHost.client().getHostIP());
                    break;
                }
                case SESSION: {
                    if (this.ssHost == null || this.ssHost.client() == null) {
                        row.setNumeric(field.getIndex(), -1.0);
                        break;
                    }
                    row.setNumeric(field.getIndex(), this.ssHost.client().getSessionId());
                }
            }
        }
        if (timeStamps != null) {
            i = row.getChangedFieldsIterator();
            while (i.hasNext()) {
                fd = i.next();
                for (FieldDescriptor field : timeStamps) {
                    if (field.valueGeneratorField != fd.id) continue;
                    row.setNumeric(field.getIndex(), DateTime.currentDateTime());
                }
            }
        }
        if (users != null) {
            i = row.getChangedFieldsIterator();
            while (i.hasNext()) {
                fd = i.next();
                for (FieldDescriptor field : users) {
                    if (field.valueGeneratorField != fd.id) continue;
                    row.setNumeric(field.getIndex(), modifierUserID);
                }
            }
        }
    }

    public static enum IsolationLevel {
        TRANSACTION_READ_COMMITTED(1),
        TRANSACTION_REPEATABLE_READ(2),
        TRANSACTION_SERIALIZABLE(3);

        private final int value;

        private IsolationLevel(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    static class SaveParams {
        BFS bfs;
        DatabaseConnection databaseConnection;
        TableDescriptor table;
        TableDataAudit audit;
        boolean modify;

        SaveParams() {
        }
    }
}

