/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.types.BlobValueId;
import inform.agent.db.types.DataType;
import inform.agent.db.types.Geometry;
import inform.agent.files.BFS;
import inform.agent.scripts.SSContext;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class BlobDataReader {
    private AbstractConnectionManager dbManager;
    private PreparedStatement statement = null;
    private ResultSet resultSet = null;
    private final boolean needLength;
    private long blobSize = -1L;

    public BlobDataReader(int sessionId, ServerSideHost ssHost, boolean needLength) throws InformException, InterruptedException {
        this.dbManager = ConnectionManager.capture(sessionId, ssHost, "BlobDataReader");
        this.needLength = needLength;
    }

    public BlobDataReader(int sessionId, ServerSideHost ssHost) throws InformException, InterruptedException {
        this(sessionId, ssHost, false);
    }

    public InputStream readData(SSContext ssContext, double databaseId, BlobValueId blobId) throws SQLException, IOException, InformException {
        TableDescriptor tableInfo = TableDescriptor.get(blobId.getTableId());
        return this.readData(ssContext, databaseId, tableInfo, blobId.getFieldId(), blobId.getRowId());
    }

    private FieldDescriptor prepareReadData(SSContext ssContext, double databaseId, TableDescriptor tableInfo, int fieldID, double recordID) throws SQLException, IOException, InformException {
        this.close();
        if (tableInfo.getKind() == TableDescriptor.Kind.VIRTUAL) {
            throw new InformException("\u041f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0441\u044f \u0432\u044b\u0431\u043e\u0440 \u0438\u0437 \u0442\u0430\u0431\u043b\u0438\u0446\u044b, \u043a\u043e\u0442\u043e\u0440\u0430\u044f \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0432\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0439");
        }
        FieldDescriptor fieldInfo = tableInfo.getExistingFieldDescriptor(fieldID);
        DatabaseDescriptor dbInfo = tableInfo.getDatabaseDescriptor();
        DatabaseConnection database = this.dbManager.getConnection(databaseId, "BlobDataReader::readData");
        StringBuilder sql = new StringBuilder();
        sql.append("select ").append(fieldInfo.getRawName());
        if (this.needLength && fieldInfo.getType() != DataType.FILE) {
            DatabaseCaps caps = dbInfo.getDatabaseType().caps();
            sql.append(',').append(caps.blobLengthFunction).append('(').append(fieldInfo.getRawName()).append(')');
        }
        sql.append(" from ");
        dbInfo.appendTableRawName(tableInfo.getRawName(), sql);
        FieldDescriptor recId = tableInfo.getRecordIdField();
        if (recId == null) {
            throw new InformException("\u0423 \u0442\u0430\u0431\u043b\u0438\u0446\u044b (node:" + (long)tableInfo.getNodeId() + ") \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0439 \u043a\u043b\u044e\u0447. \u041e\u0442\u043b\u043e\u0436\u0435\u043d\u043d\u043e\u0435 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 BLOB-\u043f\u043e\u043b\u0435\u0439 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e");
        }
        sql.append(" where ").append(recId.getRawName()).append("=?");
        this.statement = database.prepareStatement("GetBlobData Request", sql.toString());
        this.statement.setQueryTimeout();
        this.statement.setDouble(1, recordID);
        this.resultSet = this.statement.executeQuery(ssContext);
        return fieldInfo;
    }

    public InputStream readData(SSContext ssContext, double databaseId, TableDescriptor tableInfo, int fieldID, double recordID) throws SQLException, IOException, InformException {
        FieldDescriptor fieldInfo = this.prepareReadData(ssContext, databaseId, tableInfo, fieldID, recordID);
        if (this.resultSet.next()) {
            InputStream is;
            switch (fieldInfo.getType()) {
                case FILE: {
                    String blobPoint = this.resultSet.getString(1);
                    is = this.resultSet.wasNull() || Strings.isVoid(blobPoint) ? null : BFS.getFileStream(fieldInfo, blobPoint);
                    if (is != null) {
                        this.blobSize = ((InputStream)is).available();
                        break;
                    }
                    this.blobSize = 0L;
                    break;
                }
                case GEOMETRY: {
                    Geometry g = this.resultSet.getGeometry(1);
                    if (g == null) {
                        is = null;
                    } else {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        g.serialize(out);
                        is = new ByteArrayInputStream(out.internalBuffer(), 0, out.size());
                    }
                    if (!this.needLength) break;
                    this.blobSize = this.resultSet.getLong(2);
                    break;
                }
                default: {
                    is = this.resultSet.getBlobStream(1);
                    if (!this.needLength) break;
                    this.blobSize = this.resultSet.getLong(2);
                }
            }
            return is;
        }
        return null;
    }

    public File getBlobFile(SSContext ssContext, double databaseId, TableDescriptor tableInfo, int fieldID, double recordID) throws SQLException, IOException, InformException {
        FieldDescriptor fieldInfo = this.prepareReadData(ssContext, databaseId, tableInfo, fieldID, recordID);
        if (this.resultSet.next()) {
            File is = null;
            switch (fieldInfo.getType()) {
                case FILE: {
                    String blobPath = this.resultSet.getString(1);
                    String filePath = Core.blobfs.resolvePath(fieldInfo.getBlobFS() + ":/" + blobPath);
                    is = this.resultSet.wasNull() || Strings.isVoid(blobPath) ? null : new File(filePath);
                    if (is != null) {
                        this.blobSize = is.length();
                        break;
                    }
                    this.blobSize = 0L;
                    break;
                }
                default: {
                    throw new InformException("\u041f\u043e\u043b\u0435 \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f BLOB-\u0444\u0430\u0439\u043b\u043e\u043c");
                }
            }
            return is;
        }
        return null;
    }

    public void close() throws SQLException {
        PreparedStatement statementToClose = null;
        if (this.resultSet != null) {
            this.resultSet.close();
            statementToClose = this.statement;
        }
        this.statement = null;
        this.resultSet = null;
        if (statementToClose != null) {
            statementToClose.close();
        }
    }

    public void release() throws InformException, SQLException {
        try {
            this.close();
        }
        catch (Throwable e) {
            this.dbManager.release();
            throw InformException.wrap(e);
        }
        this.dbManager.release();
    }

    public long getBlobSize() {
        return this.blobSize;
    }
}

