/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db;

import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import java.sql.SQLException;

public class ClosableResult {
    private PreparedStatement statement;
    private ResultSet resultSet;
    private DatabaseConnection connection;
    private boolean commit;

    public ClosableResult(PreparedStatement statement, ResultSet resultSet) {
        this.connection = null;
        this.statement = statement;
        this.resultSet = resultSet;
        this.commit = false;
    }

    public ClosableResult(DatabaseConnection connection, PreparedStatement statement, ResultSet resultSet, boolean commit) {
        this.connection = connection;
        this.statement = statement;
        this.resultSet = resultSet;
        this.commit = commit;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
                this.resultSet = null;
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                    this.statement = null;
                }
            }
            finally {
                if (this.connection != null) {
                    try {
                        if (this.commit) {
                            this.connection.commit();
                        }
                    }
                    finally {
                        this.connection.close();
                    }
                }
            }
        }
    }
}

