/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db;

import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.mtd.MtdEngine;
import java.io.IOException;
import java.sql.SQLException;

public class DBLogin {
    private double databaseId = 0.0;
    private String login = null;
    private String password = null;
    private byte[] databaseContent = null;
    DatabaseDescriptor databaseDescriptor = null;

    public DBLogin() {
    }

    public DBLogin(DBLogin dbl) {
        this.databaseId = dbl.databaseId;
        this.login = dbl.login;
        this.password = dbl.password;
        this.databaseContent = dbl.databaseContent;
    }

    public double getDatabaseId() {
        return this.databaseId;
    }

    public String getLogin() {
        return this.login;
    }

    public String getPassword() {
        return this.password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseDescriptor adjust(DatabaseDescriptor descriptor) throws SQLException {
        DBLogin dBLogin = this;
        synchronized (dBLogin) {
            if (this.databaseDescriptor == null) {
                if (this.databaseContent != null) {
                    this.databaseDescriptor = DatabaseDescriptor.getDatabase(new TaggedReader(this.databaseContent));
                    this.databaseContent = null;
                } else if (this.login != null && !this.login.isEmpty()) {
                    this.databaseDescriptor = DatabaseDescriptor.getDatabase(new TaggedReader(MtdEngine.getNodeContent(descriptor.getNodeId())));
                    this.databaseDescriptor.setDBLogin(this.login, this.password);
                } else {
                    this.databaseDescriptor = descriptor;
                }
            }
            return this.databaseDescriptor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        DBLogin dBLogin = this;
        synchronized (dBLogin) {
            if (this.databaseDescriptor != null) {
                this.databaseDescriptor.invalidate();
                this.databaseDescriptor = null;
            }
        }
    }

    public void loadTag(TaggedReader in) throws IOException, TaggedReaderException {
        switch (in.getCurrentTag()) {
            case 1: {
                this.databaseId = in.getDouble();
                break;
            }
            case 3: {
                this.login = in.getAnsi();
                break;
            }
            case 4: {
                this.password = in.getAnsi();
                break;
            }
            case 5: {
                this.databaseContent = in.getRaw();
                break;
            }
        }
    }

    public void save(TaggedWriter out) throws IOException {
        out.putDouble(1, this.databaseId);
        if (this.databaseContent != null && this.databaseContent.length != 0) {
            out.putRaw(5, this.databaseContent);
        } else {
            out.putAnsi(3, this.login);
            out.putAnsi(4, this.password);
        }
        out.putEmpty(2);
    }
}

