/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.ObjectSizer;
import inform.adt.collections.DoubleSet;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.FieldValueGenerator;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.Row;
import inform.agent.db.Rowset;
import inform.agent.db.RowsetAccessor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.VirtualRowset;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.types.DataType;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.BlobReader;
import inform.agent.scripts.ServerSideComponent;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;

public class DataRow
extends Row {
    private static final byte FLAG_NOT_NULL = 1;
    private static final byte FLAG_IS_MODIFIED = 2;
    private static final byte FLAG_SIZE_NOT_LOADED = 4;
    private static final byte FLAG_CONTENT_NOT_LOADED = 8;
    private final double[] numericFields;
    private final Object[] complexFields;
    private final byte[] flags;
    @ObjectSizer.HintShared
    private Rowset rowset;
    @ObjectSizer.HintShared
    private boolean isModified;
    private boolean isDeleted;
    private boolean isNew;
    private final boolean rowLoaded;

    public DataRow(Rowset rowset, TableDescriptor table, ResultSet queryResult, FieldDescriptor[] columnsMap) throws SQLException, IOException {
        this.rowset = rowset;
        if (!rowset.isHasRecordIdField()) {
            this.id = recordIdGenerator.incrementAndGet();
        }
        int fieldCount = table.getFields().size();
        this.flags = new byte[fieldCount];
        this.numericFields = new double[fieldCount];
        this.complexFields = table.hasComplexFields() ? new Object[fieldCount] : null;
        this.rowLoaded = true;
        this.loadFields(queryResult, columnsMap);
    }

    DataRow(Rowset rowset, TableDescriptor table, double rowId, boolean isNew, boolean isVirtual) throws InformException {
        this.rowset = rowset;
        this.id = rowId;
        int fieldCount = table.getFields().size();
        this.flags = new byte[fieldCount];
        this.numericFields = new double[fieldCount];
        this.complexFields = table.hasComplexFields() ? new Object[fieldCount] : null;
        this.isNew = isNew;
        this.rowLoaded = false;
        if (table.getKind() == TableDescriptor.Kind.EXTERNAL && table.getRecordIdField() != null) {
            this.numeric(table.getRecordIdField().getIndex(), this.id);
        }
        if (isNew && !isVirtual && table.getHasAutoSetValues()) {
            this.setGeneratedFieldValuesOnCreate(table);
        }
        this.informModified();
    }

    private void setGeneratedFieldValuesOnCreate(TableDescriptor table) {
        if (table.getValueGeneratorCount() > 0) {
            FieldValueGenerator generator = new FieldValueGenerator(table, -1);
            generator.fill(this.rowset.disabledGenerators);
            if (!generator.isEmpty()) {
                try {
                    generator.generate(this.rowset.ssContext, this.rowset.getSSHost());
                }
                catch (SQLException ex) {
                    throw InformException.wrap(ex);
                }
                generator.interpretResult();
                for (FieldValueGenerator.Generator g : generator) {
                    FieldDescriptor field = table.getFieldDescriptor(g.fieldId);
                    if (field == null) continue;
                    if (g.stringResult != null) {
                        this.string(field.getIndex(), g.stringResult);
                        continue;
                    }
                    if (g.bigResult != null) {
                        this.string(field.getIndex(), g.bigResult);
                        continue;
                    }
                    this.numeric(field.getIndex(), g.result);
                }
            }
        }
    }

    @Override
    public void reuse(TableDescriptor table) {
        if (this.complexFields != null) {
            for (int index = 0; index < this.flags.length; ++index) {
                byte fl = this.flags[index];
                fl = (byte)(fl | 2);
                this.flags[index] = fl = (byte)(fl & 0xFFFFFFF2);
                this.numericFields[index] = 0.0;
                this.complexFields[index] = null;
            }
        } else {
            for (int index = 0; index < this.flags.length; ++index) {
                byte fl = this.flags[index];
                fl = (byte)(fl | 2);
                this.flags[index] = fl = (byte)(fl & 0xFFFFFFF2);
                this.numericFields[index] = 0.0;
            }
        }
        if (table != null && table.getHasAutoSetValues()) {
            this.setGeneratedFieldValuesOnCreate(table);
        }
        this.informModified();
    }

    @Override
    public void internalTransferTo(Rowset rowset) {
        this.rowset = rowset;
    }

    @Override
    public boolean isRowLoaded() {
        return this.rowLoaded;
    }

    @Override
    public double getNumeric(int index) {
        return this.numericFields[index];
    }

    @Override
    public void markDelete() {
        this.isDeleted = true;
        this.informModified();
    }

    private void numeric(int idx, double value) throws InformException {
        this.numericFields[idx] = value;
        this.flags[idx] = (byte)((this.flags[idx] | 1 | 2) & 0xFFFFFFF3);
    }

    public void string(int index, String value) throws InformException {
        byte f = this.flags[index];
        f = (byte)(f | 2);
        f = (byte)(f & 0xFFFFFFF3);
        f = value == null ? (byte)(f & 0xFFFFFFFE) : (byte)(f | 1);
        this.flags[index] = f;
        this.complexFields[index] = value;
    }

    @Override
    public boolean setNumeric(int index, double value) throws InformException {
        if (Double.isInfinite(value)) {
            throw new InformException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u0438\u0441\u0432\u043e\u0438\u0442\u044c \u043f\u043e\u043b\u044e \u0431\u0435\u0441\u043a\u043e\u043d\u0435\u0447\u043d\u043e\u0435 \u0447\u0438\u0441\u043b\u043e");
        }
        if (Double.isNaN(value)) {
            throw new InformException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u0438\u0441\u0432\u043e\u0438\u0442\u044c \u043f\u043e\u043b\u044e \u043d\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0435 \u0447\u0438\u0441\u043b\u043e(NaN)");
        }
        if (!this.isFieldContentLoaded(index) || value != this.numericFields[index] || (this.flags[index] & 1) == 0) {
            this.numeric(index, value);
            this.informModified();
            return true;
        }
        return false;
    }

    private BinaryObject updateBlob(int index) throws InformException {
        TableDescriptor table = this.getTableDescriptor();
        FieldDescriptor field = table.getFields().get(index);
        if (field.getType() != DataType.BLOB && field.getType() != DataType.FILE) {
            return null;
        }
        try {
            BinaryObject result = BlobReader.read(this.rowset.ssContext, this.rowset.dbManager, table, field, this.id);
            if (result != null && result.getSize() != 0) {
                int n = index;
                this.flags[n] = (byte)(this.flags[n] | 1);
            }
            if (field.getType() == DataType.FILE) {
                return null;
            }
            int n = index;
            this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFF3);
            this.complexFields[index] = result;
            return result;
        }
        catch (Throwable ex) {
            throw InformException.wrap(ex);
        }
    }

    @Override
    public long getBlobLength(int index) throws InformException {
        if ((this.flags[index] & 4) != 0) {
            BinaryObject blob = this.updateBlob(index);
            return blob == null ? 0L : (long)blob.getSize();
        }
        Object obj = this.complexFields[index];
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof BinaryObject) {
            return ((BinaryObject)obj).getSize();
        }
        if (obj instanceof String) {
            return ((String)obj).length();
        }
        throw new InformException("unknown blob data type \"" + obj.getClass().getName() + "\"");
    }

    @Override
    public Object getComplex(int index) throws InformException {
        if ((this.flags[index] & 8) != 0) {
            this.updateBlob(index);
        }
        return this.complexFields[index];
    }

    @Override
    public boolean setComplex(int index, Object value) throws InformException {
        Object old = this.complexFields[index];
        if (!this.isFieldContentLoaded(index) || value != old && (value == null || !value.equals(old))) {
            byte f = this.flags[index];
            f = (byte)(f | 2);
            f = (byte)(f & 0xFFFFFFF3);
            f = value == null ? (byte)(f & 0xFFFFFFFE) : (byte)(f | 1);
            this.flags[index] = f;
            this.complexFields[index] = value;
            this.informModified();
            return true;
        }
        return false;
    }

    @Override
    public boolean setComplex(int index, String value, RowsetAccessor ra, FieldDescriptor fieldInfo) throws InformException {
        if (!(this.rowset instanceof VirtualRowset) && value != null && value.length() > fieldInfo.getSize()) {
            TableDescriptor tableInfo = this.rowset.getTableDescriptor();
            StringBuilder msg = new StringBuilder();
            msg.append("\u0420\u0430\u0437\u043c\u0435\u0440 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043f\u043e\u043b\u044f \"").append(fieldInfo.getCaption()).append("\"(\u0442\u0430\u0431\u043b\u0438\u0446\u0430: ").append(NumberConverter.doubleToString(tableInfo.getNodeId())).append(", id \u043f\u043e\u043b\u044f: ").append(fieldInfo.getId()).append(") \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0432\u0435\u043b\u0438\u043a (\u0444\u0430\u043a\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439: ").append(value.length()).append(",  \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u043d\u044b\u0439: ").append(fieldInfo.getSize()).append(")");
            StringBuilder detail = new StringBuilder();
            if (ra instanceof ServerSideComponent) {
                ServerSideComponent ds = (ServerSideComponent)((Object)ra);
                detail.append("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a name: ").append(ds.getName()).append(", id: ").append(ds.getId());
            }
            throw new InformException(msg.toString()).detail(detail.toString());
        }
        return this.setComplex(index, value);
    }

    @Override
    public boolean getNullFlag(int index) throws InformException {
        if ((this.flags[index] & 4) != 0) {
            this.updateBlob(index);
        }
        return (this.flags[index] & 1) == 0;
    }

    @Override
    public boolean setNullFlag(int index) throws InformException {
        byte fl = this.flags[index];
        if ((fl & 1) != 0 || !this.rowLoaded || (fl & 4) != 0) {
            fl = (byte)(fl | 2);
            this.flags[index] = fl = (byte)(fl & 0xFFFFFFF2);
            this.numericFields[index] = 0.0;
            if (this.complexFields != null) {
                this.complexFields[index] = null;
            }
            this.informModified();
            return true;
        }
        return false;
    }

    @Override
    public boolean getModFlag(int index) throws InformException {
        return (this.flags[index] & 2) != 0;
    }

    public final void loadFields(ResultSet queryResult, FieldDescriptor[] columnsMap) throws SQLException, IOException {
        int externalRecordIdFieldIndex;
        FieldDescriptor externalRecordIdField;
        int indexDelta = 0;
        TableDescriptor table = this.getTableDescriptor();
        if (table.getKind() == TableDescriptor.Kind.INTERNAL && this.id == 0.0) {
            this.id = queryResult.getDouble(1);
            indexDelta = 1;
        }
        if ((externalRecordIdField = table.getRecordIdField()) == null) {
            externalRecordIdFieldIndex = -1;
            if (this.rowset.isHasRecordIdField()) {
                for (int i = 1; i <= queryResult.getColumnCount(); ++i) {
                    String columnName = queryResult.getColumnLabel(i);
                    if (!"ID".equalsIgnoreCase(columnName)) continue;
                    externalRecordIdFieldIndex = i;
                    break;
                }
            }
        } else {
            externalRecordIdFieldIndex = externalRecordIdField.getIndex() + 1;
            int count = columnsMap.length;
            for (int index = 0; index < count; ++index) {
                FieldDescriptor f = columnsMap[index];
                if (f.id != externalRecordIdField.id) continue;
                externalRecordIdFieldIndex = index + 1;
                break;
            }
        }
        int blobReceiving = this.rowset.getBlobReceiving();
        for (int i = 0; i < this.flags.length; ++i) {
            this.flags[i] = 12;
        }
        for (int colIndex = indexDelta + 1; colIndex <= columnsMap.length; ++colIndex) {
            FieldDescriptor fd = columnsMap[colIndex - 1];
            if (fd == null) {
                if (externalRecordIdFieldIndex != colIndex) continue;
                this.id = queryResult.getDouble(colIndex);
                continue;
            }
            int i = fd.getIndex();
            byte fl = 0;
            switch (fd.getType()) {
                case DIRECTORY: 
                case FLOAT: 
                case INTEGER: 
                case INTERVAL: 
                case METATREE_NODE: 
                case PRIMARY_KEY: {
                    this.numericFields[i] = queryResult.getDouble(colIndex);
                    if (externalRecordIdFieldIndex != colIndex) break;
                    this.id = this.numericFields[i];
                    break;
                }
                case BOOLEAN: {
                    this.numericFields[i] = queryResult.getAsInteger(colIndex);
                    break;
                }
                case BIG_NUMBER: 
                case STRING: 
                case UNICODE: {
                    this.complexFields[i] = this.rowset.tryIntern(queryResult.getString(colIndex));
                    break;
                }
                case FILE: {
                    this.complexFields[i] = queryResult.getString(colIndex);
                    break;
                }
                case DATE_TIME: {
                    double dateTime = queryResult.getDateTime(colIndex);
                    if (queryResult.wasNull()) break;
                    this.numericFields[i] = dateTime;
                    break;
                }
                case BLOB: {
                    block9 : switch (blobReceiving) {
                        case 2: {
                            switch (fd.getBlobRawType()) {
                                case TEXT: {
                                    String s = queryResult.getString(colIndex);
                                    this.complexFields[i] = new BinaryObject(s == null ? null : s.getBytes(TaggedWriter.ANSI));
                                    break block9;
                                }
                            }
                            this.complexFields[i] = new BinaryObject(queryResult.getBlobBytes(colIndex));
                            break;
                        }
                        case 1: {
                            this.complexFields[i] = queryResult.getLong(colIndex);
                            fl = (byte)(fl | 8);
                        }
                    }
                    break;
                }
                case GEOMETRY: {
                    this.complexFields[i] = queryResult.getGeometry(colIndex);
                }
            }
            if (!queryResult.wasNull()) {
                fl = (byte)(fl | 1);
            }
            this.flags[i] = fl;
        }
    }

    @Override
    public TableDescriptor getTableDescriptor() {
        return this.rowset.getTableDescriptor();
    }

    @Override
    public boolean isToBeDeleted() {
        return this.isDeleted && !this.isNew;
    }

    @Override
    public boolean isMarkDelete() {
        return this.isDeleted;
    }

    @Override
    public boolean isNew() {
        return this.isNew && !this.isDeleted;
    }

    @Override
    public boolean isModified() {
        return !this.isDeleted && !this.isNew && this.getChangedFieldsIterator().hasNext();
    }

    @Override
    public Iterator<FieldDescriptor> getChangedFieldsIterator() {
        return new ChangedFieldsIterator();
    }

    @Override
    public boolean isChangedFieldsEquals(DoubleSet changedFields) {
        int count = 0;
        TableDescriptor table = this.getTableDescriptor();
        List<FieldDescriptor> fields = table.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            if ((this.flags[i] & 2) == 0) continue;
            if (changedFields.contains(fields.get(i).getId())) {
                ++count;
                continue;
            }
            return false;
        }
        return count == changedFields.size();
    }

    @Override
    public void saved() {
        int fieldCount = this.getTableDescriptor().getFields().size();
        int i = 0;
        while (i < fieldCount) {
            int n = i++;
            this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFD);
        }
        this.isNew = false;
        this.isModified = false;
    }

    private void informModified() {
        if (!this.isModified) {
            this.rowset.registerModifiedRow(this);
            this.isModified = true;
        }
    }

    private boolean isFieldContentLoaded(int index) {
        return this.rowLoaded && (this.flags[index] & 8) == 0;
    }

    private class ChangedFieldsIterator
    implements Iterator<FieldDescriptor> {
        private final TableDescriptor table;
        private int index;
        private int nextIndex;

        private ChangedFieldsIterator() {
            this.table = DataRow.this.getTableDescriptor();
            this.index = -1;
            this.nextIndex = -1;
        }

        private int findNext() {
            for (int i = this.index + 1; i < this.table.getFields().size(); ++i) {
                if ((DataRow.this.flags[i] & 2) == 0) continue;
                return i;
            }
            return -1;
        }

        @Override
        public boolean hasNext() {
            this.nextIndex = this.findNext();
            return this.nextIndex != -1;
        }

        @Override
        public FieldDescriptor next() {
            if (this.nextIndex == -1) {
                this.nextIndex = this.findNext();
            }
            this.index = this.nextIndex;
            this.nextIndex = -1;
            return this.table.getFields().get(this.index);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

