/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db;

import inform.adt.Strings;
import inform.agent.Core;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.connect.DatabaseType;
import inform.agent.db.schema.DbScheme;
import inform.agent.db.types.DataType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class IndexDescriptor {
    public static final int TAG_TBL_IDX_ID = 1;
    public static final int TAG_TBL_IDX_NAME = 2;
    public static final int TAG_TBL_IDX_FIELD_ID = 3;
    public static final int TAG_TBL_IDX_UNIQUE = 4;
    public static final int TAG_TBL_IDX_RAW_NAME = 5;
    public static final int TAG_IDX_UNIQUE_ERR_MSG = 6;
    public static final int TAG_TBL_IDX_CLUSTERED = 7;
    public static final int TAG_TBL_IDX_COMPRESSED_FIELDS = 8;
    public static final int TAG_TBL_IDX_BITMAP = 9;
    public static final int TAG_TBL_IDX_DIM1_MIN = 10;
    public static final int TAG_TBL_IDX_DIM1_MAX = 11;
    public static final int TAG_TBL_IDX_DIM2_MIN = 12;
    public static final int TAG_TBL_IDX_DIM2_MAX = 13;
    public static final int TAG_TBL_IDX_DIM_TOLERANCE = 14;
    public static final int TAG_TBL_IDX_DBTYPE_MASK = 16;
    public static final int TAG_TBL_IDX_NONUSAGE = 17;
    public static final int NONUSAGE_BITMAP = 0;
    public static final int NONUSAGE_CLUSTERED = 1;
    public static final int NONUSAGE_COMPRESSEDFIELDS = 2;
    public static final int TAG_TBL_IDX_METHOD = 18;
    public static final int TAG_TBL_IDX_CONDITION = 19;
    public static final int TAG_TBL_IDX_CONDITION_FIELD = 1;
    public static final int TAG_TBL_IDX_CONDITION_VALUE = 2;
    public static final int TAG_TBL_IDX_CONDITION_KIND = 3;
    public static final int TAG_TBL_IDX_STRONG_UNIQUE = 20;
    public static final int TAG_TBL_IDX_USE_TGRM = 21;
    public static final int dbmOther = 1;
    public static final int dbmOracle = 2;
    public static final int dbmMSSql = 4;
    public static final int dbmPgSql = 8;
    public static final int dbmH2 = 16;
    public static final int TAG_TBL_IDX_FIELD_RAW_NAME = 99;
    public static final int TAG_TBL_IDX_FIELD_UNSUPPORTED = 100;
    final int id;
    String name;
    String rawName;
    String uniqueErrorMsg = "";
    List<FieldDescriptor> fields;
    boolean unique;
    boolean strongUnique;
    boolean bitmap;
    boolean clustered;
    boolean descending;
    boolean SDOType;
    boolean SRIDChanged;
    boolean useTGRM;
    int compressedFieldsCount;
    double Dim1Min;
    double Dim1Max;
    double Dim2Min;
    double Dim2Max;
    double DimTolerance;
    int databaseMask = -1;
    String condition;
    Method method = Method.DEFAULT;

    public IndexDescriptor(int id) {
        this.id = id;
        this.fields = new ArrayList<FieldDescriptor>();
    }

    public IndexDescriptor(int id, String rawName, FieldDescriptor[] fields) {
        this.id = id;
        this.rawName = rawName;
        this.fields = Collections.unmodifiableList(Arrays.asList(fields));
    }

    void lockFields() {
        this.fields = Collections.unmodifiableList(this.fields);
    }

    public void setSRIDChanged(boolean Value2) {
        this.SRIDChanged = Value2;
    }

    public int getId() {
        return this.id;
    }

    public boolean isBitmap() {
        return this.bitmap;
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public int getCompressedFieldsCount() {
        return this.compressedFieldsCount;
    }

    public String getCondition() {
        return this.condition;
    }

    public Method getMethod() {
        return this.method;
    }

    public Collection<FieldDescriptor> getFields() {
        return this.fields;
    }

    public String fieldsList() {
        return this.fieldsList(false, null, null);
    }

    public String fieldsList(boolean strongUnique, DbScheme scheme, String fieldOptions) {
        StringBuilder result = new StringBuilder();
        int delim = 32;
        for (FieldDescriptor fd : this.fields) {
            result.append((char)delim);
            result.append(fd.getNameForIndex(strongUnique, scheme));
            if (fieldOptions != null && !fieldOptions.isEmpty()) {
                result.append(" ").append(fieldOptions);
            }
            delim = 44;
        }
        return result.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getRawName() {
        return this.rawName;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public boolean isStrongUnique() {
        return this.strongUnique;
    }

    public void setStrongUnique(boolean strongUnique) {
        this.strongUnique = strongUnique;
    }

    public boolean isDescending() {
        return this.descending;
    }

    public boolean isSDOType() {
        return this.SDOType;
    }

    public boolean isSRIDChanged() {
        return this.SRIDChanged;
    }

    public boolean isUseTGRM() {
        return this.useTGRM;
    }

    public double getDim1Min() {
        return this.Dim1Min;
    }

    public double getDim1Max() {
        return this.Dim1Max;
    }

    public double getDim2Min() {
        return this.Dim2Min;
    }

    public double getDim2Max() {
        return this.Dim2Max;
    }

    public double getDimTolerance() {
        return this.DimTolerance;
    }

    public String getUniqueErrorMsg() {
        return this.uniqueErrorMsg;
    }

    public boolean isApplicableTo(DatabaseType dbt) {
        int mask;
        if (dbt == DatabaseType.METABASE) {
            dbt = DatabaseType.get(Core.getMetadataDBKind());
        }
        switch (dbt) {
            case ORACLE: 
            case ORACLE_ODBC: {
                mask = 2;
                break;
            }
            case MSSQL_ODBC: {
                mask = 4;
                break;
            }
            case POSTGRESQL: {
                mask = 8;
                break;
            }
            case H2: {
                mask = 16;
                break;
            }
            default: {
                mask = 1;
            }
        }
        return (this.databaseMask & mask) == mask;
    }

    public static class ConditionItem
    implements Comparable<ConditionItem> {
        int fieldId;
        String field;
        DataType type;
        final ArrayList<String> values;
        boolean isNull = false;
        boolean isNotNull = false;

        public ConditionItem(String field) {
            this.field = field;
            this.values = new ArrayList();
        }

        public ConditionItem(ConditionItemLoaded l) {
            this.fieldId = l.field.id;
            this.field = l.field.rawName;
            this.type = l.field.type;
            this.values = new ArrayList();
            this.isNull = l.isNull;
            this.isNotNull = l.isNotNull;
            if (l.value != null) {
                this.values.add(l.value);
            }
        }

        public boolean isField(String fieldName) {
            return Strings.equalsIgnoreCaseNotNul(this.field, fieldName);
        }

        public void addValue(String v, DataType type) {
            this.values.add(v);
            if (this.type == null) {
                this.type = type;
            }
        }

        public void addNull(boolean isNull, boolean isNotNull) {
            if (isNull) {
                this.isNull = true;
            }
            if (isNotNull) {
                this.isNotNull = true;
            }
        }

        public void sortValues() {
            Collections.sort(this.values);
        }

        @Override
        public int compareTo(ConditionItem o) {
            if (this.field == null) {
                if (o.field == null) {
                    return 0;
                }
                return -1;
            }
            if (o.field == null) {
                return 1;
            }
            return this.field.compareToIgnoreCase(o.field);
        }

        public void toSql(DatabaseCaps caps, StringBuilder sql) {
            boolean isString;
            if (this.values.isEmpty() && !this.isNull && !this.isNotNull) {
                return;
            }
            if (this.type == null) {
                isString = false;
            } else {
                switch (this.type) {
                    case STRING: 
                    case UNICODE: 
                    case BIG_NUMBER: {
                        isString = true;
                        break;
                    }
                    default: {
                        isString = false;
                    }
                }
            }
            if (sql.length() != 0) {
                sql.append(" and ");
            }
            sql.append('(');
            boolean isNext = false;
            for (int j = 0; j < this.values.size(); ++j) {
                if (isNext) {
                    sql.append(" or ");
                }
                isNext = true;
                sql.append(this.field);
                String v = this.values.get(j);
                if (v == null) {
                    v = "";
                }
                if (isString) {
                    sql.append(" = ").append(caps.c_string2sql(v, false));
                    continue;
                }
                sql.append(" = ").append(v);
            }
            if (this.isNull) {
                if (isNext) {
                    sql.append(" or ");
                }
                isNext = true;
                sql.append(this.field).append(" is null");
            }
            if (this.isNotNull) {
                if (isNext) {
                    sql.append(" or ");
                }
                sql.append(this.field).append(" is not null");
            }
            sql.append(')');
        }
    }

    static class ConditionItemLoaded
    implements Comparable<ConditionItemLoaded> {
        FieldDescriptor field;
        String value;
        boolean isNull = false;
        boolean isNotNull = false;

        ConditionItemLoaded() {
        }

        @Override
        public int compareTo(ConditionItemLoaded o) {
            if (this.field == null) {
                if (o.field == null) {
                    return 0;
                }
                return -1;
            }
            if (o.field == null) {
                return 1;
            }
            return this.field.rawName.compareToIgnoreCase(o.field.rawName);
        }
    }

    public static enum Method {
        DEFAULT(0),
        BTREE(1),
        GiST(2),
        SPGiST(3),
        GIN(4),
        BRIN(5),
        RUM(6);

        int method;

        private Method(int method) {
            this.method = method;
        }

        public int toInt() {
            return this.method;
        }

        public static Method toMethod(int method) {
            for (Method t : Method.values()) {
                if (t.method != method) continue;
                return t;
            }
            return DEFAULT;
        }
    }
}

