/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db;

import inform.adt.collections.DoubleHash;
import java.util.ArrayList;

public class MaxGeneratedFieldValue {
    private static final DoubleHash<Values> values = new DoubleHash();

    private static synchronized ArrayList<Value> getTableValues(double tableId) {
        Values tableValues = values.get(tableId);
        if (tableValues == null) {
            tableValues = new Values(tableId);
            values.add(tableValues);
        }
        return tableValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void adjust(double tableId, Value value) {
        ArrayList<Value> tableValues = MaxGeneratedFieldValue.getTableValues(tableId);
        if (tableValues != null) {
            ArrayList<Value> arrayList = tableValues;
            synchronized (arrayList) {
                for (Value prev : tableValues) {
                    if (!prev.adjust(value)) continue;
                    return;
                }
                tableValues.add(value);
            }
        }
    }

    private static class Values
    extends ArrayList<Value>
    implements DoubleHash.Entry {
        final double key;

        Values(double key) {
            this.key = key;
        }

        @Override
        public double key() {
            return this.key;
        }
    }

    public static class Value {
        private final int fieldId;
        private double value;

        public Value(int fieldId, double value) {
            this.fieldId = fieldId;
            this.value = value;
        }

        public double getValue() {
            return this.value;
        }

        boolean adjust(Value value) {
            if (this.fieldId == value.fieldId) {
                if (this.value >= value.value) {
                    value.value = this.value += 1.0;
                } else {
                    this.value = value.value;
                }
                return true;
            }
            return false;
        }
    }
}

