/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.LittleEndianDataOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.utils.ParentRowInfo;
import java.io.IOException;
import java.util.ArrayList;

public class ReplicationData {
    public static final int TAG_CN_TABLE_DATA = 1;
    public static final int TAG_CN_ROWINFO = 2;
    public static final int TAG_CN_NODE_CONTENT = 3;
    public static final int TAG_CN_NEW_NODE = 4;
    public static final int TAG_CN_NODE_CACHE = 5;
    public static final int TAG_CN_TABLE_METADATA = 6;
    private static final int MAX_REPLICATED_ROWS = 64;
    public static final int ROW_MODIFIED = 0;
    public static final int ROW_APPENDED = 1;
    public static final int ROW_DELETED = 2;
    private ArrayList<RowInfoList> rows = new ArrayList();

    public void add(double tableId, int changeKind, double rowId, ParentRowInfo parent) {
        for (RowInfoList list : this.rows) {
            if (list.tableId != tableId) continue;
            list.add(changeKind, rowId, parent);
            return;
        }
        RowInfoList list = new RowInfoList();
        this.rows.add(list);
        list.tableId = tableId;
        list.add(changeKind, rowId, parent);
    }

    public void add(double tableNodeId, int changeKind, double rowId) {
        this.add(tableNodeId, changeKind, rowId, null);
    }

    public void primaryKeyChanged(double tableId, double newRowId, double oldRowId) {
        for (RowInfoList list : this.rows) {
            if (list.tableId != tableId) continue;
            list.primaryKeyChanged(newRowId, oldRowId);
            return;
        }
    }

    public void serialize(TaggedWriter writer) throws IOException {
        for (RowInfoList list : this.rows) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            LittleEndianDataOutputStream stream = new LittleEndianDataOutputStream(bytes);
            stream.writeDouble(list.tableId);
            stream.writeInt(list.size());
            stream.flush();
            writer.putRaw(1, bytes);
            list.serialize(writer);
        }
    }

    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    private static class RowInfoList
    extends ArrayList<RowInfo> {
        private boolean hasInsertions = false;
        double tableId;

        private RowInfoList() {
        }

        void add(int kind, double rowId, ParentRowInfo parentInfo) {
            if (kind == 1) {
                if (this.hasInsertions) {
                    return;
                }
                this.hasInsertions = true;
            }
            if (this.size() >= 64) {
                return;
            }
            RowInfo rowInfo = new RowInfo();
            this.add(rowInfo);
            rowInfo.changeKind = kind;
            rowInfo.rowId = rowId;
            rowInfo.parentInfo = parentInfo;
        }

        void primaryKeyChanged(double newRowId, double oldRowId) {
            for (RowInfo rowInfo : this) {
                if (rowInfo.rowId != oldRowId) continue;
                rowInfo.rowId = oldRowId;
                break;
            }
        }

        void serialize(TaggedWriter writer) throws IOException {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            LittleEndianDataOutputStream stream = new LittleEndianDataOutputStream(bytes);
            for (RowInfo r : this) {
                stream.writeDouble(r.rowId);
                if (r.parentInfo == null) {
                    stream.writeDouble(0.0);
                    stream.writeDouble(0.0);
                    stream.writeInt(0);
                } else {
                    stream.writeDouble(r.parentInfo.tableNodeId);
                    stream.writeDouble(r.parentInfo.rowId);
                    stream.writeInt(r.parentInfo.dataLink);
                }
                stream.writeInt(r.changeKind);
            }
            stream.flush();
            writer.putRaw(2, bytes);
        }
    }

    private static class RowInfo {
        double rowId;
        ParentRowInfo parentInfo;
        int changeKind;

        private RowInfo() {
        }
    }
}

