/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db;

import inform.adt.ObjectSizer;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.DataRow;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.Row;
import inform.agent.db.SortingField;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.filters.RowFilter;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.stat.DatasourceProfile;
import java.io.IOException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;

public abstract class Rowset
extends ArrayList<Row> {
    private final boolean internStrings;
    protected int curRowIndex = -1;
    protected Row curRow;
    @ObjectSizer.HintShared
    protected AbstractConnectionManager dbManager;
    @ObjectSizer.HintShared
    protected TableDescriptor table;
    protected boolean hasRecordIdField;
    private int blobReceiving = 0;
    protected BitSet disabledGenerators = null;
    protected DatasourceProfile profile = null;
    public final SSContext ssContext;
    private boolean batchMode;

    public Rowset(SSContext ssContext, AbstractConnectionManager dbManager, TableDescriptor table, int blobReceiving, boolean internStrings) {
        this.dbManager = dbManager;
        this.table = table;
        this.hasRecordIdField = table != null && table.getRecordIdField() != null;
        this.blobReceiving = blobReceiving;
        this.internStrings = internStrings;
        this.ssContext = ssContext;
    }

    public TableDescriptor getTableDescriptor() {
        return this.table;
    }

    public abstract void appendRow(double var1);

    public abstract void editRow(double var1);

    public abstract void reuseRow();

    public abstract void compact();

    public void close() {
    }

    public Row getCurrentRow() {
        return this.curRow;
    }

    public abstract boolean next();

    public abstract boolean prev();

    public abstract void reset();

    public abstract void filter(RowFilter var1);

    public abstract void clearFilter();

    @Override
    public abstract void sort(Collection<SortingField> var1);

    public int getRecordCount() {
        return -1;
    }

    public abstract int getRecordIndex();

    public abstract void setRecordIndex(int var1);

    public abstract void setRecord(Row var1);

    public abstract boolean setRecord(double var1);

    public abstract boolean locate(RowFilter ... var1);

    protected Row createRowFromQueryResult(ResultSet queryResult, FieldDescriptor[] columnsMap) throws SQLException, IOException {
        DataRow r = new DataRow(this, this.table, queryResult, columnsMap);
        return r;
    }

    public DatabaseConnection getDatabase() throws SQLException {
        return this.dbManager.getConnection(this.table.getDbId(), "Rowset::getDatabase");
    }

    public ServerSideHost getSSHost() {
        if (this.dbManager == null) {
            return null;
        }
        return this.dbManager.getSSHost();
    }

    protected void registerModifiedRow(Row modifiedRow) {
        if (!this.batchMode || !modifiedRow.isNew()) {
            this.dbManager.registerModifiedRow(modifiedRow);
        }
    }

    public static FieldDescriptor[] getColumnsMap(ResultSetMetaData metadata, TableDescriptor table) throws SQLException {
        FieldDescriptor[] columnsMap = new FieldDescriptor[metadata.getColumnCount()];
        for (int i = 0; i < metadata.getColumnCount(); ++i) {
            columnsMap[i] = table.getField(metadata.getColumnLabel(i + 1));
        }
        return columnsMap;
    }

    public static boolean determineHasRecordIdField(TableDescriptor table, ResultSet queryResult, boolean hasPrimaryKey) throws SQLException {
        if (!hasPrimaryKey) {
            return false;
        }
        FieldDescriptor recordIdField = table.getRecordIdField();
        if (recordIdField == null) {
            for (int i = 1; i <= queryResult.getColumnCount(); ++i) {
                String columnName = queryResult.getColumnLabel(i);
                if (!"ID".equalsIgnoreCase(columnName)) continue;
                return true;
            }
            return false;
        }
        try {
            int idx = queryResult.findColumn(recordIdField.getRawName());
            return idx >= 1;
        }
        catch (SQLException e) {
            Core.logger.error(null, e);
            return false;
        }
    }

    public boolean isHasRecordIdField() {
        return this.hasRecordIdField;
    }

    public int getBlobReceiving() {
        return this.blobReceiving;
    }

    public void setBlobReceiving(int blobReceiving) {
        this.blobReceiving = blobReceiving;
    }

    String tryIntern(String s) {
        return s == null || !this.internStrings ? s : s.intern();
    }

    public void setProfile(DatasourceProfile profile) {
        this.profile = profile;
    }

    public void setDisabledGenerators(BitSet value) {
        assert (this.disabledGenerators == null);
        this.disabledGenerators = value;
    }

    public void setBatchMode(boolean value) {
        this.batchMode = value;
    }

    public static enum Kind {
        FORWARD_ONLY(0),
        SCROLLABLE(1),
        VIRTUAL(2);

        private int id;

        private Kind(int id) {
            this.id = id;
        }

        public int toInt() {
            return this.id;
        }

        public static Kind fromInt(int id) {
            for (Kind t : Kind.values()) {
                if (t.toInt() != id) continue;
                return t;
            }
            return null;
        }
    }
}

