/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db;

import inform.adt.InformException;
import inform.adt.collections.DoubleHash;
import inform.agent.Core;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.DataRow;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.Row;
import inform.agent.db.Rowset;
import inform.agent.db.SortingField;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.connect.ResultSetPostProcess;
import inform.agent.db.filters.Range;
import inform.agent.db.filters.RowFilter;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.stat.DatasourceProfile;
import java.io.IOException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class ScrollableRowset
extends Rowset {
    private Range _range;
    private final DoubleHash<Row> rowHash = new DoubleHash();
    private boolean isLocating;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScrollableRowset(SSContext ssContext, AbstractConnectionManager dbManager, TableDescriptor table, PreparedStatement stmt, int blobReceiving, boolean hasPrimaryKey, boolean internStrings, ResultSetPostProcess postProcess) throws InformException, SQLException, IOException {
        super(ssContext, dbManager, table, blobReceiving, internStrings);
        try {
            ResultSet queryResult = stmt.executeQuery(ssContext);
            try {
                ResultSetMetaData metadata = queryResult.getMetaData();
                this.hasRecordIdField = ScrollableRowset.determineHasRecordIdField(table, queryResult, hasPrimaryKey);
                FieldDescriptor[] columnMap = ScrollableRowset.getColumnsMap(metadata, table);
                if (postProcess != null) {
                    postProcess.setResultSet(queryResult, hasPrimaryKey);
                    while (queryResult.next()) {
                        if (!postProcess.next()) continue;
                        this.add(this.createRowFromQueryResult(queryResult, columnMap));
                    }
                } else {
                    while (queryResult.next()) {
                        this.add(this.createRowFromQueryResult(queryResult, columnMap));
                    }
                }
                for (Row r : this) {
                    this.rowHash.add(r);
                }
            }
            finally {
                try {
                    queryResult.close();
                }
                catch (Throwable e) {
                    Core.suppressErrorToLog(e);
                }
            }
        }
        finally {
            try {
                stmt.close();
            }
            catch (Throwable e) {
                Core.suppressErrorToLog(e);
            }
        }
    }

    public ScrollableRowset(SSContext ssContext, AbstractConnectionManager dbManager, TableDescriptor table, int blobReceiving, boolean internStrings) throws InformException {
        super(ssContext, dbManager, table, blobReceiving, internStrings);
    }

    @Override
    public void setProfile(DatasourceProfile profile) {
        super.setProfile(profile);
        if (profile != null) {
            profile.addRecordCount(this.size());
        }
    }

    protected Row newRow(TableDescriptor table, double rowId, boolean isNew) throws InformException {
        return new DataRow(this, table, rowId, isNew, false);
    }

    @Override
    public void appendRow(double rowId) throws InformException {
        this.isLocating = false;
        this.curRow = this.newRow(this.table, rowId, true);
        this.add(this.curRow);
        this.rowHash.add(this.curRow);
        this.curRowIndex = this.size() - 1;
        this._range = null;
        if (this.profile != null) {
            this.profile.addAccessCount();
        }
    }

    @Override
    public void compact() {
        this.isLocating = false;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            if (!row.isMarkDelete()) continue;
            it.remove();
        }
        this.curRowIndex = -1;
        this.curRow = null;
        this._range = null;
        if (this.profile != null) {
            this.profile.addAccessCount();
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.rowHash.clear();
    }

    @Override
    public boolean next() throws InformException {
        this.checkLocating();
        if (this.curRow != null && this.curRowIndex < 0) {
            this.curRowIndex = this.indexOf(this.curRow);
            if (this.curRowIndex < 0) {
                this.curRow = null;
                this.curRowIndex = this.range().last + 1;
                return false;
            }
        }
        ++this.curRowIndex;
        int last = this.range().last;
        if (this.curRowIndex > last) {
            this.curRowIndex = last + 1;
            this.curRow = null;
            return false;
        }
        this.curRow = (Row)this.get(this.curRowIndex);
        return true;
    }

    @Override
    public boolean prev() throws InformException {
        this.checkLocating();
        if (this.curRow != null && this.curRowIndex < 0) {
            this.curRowIndex = this.indexOf(this.curRow);
            if (this.curRowIndex < 0) {
                this.curRow = null;
                this.curRowIndex = this.range().first - 1;
                return false;
            }
        }
        --this.curRowIndex;
        int first = this.range().first;
        if (this.curRowIndex < first) {
            this.curRowIndex = first - 1;
            this.curRow = null;
            return false;
        }
        this.curRow = (Row)this.get(this.curRowIndex);
        return true;
    }

    @Override
    public void reset() {
        this.isLocating = false;
        this.curRowIndex = this.range().first - 1;
        this.curRow = null;
    }

    @Override
    public void filter(RowFilter filter) throws InformException {
        this.isLocating = false;
        this._range = filter.apply(this, this.range());
        this.curRowIndex = this._range.first - 1;
        this.curRow = null;
        if (this.profile != null) {
            this.profile.addAccessCount();
        }
    }

    @Override
    public void clearFilter() {
        this.isLocating = false;
        this._range = null;
    }

    @Override
    public int getRecordCount() {
        return this.range().length();
    }

    @Override
    public int getRecordIndex() {
        return this.curRowIndex;
    }

    @Override
    public void setRecordIndex(int index) {
        int first = this.range().first;
        int last = this.range().last;
        if ((index += this.range().first) < first) {
            this.curRowIndex = first - 1;
            this.curRow = null;
        } else if (index > last) {
            this.curRowIndex = last + 1;
            this.curRow = null;
        } else {
            this.curRowIndex = index;
            this.curRow = (Row)this.get(index);
        }
    }

    @Override
    public boolean locate(RowFilter ... locatingFilters) throws InformException {
        Range r = this.range();
        for (RowFilter l : locatingFilters) {
            r = l.apply(this, r);
        }
        if (r.empty()) {
            return false;
        }
        this.setRecord((Row)this.get(r.first));
        this.isLocating = true;
        return true;
    }

    @Override
    public void editRow(double rowId) throws InformException {
        if (!this.setRecord(rowId)) {
            this.curRow = this.newRow(this.table, rowId, false);
            this.add(this.curRow);
            this.rowHash.add(this.curRow);
            this.curRowIndex = this.size() - 1;
            this._range = null;
        }
        if (this.profile != null) {
            this.profile.addAccessCount();
        }
    }

    @Override
    public void reuseRow() {
        if (this.curRow == null) {
            throw new UnsupportedOperationException("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u043d\u0435 \u0441\u043f\u043e\u0437\u0438\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d \u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u0438.");
        }
        this.curRow.reuse(this.table);
    }

    @Override
    public boolean setRecord(double rowId) {
        if (this.curRow != null && this.curRow.id == rowId) {
            this.curRowIndex = -1;
            return true;
        }
        this.curRow = this.rowHash.get(rowId);
        this.curRowIndex = -1;
        return this.curRow != null;
    }

    @Override
    public void setRecord(Row record) {
        this.curRow = record;
    }

    private void checkLocating() throws InformException {
        if (this.isLocating) {
            throw new InformException(String.format("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 \u0437\u0430\u0444\u0438\u043a\u0441\u0438\u0440\u043e\u0432\u0430\u043d \u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u043f\u043e \u0432\u044b\u0437\u043e\u0432\u0443 locate*()", new Object[0]));
        }
    }

    public boolean wellSorted(Collection<SortingField> sorting) throws InformException {
        if (sorting.isEmpty()) {
            return true;
        }
        Iterator ri = this.iterator();
        if (!ri.hasNext()) {
            return true;
        }
        Row prevRow = (Row)ri.next();
        int ridx = 0;
        while (ri.hasNext()) {
            SortingField sf;
            int diff;
            Row currRow = (Row)ri.next();
            ++ridx;
            int i = 0;
            Iterator<SortingField> iterator = sorting.iterator();
            while (iterator.hasNext() && (diff = (sf = iterator.next()).compare(prevRow, currRow)) >= 0) {
                if (diff > 0) {
                    return false;
                }
                ++i;
            }
            prevRow = currRow;
        }
        return true;
    }

    @Override
    public void sort(final Collection<SortingField> sorting) throws InformException {
        Collections.sort(this, new Comparator<Row>(){

            @Override
            public int compare(Row o1, Row o2) {
                for (SortingField sf : sorting) {
                    int d = sf.compare(o1, o2);
                    if (d == 0) continue;
                    return d;
                }
                return 0;
            }
        });
        if (this.profile != null) {
            this.profile.addAccessCount();
        }
    }

    private Range range() {
        if (this._range == null) {
            this._range = new Range(0, this.size() - 1);
        }
        return this._range;
    }
}

