/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db;

import inform.adt.LittleEndian;
import inform.adt.Strings;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.types.SqlDataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.Parameter;
import inform.agent.scripts.ParametersList;
import inform.common.Empty;
import java.util.Arrays;

public class SelectionKey {
    private byte[] data = Empty.byteArray;
    private int size;
    private static final int MINIMAL_CAPACITY = 32;

    public static SelectionKey build(ParametersList parameters, byte[] linkRelation) {
        SelectionKey key = new SelectionKey();
        for (Parameter p : parameters.values()) {
            key.addParam(p);
        }
        if (linkRelation != null) {
            key.addBytes(linkRelation);
        }
        return key;
    }

    private void addParam(Parameter param) {
        boolean ignored = param.getIsIgnored();
        this.addBool(ignored);
        if (ignored) {
            return;
        }
        boolean isnull = param.getIsNull();
        this.addBool(isnull);
        if (isnull) {
            return;
        }
        SqlDataType type = param.getDataType().toSqlDataType();
        Object value = param.getRawValue();
        if (value instanceof Object[]) {
            for (Object v : (Object[])value) {
                this.addParamValue(type, v);
            }
        } else {
            this.addParamValue(type, value);
        }
    }

    private void addParamValue(SqlDataType type, Object value) {
        switch (type) {
            case BOOLEAN: {
                this.addBool(ValueCaster.toBoolean(value));
                break;
            }
            case INTEGER: {
                this.addInt(ValueCaster.toInt(value));
                break;
            }
            case DOUBLE: 
            case DATE_TIME: 
            case UNICODE: 
            case TIMESTAMP: {
                this.addDouble(ValueCaster.toDouble(value));
                break;
            }
            case STRING: {
                this.addBytes(ValueCaster.toString(value).getBytes(TaggedWriter.UTF8));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not supported yet: " + type);
            }
        }
    }

    private void addBool(boolean value) {
        this.need(1);
        this.data[this.size] = value ? (byte)1 : 0;
        ++this.size;
    }

    private void addInt(int value) {
        this.need(4);
        LittleEndian.setInteger(value, this.data, this.size);
        this.size += 4;
    }

    private void addDouble(double value) {
        this.need(8);
        LittleEndian.setDouble(value, this.data, this.size);
        this.size += 8;
    }

    private void addBytes(byte[] value) {
        int length = value.length;
        this.need(length);
        System.arraycopy(value, 0, this.data, this.size, length);
        this.size += length;
    }

    private void need(int sz) {
        int need = this.size + sz;
        int capa = this.data.length;
        if (need <= capa) {
            return;
        }
        if (capa < 32) {
            capa = 32;
        }
        while (capa < need) {
            capa = (capa + 1) * 2;
        }
        this.data = Arrays.copyOf(this.data, capa);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectionKey that = (SelectionKey)o;
        if (that.size != this.size) {
            return false;
        }
        int l = this.size;
        for (int i = 0; i != l; ++i) {
            if (this.data[i] == that.data[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        int l = this.size;
        for (int i = 0; i != l; ++i) {
            result = 31 * result + this.data[i];
        }
        return result;
    }

    public String toString() {
        return Strings.bytes2hex(this.data, 0, this.size);
    }
}

