/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.LittleEndianDataOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.SortFieldPath;
import java.io.IOException;
import java.util.ArrayList;

public class SortField
extends ArrayList<SortFieldPath> {
    private boolean ascending;

    public SortField() {
        this.ascending = true;
    }

    public SortField(boolean ascending) {
        this.ascending = ascending;
    }

    public void addField(int fieldId) {
        this.clear();
        this.add(new SortFieldPath(0.0, fieldId));
    }

    public void addField(double tableId, int fieldId) {
        this.add(new SortFieldPath(tableId, fieldId));
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    public void storeAs(TaggedWriter writer) throws IOException {
        if (this.isEmpty()) {
            return;
        }
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        LittleEndianDataOutputStream stream = new LittleEndianDataOutputStream(data);
        SortFieldPath root = (SortFieldPath)this.get(0);
        stream.writeInt(root.fieldId);
        stream.writeInt(this.ascending ? 1 : 0);
        stream.writeInt(this.size() - 1);
        stream.close();
        writer.putRaw(12, data);
        if (this.size() == 1) {
            return;
        }
        data.reset();
        stream = new LittleEndianDataOutputStream(data);
        for (int i = 1; i < this.size(); ++i) {
            SortFieldPath path = (SortFieldPath)this.get(i);
            stream.writeDouble(path.tableId);
            stream.writeInt(path.fieldId);
        }
        stream.close();
        writer.putRaw(19, data);
    }
}

