/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db;

import inform.adt.collections.IntegerHash;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.db.LinkDescriptor;
import inform.agent.db.LinkField;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class TableLinkList {
    public static final int TAG_LINK_ID = 1;
    public static final int TAG_LINK_NAME = 2;
    public static final int TAG_LINK_TABLE = 3;
    public static final int TAG_LINK_CAPTION = 4;
    public static final int TAG_TBL_LINK_UPDATE_KEYS = 5;
    public static final int TAG_TBL_LINK_ROWS_QWNERSHIP = 6;
    public static final int TAG_LINK_FIELD_ID = 10;
    public static final int TAG_LINK_MASTER_FIELD_ID = 11;
    public static final int TAG_LINK_MASTER_PRIMARY_KEY = 12;
    public static final int TAG_LINK_CONST_INT = 15;
    public static final int TAG_LINK_CONST_DOUBLE = 16;
    public static final int TAG_LINK_CONST_STRING = 17;
    public static final int TAG_LINK_CONST_DATATIME = 18;
    private IntegerHash<LinkDescriptor> links = new IntegerHash();

    public TableLinkList(byte[] content) throws IOException, TaggedReaderException {
        if (content == null || content.length == 0) {
            return;
        }
        TaggedReader reader = new TaggedReader(new ByteArrayInputStream(content), content.length);
        this.load(reader);
    }

    public LinkDescriptor getLink(int linkId) {
        if (linkId == 0) {
            return null;
        }
        return this.links.get(linkId);
    }

    public Iterable<LinkDescriptor> getLinks() {
        return this.links;
    }

    private void load(TaggedReader reader) throws IOException, TaggedReaderException {
        LinkDescriptor link = null;
        LinkField linkField = null;
        while (reader.getNextTag() != 0) {
            if (reader.getCurrentTag() == 1) {
                link = new LinkDescriptor();
                linkField = link.loadTag(reader.getCurrentTag(), reader, linkField);
                this.links.add(link);
                continue;
            }
            linkField = link.loadTag(reader.getCurrentTag(), reader, linkField);
        }
    }
}

