/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.commit;

import inform.adt.InformException;
import inform.adt.ObjectSizer;
import inform.agent.Core;
import inform.agent.db.commit.DeleteEngine;
import inform.agent.db.commit.TableDataAudit;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;

public class DataTransaction {
    private static final long INTERVAL = 1000L;
    private final long generateTime = System.currentTimeMillis();
    private final DatabaseConnection connection;
    private final double id;
    @ObjectSizer.HintShared
    private final TableDataAudit tableDataAudit;
    private DeleteEngine deleteEngine;

    public DataTransaction(DatabaseConnection connection, TableDataAudit audit) throws InformException {
        this.connection = connection;
        this.id = Core.generateId();
        this.tableDataAudit = audit;
    }

    public TableDataAudit getTableDataAudit() {
        return this.tableDataAudit;
    }

    public void checkTransaction(TableDataAudit audit) {
        if (this.tableDataAudit != audit) {
            throw new InformException("\u0416\u0443\u0440\u043d\u0430\u043b \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442");
        }
    }

    public double id() {
        return this.id;
    }

    public void register() throws SQLException {
        if (this.tableDataAudit != null) {
            this.tableDataAudit.registerTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update() throws SQLException {
        long dt = System.currentTimeMillis() - this.generateTime;
        if (dt < 1000L) {
            return false;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ");
        this.connection.getDescriptor().appendAuditTableRawName("PHX_CHANGELOG", sql);
        sql.append(" SET ").append("OP_TIME").append("=? WHERE ").append("TRANS_ID").append("=?");
        try (PreparedStatement ps = this.connection.prepareStatement("Update TRANS_ID dates", sql.toString());){
            ps.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
            ps.setDouble(2, this.id);
            ps.execute(null);
            boolean bl = true;
            return bl;
        }
    }

    public DeleteEngine getDeleteEngine() {
        return this.deleteEngine;
    }

    public void setDeleteEngine(DeleteEngine deleteEngine) {
        this.deleteEngine = deleteEngine;
    }
}

