/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect;

import inform.adt.DateTime;
import inform.agent.db.connect.BlobStream;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.MultitypeArrayGetter;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.types.Geometry;
import java.sql.SQLException;
import java.sql.Timestamp;

public class CallableStatement
extends PreparedStatement
implements MultitypeArrayGetter {
    private final java.sql.CallableStatement statement;

    public CallableStatement(String comment, String sql, java.sql.CallableStatement statement, DatabaseConnection connection) {
        super(comment, sql, statement, connection);
        this.statement = statement;
    }

    @Override
    protected java.sql.CallableStatement statement() {
        return this.statement;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.statement.getMetaData().getColumnCount();
    }

    @Override
    public String getColumnLabel(int idx) throws SQLException {
        return this.statement.getMetaData().getColumnLabel(idx);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.statement.wasNull();
    }

    @Override
    public boolean getBoolean(int idx) throws SQLException {
        return this.statement.getBoolean(idx);
    }

    @Override
    public int getInt(int idx) throws SQLException {
        return this.statement.getInt(idx);
    }

    @Override
    public long getLong(int idx) throws SQLException {
        return this.statement.getLong(idx);
    }

    @Override
    public double getDouble(int idx) throws SQLException {
        return this.statement.getDouble(idx);
    }

    @Override
    public double getDateTime(int idx) throws SQLException {
        Timestamp t = this.statement.getTimestamp(idx);
        return t == null ? 0.0 : DateTime.fromUnixTime(t.getTime());
    }

    @Override
    public Timestamp getTimestamp(int idx) throws SQLException {
        return this.statement.getTimestamp(idx);
    }

    @Override
    public String getString(int idx) throws SQLException {
        return this.statement.getString(idx);
    }

    @Override
    public Geometry getGeometry(int idx) throws SQLException {
        throw new UnsupportedOperationException("\u0422\u0438\u043f \"\u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u044f\" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0434\u0430\u043d\u043d\u043e\u0439 \u0421\u0423\u0411\u0414");
    }

    @Override
    public byte[] getBlobBytes(int idx) throws SQLException {
        return this.statement.getBytes(idx);
    }

    @Override
    public BlobStream getBlobStream(int idx) throws SQLException {
        byte[] b = this.statement.getBytes(idx);
        return b == null ? null : new BlobStream.Bytes(b);
    }

    public void registerOutParameter(int idx, int sqlType) throws SQLException {
        this.statement.registerOutParameter(idx, sqlType);
    }

    @Override
    public int getAsInteger(int colIdx) throws SQLException {
        return this.getInt(colIdx);
    }

    @Override
    public double getAsDouble(int colIdx) throws SQLException {
        return this.getDouble(colIdx);
    }
}

