/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect;

import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import java.sql.SQLException;

public interface Connector {
    public DatabaseConnection connection() throws SQLException;

    public void commit() throws SQLException;

    public void markAsReadonly() throws IllegalStateException;

    public static class Metabase
    extends Lazy {
        private final String who;

        public Metabase(String who) {
            this.who = who;
        }

        public Metabase() {
            this("MetabaseLazyConnector");
        }

        public void close() throws SQLException {
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
        }

        @Override
        protected DatabaseConnection connect() throws SQLException {
            return DatabaseDescriptor.getMetabase().connectPrivileged(this.who);
        }
    }

    public static abstract class Lazy
    implements Connector {
        protected DatabaseConnection connection;
        private boolean readonly;

        @Override
        public DatabaseConnection connection() throws SQLException {
            if (this.connection == null) {
                this.connection = this.connect();
                if (this.readonly) {
                    this.connection.markAsReadonly();
                }
            }
            return this.connection;
        }

        @Override
        public void commit() throws SQLException {
            if (this.connection != null) {
                this.connection.commit();
            }
        }

        @Override
        public void markAsReadonly() throws IllegalStateException {
            this.readonly = true;
            if (this.connection != null) {
                this.connection.markAsReadonly();
            }
        }

        protected abstract DatabaseConnection connect() throws SQLException;
    }
}

