/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect;

import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.db.connect.AbstractStatement;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.scripts.SSContext;
import java.io.IOException;
import java.io.StringReader;
import java.sql.SQLException;

public abstract class CopyStatement
extends AbstractStatement {
    protected final String sql;
    private long lastStartExecTime;

    public CopyStatement(DatabaseConnection connection, String sql) {
        super(connection, null);
        this.sql = sql;
    }

    protected abstract long copyData(StringReader var1) throws SQLException, IOException;

    public final int executeCopy(SSContext ssContext, StringReader data) throws SQLException, IOException {
        long startNanoTime;
        this.beforeClose();
        this.connection.possibleWriteOperation();
        if (Ini.TraceSql) {
            Core.logger.logSql(this.getLogMessage(), this.connection);
        }
        if (Core.logger.getCollectSql()) {
            Core.logger.collectSql(this.connection, this.sql);
        }
        this.beforeExecute(ssContext, this.sql);
        this.rqStat.startTimeNano = startNanoTime = System.nanoTime();
        this.rqStat.startTime = this.lastStartExecTime = System.currentTimeMillis();
        this.connection.hook.beginLongOperation(this.lastStartExecTime, this.queryTimeout);
        try {
            long nanoTime;
            long result = this.copyData(data);
            if (this.isLogDangerSQL) {
                this.logDangerSql();
            }
            this.rqStat.executeDurationNano = nanoTime = System.nanoTime() - startNanoTime;
            this.longSQLMessage(nanoTime / 1000000L, Ini.TraceSql, true);
            this.statRMod((int)result);
            this.rqStat.recordCount = result;
            int n = (int)result;
            return n;
        }
        catch (SQLException e) {
            this.connection.setDirty();
            SQLException generatedError = this.generateError(e);
            this.rqStat.exception = generatedError;
            throw generatedError;
        }
        catch (IOException e) {
            this.connection.setDirty();
            this.rqStat.exception = e;
            throw e;
        }
        finally {
            long executeNanoTime;
            this.connection.hook.endLongOperation();
            this.rqStat.executeDurationNano = executeNanoTime = System.nanoTime() - startNanoTime;
            this.statSql(executeNanoTime / 1000000L);
        }
    }

    @Override
    public void close() {
        this.beforeClose();
    }
}

