/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.Strings;
import inform.adt.collections.DoubleSet;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.AtomicUtils;
import inform.agent.Core;
import inform.agent.DBConf;
import inform.agent.Ini;
import inform.agent.ServerSideHost;
import inform.agent.Statistics;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseInfo;
import inform.agent.db.connect.DatabaseType;
import inform.agent.db.connect.oracle.Connection;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.DatabaseNode;
import inform.agent.mtd.nodes.Node;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DatabaseDescriptor {
    private static final int WAIT_LIMIT = 10000;
    private static final int WARN_CONNECT_TIME = 3000;
    private static final long WARN_GET_CONNECT_TIME_NANO = 5000000000L;
    private static final long WARN_WAIT_CONNECT_TIME_NANO = 1000000000L;
    public static final double METADATA_DB = 2.0;
    public static final double SEQUENCE_GENERATOR_DB = -2.0;
    public static final int TAG_DATABASETYPE = 1;
    public static final int TAG_LOGIN = 2;
    public static final int TAG_PASSWORD = 3;
    public static final int TAG_SERVER = 4;
    public static final int TAG_AUDIT_ENABLED = 5;
    public static final int TAG_AUDIT_DATABASE_PREFIX = 6;
    public static final int TAG_DATABASE_SCHEME = 7;
    public static final int TAG_ORACLE_INSTANCE = 8;
    public static final int TAG_EXTERN_DATABASE = 9;
    public static final int TAG_TNS = 10;
    public static final int TAG_DATAPATH = 11;
    public static final int TAG_JDRIVER = 13;
    public static final int TAG_JURL = 14;
    public static final int TAG_DETAIL_AUDIT_SCHEME = 15;
    public static final int TAG_DISABLE_REPLICATION = 16;
    public static final int TAG_DATABASE_CONF = 17;
    public static final int TAG_DATABASE_CONF_VERIFIED = 18;
    public static final int TAG_DATABASE_CONF_CONTENT_STAMP = 19;
    public static final int TAG_DATABASE_ROOT_ID = 20;
    private final double nodeId;
    private DatabaseType databaseType;
    private DatabaseType loadedDatabaseType;
    private String server;
    private String dataPath;
    private String userName;
    private String password;
    private boolean auditEnabled;
    private String auditScheme;
    private String detailAuditScheme;
    private String scheme;
    private String instance;
    private boolean isExternal;
    private boolean isReplicationDisabled;
    private String jdbcDriver;
    private String jdbcUrl;
    private long modContentTime;
    private String dbConfName;
    private boolean dbConfVerified;
    private double rootDatabaseId;
    private final Queue<DatabaseConnection> freeConnections = new ConcurrentLinkedQueue<DatabaseConnection>();
    private final Collection<DatabaseConnection> usedConnections = new ConcurrentLinkedQueue<DatabaseConnection>();
    private static final ConcurrentHashMap<Double, DatabaseDescriptor> cache = new ConcurrentHashMap();
    private static final AtomicIntegerFieldUpdater<DatabaseDescriptor> AFU_connCount = AtomicIntegerFieldUpdater.newUpdater(DatabaseDescriptor.class, "connCount");
    private static final AtomicIntegerFieldUpdater<DatabaseDescriptor> AFU_usedCount = AtomicIntegerFieldUpdater.newUpdater(DatabaseDescriptor.class, "usedCount");
    private static final AtomicIntegerFieldUpdater<DatabaseDescriptor> AFU_usedCountMax = AtomicIntegerFieldUpdater.newUpdater(DatabaseDescriptor.class, "usedCountMax");
    private static final AtomicIntegerFieldUpdater<DatabaseDescriptor> AFU_usedCountMax2 = AtomicIntegerFieldUpdater.newUpdater(DatabaseDescriptor.class, "usedCountMax2");
    private volatile int connCount;
    private volatile int usedCount;
    private volatile int usedCountMax;
    private volatile int usedCountMax2;
    public final Statistics.WithHistory statistics = new Statistics.WithHistory(65536, 5000L);
    private static final AtomicLong totalWaitTimeNano = new AtomicLong();
    private static final AtomicInteger totalWaitsCount = new AtomicInteger();
    private static final Pattern RG_URL = Pattern.compile("//([^/]+)/(.+)");
    private static final Pattern RG_HOST = Pattern.compile("([^:]+):(\\d+)");
    private String nodeName = null;

    private String getServerByDBType() {
        if (this.databaseType == DatabaseType.ODBC || this.databaseType == DatabaseType.MSSQL_ODBC || this.databaseType == DatabaseType.INSQL_ODBC || this.databaseType == DatabaseType.POSTGRESQL || this.databaseType == DatabaseType.MYSQL || this.databaseType == DatabaseType.H2) {
            return Core.getMetadataDBDSN();
        }
        return Core.getMetadataDBTNS();
    }

    private DatabaseDescriptor(double nodeId) {
        this.nodeId = nodeId;
        if (nodeId == 2.0) {
            this.databaseType = DatabaseType.get(Core.getMetadataDBKind());
            this.loadedDatabaseType = DatabaseType.METABASE;
            this.server = this.getServerByDBType();
            this.userName = Core.getMetadataDBUsername();
            this.password = Core.getMetadataDBPassword();
            this.scheme = Ini.MetabaseScheme;
            if (this.databaseType.useUserScheme() && Strings.isVoid(this.scheme)) {
                this.scheme = this.userName;
            }
        }
    }

    private DatabaseDescriptor(DatabaseInfo dbInfo) {
        this.auditEnabled = false;
        this.isExternal = false;
        this.auditScheme = null;
        this.detailAuditScheme = null;
        this.dataPath = null;
        this.scheme = null;
        this.instance = null;
        this.nodeId = dbInfo.databaseId;
        this.databaseType = dbInfo.databaseType;
        this.loadedDatabaseType = dbInfo.databaseType;
        this.server = dbInfo.server;
        this.userName = dbInfo.userName;
        this.password = dbInfo.password;
        this.jdbcDriver = dbInfo.jdbcDriver;
        this.jdbcUrl = dbInfo.jdbcUrl;
        this.modContentTime = 0L;
        this.isReplicationDisabled = false;
        if (this.databaseType.isOracle()) {
            this.scheme = this.userName;
        }
    }

    public static DatabaseDescriptor getMetabase() {
        Double id = 2.0;
        DatabaseDescriptor result = cache.get(id);
        if (result == null) {
            result = new DatabaseDescriptor(2.0);
            cache.put(id, result);
        }
        return result;
    }

    public static DatabaseDescriptor getDatabase(DatabaseInfo dbInfo) {
        Double id = dbInfo.databaseId;
        DatabaseDescriptor result = cache.get(id);
        if (result == null) {
            result = new DatabaseDescriptor(dbInfo);
            cache.put(id, result);
        }
        return result;
    }

    private static DatabaseDescriptor getDatabase(DatabaseNode node, DoubleSet loadedNodes) {
        Double id = node.getId();
        if (loadedNodes.contains(id)) {
            throw new InformException("\u0426\u0438\u043a\u043b\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u043a\u043e\u0440\u043d\u0435\u0432\u043e\u0433\u043e \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f");
        }
        loadedNodes.add(id);
        DatabaseDescriptor result = cache.get(id);
        if (result == null) {
            result = new DatabaseDescriptor(id);
            try {
                result.load(new TaggedReader(new ByteArrayInputStream(node.getContent())));
                result.modContentTime = node.getModificationContentTime();
            }
            catch (IOException e) {
                throw InformException.wrap(e);
            }
            cache.put(id, result);
        } else {
            result.tryReload();
        }
        return result;
    }

    public static DatabaseDescriptor getDatabase(DatabaseNode node) {
        Double id = node.getId();
        DatabaseDescriptor result = cache.get(id);
        if (result == null) {
            result = new DatabaseDescriptor(id);
            try {
                result.load(new TaggedReader(new ByteArrayInputStream(node.getContent())));
                result.modContentTime = node.getModificationContentTime();
            }
            catch (IOException e) {
                throw InformException.wrap(e);
            }
            cache.put(id, result);
        } else {
            result.tryReload();
        }
        return result;
    }

    public static DatabaseDescriptor getDatabase(double databaseId) {
        if (databaseId == 2.0) {
            return DatabaseDescriptor.getMetabase();
        }
        Node node = MtdEngine.getValidNode(databaseId);
        if (!(node instanceof DatabaseNode)) {
            MtdEngine.throwError(databaseId, " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0443\u0437\u043b\u043e\u043c \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f");
        }
        return ((DatabaseNode)MtdEngine.getValidNode(databaseId)).getDescriptor();
    }

    public static DatabaseDescriptor getDatabase(TaggedReader reader) {
        DatabaseDescriptor result = new DatabaseDescriptor(0.0);
        try {
            result.load(reader);
        }
        catch (IOException e) {
            throw InformException.wrap(e);
        }
        return result;
    }

    public static Collection<ConnectionInfo> gatherActiveConnectionsInfo() {
        ArrayList<ConnectionInfo> result = new ArrayList<ConnectionInfo>();
        for (DatabaseDescriptor d : cache.values()) {
            for (DatabaseConnection c : d.freeConnections) {
                result.add(new ConnectionInfo(c, false));
            }
            for (DatabaseConnection c : d.usedConnections) {
                result.add(new ConnectionInfo(c, true));
            }
        }
        return result;
    }

    public static WorkloadInfo poolGatheredWorkloadInfo() {
        double flimit = Ini.DbConnectionsLimit;
        int used = 0;
        int all = 0;
        double maxload = 0.0;
        for (DatabaseDescriptor d : cache.values()) {
            used += d.usedCount;
            all += d.connCount;
            double load = (double)AFU_usedCountMax.getAndSet(d, 0) / flimit;
            if (!(load > maxload)) continue;
            maxload = load;
        }
        return new WorkloadInfo(used, all, maxload);
    }

    public static void poolGatheredWorkloadInfoSTS(Appendable out) throws IOException {
        for (DatabaseDescriptor d : cache.values()) {
            int used = d.usedCount;
            int all = d.connCount;
            int max = AFU_usedCountMax2.getAndSet(d, 0);
            out.append("{db:").append(Long.toString((long)d.nodeId)).append(",all:").append(Integer.toString(all)).append(",used:").append(Integer.toString(used)).append(",max:").append(Integer.toString(max)).append("}\n");
        }
    }

    public void appendPoolInfo(StringBuilder out) {
        int u = this.usedCount;
        int a = this.connCount;
        out.append("used:").append(u).append(" free:").append(a - u);
    }

    public static void invalidate(double nodeId) throws SQLException {
        DatabaseDescriptor dd = cache.get(nodeId);
        if (dd != null) {
            dd.invalidate();
        }
    }

    public static void destroyPools() throws SQLException {
        for (DatabaseDescriptor d : cache.values()) {
            d.destroyPool();
        }
    }

    public static void checkPools() throws SQLException {
        for (DatabaseDescriptor d : cache.values()) {
            d.checkPool();
        }
    }

    public double getNodeId() {
        return this.nodeId;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public String getServer() {
        return this.server;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isAuditEnabled() {
        return this.auditEnabled;
    }

    public String getAuditScheme() {
        return this.auditScheme;
    }

    public String getDetailAuditScheme() {
        return this.detailAuditScheme;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getInstance() {
        return this.instance;
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public boolean isReplicationDisabled() {
        return this.isReplicationDisabled;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getDBConfName() {
        return this.dbConfName;
    }

    public double getEffectiveDatabaseId() {
        if ((this.databaseType == DatabaseType.METABASE || this.loadedDatabaseType == DatabaseType.METABASE) && Strings.equals(this.userName, Core.getMetadataDBUsername())) {
            return 2.0;
        }
        return this.rootDatabaseId == 0.0 ? this.nodeId : this.rootDatabaseId;
    }

    private void appendTableSchemeInstance(String scheme, String rawTableName, StringBuilder rawName) {
        if (scheme != null && !scheme.isEmpty() && rawTableName.indexOf(46) == -1) {
            rawName.append(scheme);
            rawName.append('.');
        }
        rawName.append(rawTableName);
        if (this.instance != null && !this.instance.isEmpty()) {
            rawName.append('@');
            rawName.append(this.instance);
        }
    }

    public void appendSystemTable(String rawTableName, StringBuilder rawName) {
        rawName.append(rawTableName);
        if (this.instance != null && !this.instance.isEmpty()) {
            rawName.append('@');
            rawName.append(this.instance);
        }
    }

    public void appendTableRawName(String rawTableName, StringBuilder rawName) {
        this.appendTableSchemeInstance(this.scheme, rawTableName, rawName);
    }

    public void appendAuditTableRawName(String rawTableName, StringBuilder rawName) {
        if (this.auditScheme != null && !this.auditScheme.isEmpty()) {
            this.appendTableSchemeInstance(this.auditScheme, rawTableName, rawName);
        } else {
            this.appendTableSchemeInstance(this.scheme, rawTableName, rawName);
        }
    }

    public void appendDetailAuditTableRawName(String rawTableName, StringBuilder rawName) {
        if (this.detailAuditScheme != null && !this.detailAuditScheme.isEmpty()) {
            this.appendTableSchemeInstance(this.detailAuditScheme, rawTableName, rawName);
        } else {
            this.appendAuditTableRawName(rawTableName, rawName);
        }
    }

    public String getTableRawName(String rawTableName) {
        StringBuilder rawName = new StringBuilder();
        this.appendTableRawName(rawTableName, rawName);
        return rawName.toString();
    }

    public void load(TaggedReader reader) throws IOException, TaggedReaderException {
        this.load(reader, null);
    }

    private void load(TaggedReader reader, DoubleSet loadedNodes) throws IOException, TaggedReaderException {
        this.databaseType = DatabaseType.METABASE;
        this.loadedDatabaseType = null;
        this.auditEnabled = false;
        this.isExternal = false;
        this.isReplicationDisabled = false;
        this.auditScheme = null;
        this.detailAuditScheme = null;
        this.server = null;
        this.dataPath = null;
        this.userName = null;
        this.password = null;
        this.scheme = null;
        this.instance = null;
        this.jdbcUrl = null;
        this.jdbcDriver = null;
        this.dbConfName = null;
        this.dbConfVerified = false;
        this.rootDatabaseId = 0.0;
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    this.loadedDatabaseType = this.databaseType = DatabaseType.get(reader.getInt());
                    break;
                }
                case 2: {
                    this.userName = reader.getAnsi();
                    break;
                }
                case 3: {
                    this.password = reader.getAnsi();
                    break;
                }
                case 4: 
                case 10: {
                    this.server = reader.getAnsi();
                    break;
                }
                case 11: {
                    this.dataPath = reader.getAnsi();
                    break;
                }
                case 5: {
                    this.auditEnabled = true;
                    break;
                }
                case 6: {
                    this.auditScheme = reader.getAnsi();
                    break;
                }
                case 7: {
                    this.scheme = reader.getAnsi();
                    break;
                }
                case 8: {
                    this.instance = reader.getAnsi();
                    break;
                }
                case 9: {
                    this.isExternal = true;
                    break;
                }
                case 13: {
                    this.jdbcDriver = reader.getAnsi();
                    break;
                }
                case 14: {
                    this.jdbcUrl = reader.getAnsi();
                    break;
                }
                case 15: {
                    this.detailAuditScheme = reader.getAnsi();
                    break;
                }
                case 16: {
                    this.isReplicationDisabled = true;
                    break;
                }
                case 17: {
                    this.dbConfName = reader.getString();
                    break;
                }
                case 18: {
                    this.dbConfVerified = true;
                    break;
                }
                case 20: {
                    this.rootDatabaseId = reader.getNodeID();
                }
            }
        }
        if (!Strings.isVoid(this.dbConfName)) {
            try {
                DBConf conf = new DBConf(this.dbConfName);
                this.databaseType = DatabaseType.get(conf.dbType);
                this.userName = conf.login;
                this.password = conf.password;
                this.server = conf.server;
                this.dataPath = conf.firebirdDatapath;
                this.auditEnabled = conf.auditEnabled;
                this.scheme = conf.scheme;
                this.instance = conf.oracleInstance;
                this.jdbcDriver = conf.jdbcDriver;
                this.jdbcUrl = conf.jdbcUrl;
                this.detailAuditScheme = conf.detailAuditScheme;
            }
            catch (Throwable e) {
                throw new DBConf.DBConfException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u0438\u0437 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 " + this.dbConfName, e);
            }
        } else if (this.rootDatabaseId != 0.0) {
            DatabaseDescriptor rootDescriptor;
            Node node = MtdEngine.getNode(this.rootDatabaseId);
            if (!(node instanceof DatabaseNode)) {
                throw new InformException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u043e \u043a\u043e\u0440\u043d\u0435\u0432\u043e\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435");
            }
            if (loadedNodes == null) {
                loadedNodes = new DoubleSet();
                if (this.nodeId != 0.0) {
                    loadedNodes.add(this.nodeId);
                }
            }
            if ((rootDescriptor = DatabaseDescriptor.getDatabase((DatabaseNode)node, loadedNodes)) == null) {
                throw new InformException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u043e \u043a\u043e\u0440\u043d\u0435\u0432\u043e\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435");
            }
            this.databaseType = rootDescriptor.databaseType;
            this.loadedDatabaseType = rootDescriptor.loadedDatabaseType;
            this.server = rootDescriptor.server;
            this.dataPath = rootDescriptor.dataPath;
            this.userName = rootDescriptor.userName;
            this.password = rootDescriptor.password;
            if (Strings.isVoid(this.scheme)) {
                this.scheme = rootDescriptor.scheme;
            }
            this.instance = rootDescriptor.instance;
            this.jdbcDriver = rootDescriptor.jdbcDriver;
            this.jdbcUrl = rootDescriptor.jdbcUrl;
        }
        switch (this.databaseType) {
            case METABASE: {
                this.loadedDatabaseType = this.databaseType;
                this.databaseType = DatabaseType.get(Core.getMetadataDBKind());
                this.server = this.getServerByDBType();
                if (this.userName == null) {
                    this.userName = Core.getMetadataDBUsername();
                    this.password = Core.getMetadataDBPassword();
                }
                if (!this.databaseType.useUserScheme() || !Strings.isVoid(this.scheme)) break;
                this.scheme = Ini.MetabaseScheme;
                if (!Strings.isVoid(this.scheme)) break;
                this.scheme = this.userName;
                break;
            }
            case INTERBASE: {
                this.scheme = null;
            }
        }
        if (!this.databaseType.isOracle()) {
            this.instance = null;
        }
        if (this.loadedDatabaseType == null) {
            this.loadedDatabaseType = this.databaseType;
        }
    }

    public void invalidate() throws SQLException {
        DatabaseConnection c;
        Core.logger.info("Invalidate pool {}", (Object)this);
        for (DatabaseConnection c2 : this.usedConnections) {
            Core.logger.info("{} is used, make obsolete", (Object)c2);
            c2.obsolete = true;
        }
        while ((c = this.freeConnections.poll()) != null) {
            this.realClose_connection(c);
        }
    }

    private void destroyPool() throws SQLException {
        if (!this.usedConnections.isEmpty()) {
            Core.logger.warn("Pool {} has used connections", (Object)this);
        }
        this.invalidate();
    }

    private void checkPool() throws SQLException {
        DatabaseConnection c;
        int maxChecks = this.freeConnections.size();
        while ((c = this.freeConnections.poll()) != null) {
            c.fastCheck();
            if (c.isDirty() || c.isObsolete()) {
                this.realClose_connection(c);
            } else {
                this.freeConnections.offer(c);
            }
            if (--maxChecks > 0) continue;
            break;
        }
    }

    private void tryReload() {
        if (this.nodeId <= 2.0) {
            return;
        }
        DatabaseNode node = (DatabaseNode)MtdEngine.getNode(this.nodeId);
        if (node == null) {
            return;
        }
        long nodeTime = node.getModificationContentTime();
        if (nodeTime != this.modContentTime) {
            try {
                this.load(new TaggedReader(new ByteArrayInputStream(node.getContent())));
                this.modContentTime = nodeTime;
                this.invalidate();
            }
            catch (Throwable e) {
                throw InformException.wrap(e);
            }
        }
    }

    private DatabaseConnection createConnection() throws SQLException {
        DatabaseConnection result;
        this.tryReload();
        long startConnectTime = System.currentTimeMillis();
        switch (this.databaseType) {
            case ORACLE_ODBC: 
            case ORACLE: {
                result = new Connection(this);
                break;
            }
            case ODBC: {
                result = new inform.agent.db.connect.odbc.Connection(this);
                break;
            }
            case INSQL_ODBC: 
            case MSSQL_ODBC: {
                result = new inform.agent.db.connect.mssql.Connection(this);
                break;
            }
            case JDBC: {
                result = new inform.agent.db.connect.generic.Connection(this);
                break;
            }
            case POSTGRESQL: {
                result = new inform.agent.db.connect.postgresql.Connection(this);
                break;
            }
            case MYSQL: {
                result = new inform.agent.db.connect.mysql.Connection(this);
                break;
            }
            case H2: {
                result = new inform.agent.db.connect.h2.Connection(this);
                break;
            }
            default: {
                throw new InformException(String.format("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u0411\u0414: %s", new Object[]{this.databaseType}));
            }
        }
        long connectTime = System.currentTimeMillis() - startConnectTime;
        if (connectTime >= 3000L) {
            Core.logger.warn("! \u0414\u043e\u043b\u0433\u043e\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u043a \u0431\u0430\u0437\u0435 {} \u043c\u0441\u0435\u043a {} {}", (Object)connectTime, (Object)this);
        }
        return result;
    }

    public static long getCurrentTotalWaitTime() {
        return totalWaitTimeNano.get() / 1000000L;
    }

    public static int getCurrentTotalWaitsCount() {
        return totalWaitsCount.get();
    }

    private DatabaseConnection pollFreeConnection() {
        DatabaseConnection result;
        while ((result = this.freeConnections.poll()) != null) {
            result.fastCheck();
            if (!result.isDirty() && !result.isObsolete()) break;
            this.realClose_connection(result);
        }
        return result;
    }

    private String dumpUsedConnections() {
        StringBuilder result = new StringBuilder();
        for (DatabaseConnection c : this.usedConnections) {
            result.append(c).append(" used by: ").append(c.usedBy).append('\n');
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseConnection connect(ServerSideHost ssHost, int limit, int wait_limit_ms, String who, boolean freshNeed) throws SQLException {
        DatabaseConnection result;
        DatabaseDescriptor db;
        if (!Strings.isVoid(this.dbConfName) && !this.dbConfVerified) {
            throw new InformException("\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u0438\u0437 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 " + this.dbConfName + " \u043d\u0435 \u0432\u0435\u0440\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e");
        }
        long startGetConnectNanoTime = System.nanoTime();
        if (ssHost != null && (db = ssHost.getDBLogin(this)) != null) {
            return db.connect(null, limit, wait_limit_ms, who, freshNeed);
        }
        long waitLimitNano = (long)wait_limit_ms * 1000000L;
        long waitTimeNano = 0L;
        boolean fresh = false;
        do {
            if ((result = this.pollFreeConnection()) != null) continue;
            if (this.connCount < limit) {
                result = this.createConnection();
                AFU_connCount.incrementAndGet(this);
                fresh = true;
                continue;
            }
            if (waitTimeNano > waitLimitNano) {
                Core.logger.warn(this + " pool usage details:\n" + this.dumpUsedConnections());
                throw new InformException("Cannot obtain DB connection. Pool is full, all connections used.");
            }
            long startWaitingNanoTime = System.nanoTime();
            Collection<DatabaseConnection> collection = this.usedConnections;
            synchronized (collection) {
                try {
                    this.usedConnections.wait(100L);
                }
                catch (InterruptedException e) {
                    throw InformException.wrap(e);
                }
            }
            long durationNanoTime = System.nanoTime() - startWaitingNanoTime;
            totalWaitTimeNano.addAndGet(durationNanoTime);
            totalWaitsCount.incrementAndGet();
            waitTimeNano += durationNanoTime;
        } while (result == null);
        long getConnectNanoTime = System.nanoTime() - startGetConnectNanoTime;
        if (freshNeed && !fresh) {
            this.realClose_connection(result);
            result = this.createConnection();
            AFU_connCount.incrementAndGet(this);
        }
        result.beforeReturnFromPool(who);
        this.usedConnections.add(result);
        int uc = AFU_usedCount.incrementAndGet(this);
        AtomicUtils.updateMaximum(AFU_usedCountMax, uc, AFU_usedCount, this);
        AtomicUtils.updateMaximum(AFU_usedCountMax2, uc, AFU_usedCount, this);
        if (waitTimeNano > 1000000000L) {
            Core.logger.warn("Performance leak. Waiting for DB connection pool in ({}ms).", (Object)(waitTimeNano / 1000000L));
        }
        if (getConnectNanoTime > 5000000000L) {
            Core.logger.warn("! \u0414\u043e\u043b\u0433\u0438\u0439 \u043f\u043e\u0438\u0441\u043a \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043a \u0431\u0430\u0437\u0435 {}\u043c\u0441\u0435\u043a {} {}", (Object)(getConnectNanoTime / 1000000L), (Object)this);
        }
        if (ssHost != null) {
            ssHost.standing(getConnectNanoTime);
        }
        return result;
    }

    public DatabaseConnection connectPrivileged(String who) throws SQLException {
        assert (this.nodeId <= 2.0);
        return this.connect(null, Ini.DbConnectionsLimit + 8, 10000, who, false);
    }

    public DatabaseConnection connect(ServerSideHost ssHost, String who, boolean freshNeed) throws SQLException {
        return this.connect(ssHost, Ini.DbConnectionsLimit, 10000, who, freshNeed);
    }

    public DatabaseConnection connect(ServerSideHost ssHost, String who) throws SQLException {
        return this.connect(ssHost, who, false);
    }

    public DatabaseConnection connect(AbstractConnectionManager manager, String who, boolean freshNeed) throws SQLException {
        DatabaseConnection result = this.connect(manager.getSSHost(), who, freshNeed);
        result.attach(manager);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseConnection(DatabaseConnection connection) {
        if (!this.usedConnections.remove(connection)) {
            Exception stack = new Exception(){

                @Override
                public String toString() {
                    return "";
                }
            };
            StringWriter sw = new StringWriter();
            stack.printStackTrace(new PrintWriter((Writer)sw, true));
            Core.logger.warn("Connection {} is already detached from {}:{}", connection, this, sw.toString());
            return;
        }
        AFU_usedCount.decrementAndGet(this);
        if (this.nodeId == 0.0 || connection.isDirty() || connection.isObsolete()) {
            this.realClose_connection(connection);
        } else {
            connection.usedBy = null;
            this.freeConnections.offer(connection);
        }
        Collection<DatabaseConnection> collection = this.usedConnections;
        synchronized (collection) {
            this.usedConnections.notify();
        }
    }

    private void realClose_connection(DatabaseConnection connection) {
        AFU_connCount.decrementAndGet(this);
        connection.real_Close();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append((Object)this.databaseType);
        result.append('[');
        this.appendNodeName(result);
        result.append(']');
        return result.toString();
    }

    public void appendNodeName(StringBuilder result) {
        if (this.nodeId == 2.0) {
            result.append("META");
        } else if (this.nodeId == -2.0) {
            result.append("SEQGEN");
        } else {
            result.append(NumberConverter.doubleToString(this.nodeId));
        }
    }

    public String getCaption() {
        String idStr = NumberConverter.doubleToString(this.nodeId);
        try {
            if (this.nodeName == null) {
                if (this.nodeId == 2.0) {
                    this.nodeName = "\u0411\u0430\u0437\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445";
                }
                this.nodeName = MtdEngine.getNodeName(this.nodeId);
                if (this.nodeName == null) {
                    this.nodeName = "???";
                }
            }
            if (this.nodeId == 2.0) {
                return this.nodeName;
            }
            return this.nodeName + " [" + idStr + "]";
        }
        catch (Throwable e) {
            Core.logger.error("DatabaseDescriptor.toString [" + idStr + "]", e);
            return "? [" + idStr + "]";
        }
    }

    public static void statTrySlice(long time) {
        for (DatabaseDescriptor d : cache.values()) {
            d.statistics.trySlice(time);
        }
    }

    public static void statWrite(long from, long to, TaggedWriter out) throws IOException {
        for (DatabaseDescriptor d : cache.values()) {
            d.statistics.write(from, to, out, d.nodeId);
        }
    }

    public void setDBLogin(String login, String password) {
        if (this.scheme == null || this.scheme.isEmpty()) {
            this.scheme = this.userName;
        }
        this.userName = login;
        this.password = password;
    }

    public static boolean isCompatible(DatabaseDescriptor d1, DatabaseDescriptor d2) {
        if (d1.databaseType != d2.databaseType) {
            return false;
        }
        String host1 = d1.getHost();
        if (Strings.isVoid(host1)) {
            return false;
        }
        String host2 = d2.getHost();
        if (Strings.isVoid(host2)) {
            return false;
        }
        return host1.trim().equalsIgnoreCase(host2.trim());
    }

    public String getHost() {
        String server;
        if (this.databaseType == DatabaseType.JDBC) {
            server = this.getJdbcUrl();
            if (Strings.isVoid(server)) {
                server = this.getServer();
            }
        } else {
            server = this.getServer();
        }
        if (Strings.isVoid(server)) {
            return null;
        }
        String url = server.startsWith("//") ? server : Core.odbcDSNtoURL(server);
        if (url.startsWith("//")) {
            Matcher m = RG_URL.matcher(url);
            if (m.matches()) {
                String host = m.group(1);
                if ((m = RG_HOST.matcher(host)).matches()) {
                    host = m.group(1);
                }
                return host;
            }
        } else {
            Matcher m = RG_HOST.matcher(url);
            if (m.matches()) {
                return m.group(1);
            }
        }
        return url;
    }

    public String getLogConnectionString(String url) {
        if (!Strings.isVoid(this.dbConfName)) {
            return "dbConf: " + this.dbConfName;
        }
        if (url != null) {
            return "url: " + url;
        }
        return " url: " + this.getHost();
    }

    public static final class WorkloadInfo {
        public final int used;
        public final int all;
        public final double load;

        WorkloadInfo(int used, int all, double load) {
            this.used = used;
            this.all = all;
            this.load = load;
        }
    }

    public static class ConnectionInfo {
        public final int id;
        public final boolean active;
        public final double databaseId;
        public final double creationTime;
        public final Class<?> driver;

        private ConnectionInfo(DatabaseConnection c, boolean active) {
            this.id = c.id;
            this.active = active;
            this.databaseId = c.getDescriptor().getNodeId();
            this.creationTime = DateTime.fromUnixTime(c.creationTime);
            this.driver = c.getClass();
        }
    }
}

