/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect;

import inform.adt.InformException;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.BatchInsertEngine;
import inform.agent.db.connect.AbstractStatement;
import inform.agent.db.connect.Advisor;
import inform.agent.db.connect.CallableStatement;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.Plan;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.schema.DbScheme;
import inform.agent.db.types.SqlDataType;
import inform.agent.scripts.SSContext;
import java.sql.Connection;
import java.sql.SQLException;

public class ProxyDatabaseConnection
extends DatabaseConnection {
    private final String connectionString;
    private final DatabaseConnection rootConnection;

    public ProxyDatabaseConnection(DatabaseDescriptor descriptor, DatabaseConnection connection) {
        super(descriptor, connection);
        this.connectionString = connection.connectionString();
        this.rootConnection = connection;
    }

    @Override
    protected String connectionString() {
        return this.connectionString;
    }

    @Override
    protected Connection establishConnection() throws InformException {
        return this.connection;
    }

    @Override
    void registerStatement(AbstractStatement statement) {
        this.rootConnection.registerStatement(statement);
    }

    @Override
    void unregisterStatement(AbstractStatement statement) {
        this.rootConnection.unregisterStatement(statement);
    }

    @Override
    public void setAutoCommit() throws SQLException {
        this.dirty = true;
        this.autoCommitMode = true;
        this.rootConnection.setAutoCommit();
    }

    @Override
    public DbScheme openScheme(String name) {
        return this.rootConnection.openScheme(name);
    }

    @Override
    public boolean isUniqueIndexConstraintException(SQLException ex) {
        return this.rootConnection.isUniqueIndexConstraintException(ex);
    }

    @Override
    protected void killSessionImpl(String cause) {
        this.rootConnection.killSessionImpl(cause);
    }

    @Override
    protected boolean internal_Check() throws SQLException {
        return this.rootConnection.internal_Check();
    }

    @Override
    public SQLException prepareException(SQLException e) {
        return this.rootConnection.prepareException(e);
    }

    @Override
    protected PreparedStatement newPreparedStatement(String comment, String sql) throws SQLException {
        return this.rootConnection.newPreparedStatement(comment, sql);
    }

    @Override
    protected CallableStatement newCallableStatement(String comment, String sql) throws SQLException {
        return this.rootConnection.newCallableStatement(comment, sql);
    }

    @Override
    protected Plan newExplainPlan(boolean trace, String sqlText) throws SQLException, InformException {
        return this.rootConnection.newExplainPlan(trace, sqlText);
    }

    @Override
    protected Advisor newAdvisor(String sqlText) throws SQLException, InformException {
        return this.rootConnection.newAdvisor(sqlText);
    }

    @Override
    protected boolean explainLastSql(String prefix, StringBuilder out) throws SQLException {
        return this.rootConnection.explainLastSql(prefix, out);
    }

    @Override
    protected void generateToString(StringBuilder builder) {
        if (this.rootConnection != null) {
            this.rootConnection.generateToString(builder);
        } else {
            super.generateToString(builder);
        }
    }

    @Override
    public void setAllConstraintsDeferred(SSContext ssContext) throws SQLException {
        this.rootConnection.setAllConstraintsDeferred(ssContext);
    }

    @Override
    public void commitForReleaseSelectLocks() throws SQLException {
        this.rootConnection.commitForReleaseSelectLocks();
    }

    @Override
    public void restoreTransactionAfterException(boolean commit) throws SQLException {
        this.rootConnection.restoreTransactionAfterException(commit);
    }

    @Override
    protected void custom_PreparedStatement_setNull(java.sql.PreparedStatement statement, int parameterIndex, SqlDataType type) throws SQLException {
        this.rootConnection.custom_PreparedStatement_setNull(statement, parameterIndex, type);
    }

    @Override
    public BatchInsertEngine createBatchInsertEngine(AbstractConnectionManager connectionManager) throws SQLException {
        return this.rootConnection.createBatchInsertEngine(connectionManager);
    }
}

