/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect;

import inform.adt.DateTime;
import inform.agent.Core;
import inform.agent.LogContext;
import inform.agent.RequestStatistics;
import inform.agent.Statistics;
import inform.agent.db.connect.AbstractStatement;
import inform.agent.db.connect.BlobStream;
import inform.agent.db.connect.MultitypeArrayGetter;
import inform.agent.db.types.Geometry;
import inform.agent.net.Client;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Timestamp;

public class ResultSet
implements MultitypeArrayGetter {
    protected final java.sql.ResultSet result;
    private final AbstractStatement statement;
    private final Statistics.WithHistory statistics;
    final long startTime;
    long startFetchTime;
    private int rowsFetched;
    private ResultSetMetaData metaData;
    private int[] columnTypes;
    boolean usedForForwardOnlyRowsets;

    public ResultSet(java.sql.ResultSet result, AbstractStatement statement, long startTime) {
        this.result = result;
        this.statement = statement;
        this.statistics = statement.connection.getDescriptor().statistics;
        this.startTime = startTime;
        statement.registerResultSet(this);
    }

    public void usedForForwardOnlyRowsets() {
        this.usedForForwardOnlyRowsets = true;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.metaData == null) {
            this.metaData = this.result.getMetaData();
        }
        return this.metaData;
    }

    public boolean isColumnExists(String name) throws SQLException {
        this.getMetaData();
        for (int i = 1; i <= this.metaData.getColumnCount(); ++i) {
            String columnName = this.metaData.getColumnLabel(i);
            if (!name.equalsIgnoreCase(columnName)) continue;
            return true;
        }
        return false;
    }

    public int[] getColumnTypes() throws SQLException {
        if (this.columnTypes != null) {
            return this.columnTypes;
        }
        ResultSetMetaData rsm = this.getMetaData();
        int[] ct = new int[rsm.getColumnCount()];
        for (int i = ct.length - 1; i >= 0; --i) {
            ct[i] = rsm.getColumnType(i + 1);
        }
        this.columnTypes = ct;
        return this.columnTypes;
    }

    public int findColumn(String name) throws SQLException {
        return this.result.findColumn(name);
    }

    @Override
    public String getColumnLabel(int idx) throws SQLException {
        return this.getMetaData().getColumnLabel(idx);
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.getMetaData().getColumnCount();
    }

    @Override
    public boolean getBoolean(int idx) throws SQLException {
        return this.result.getBoolean(idx);
    }

    @Override
    public int getInt(int idx) throws SQLException {
        return this.result.getInt(idx);
    }

    @Override
    public long getLong(int idx) throws SQLException {
        return this.result.getLong(idx);
    }

    @Override
    public Timestamp getTimestamp(int idx) throws SQLException {
        return this.result.getTimestamp(idx);
    }

    @Override
    public double getDouble(int idx) throws SQLException {
        return this.result.getDouble(idx);
    }

    @Override
    public String getString(int idx) throws SQLException {
        return this.result.getString(idx);
    }

    @Override
    public Geometry getGeometry(int idx) throws SQLException {
        throw new UnsupportedOperationException("\u0422\u0438\u043f \"\u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u044f\" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0434\u0430\u043d\u043d\u043e\u0439 \u0421\u0423\u0411\u0414");
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.result.getWarnings();
    }

    @Override
    public byte[] getBlobBytes(int idx) throws SQLException {
        return this.result.getBytes(idx);
    }

    @Override
    public BlobStream getBlobStream(int idx) throws SQLException {
        byte[] b = this.result.getBytes(idx);
        return b == null ? null : new BlobStream.Bytes(b);
    }

    @Override
    public double getDateTime(int idx) throws SQLException {
        Timestamp t = this.result.getTimestamp(idx);
        return t == null ? 0.0 : DateTime.fromUnixTime(t.getTime());
    }

    public boolean next() throws SQLException {
        this.statement.connection.hook.beginLongOperation(0L, 0L);
        try {
            boolean r = this.result.next();
            if (r) {
                if (this.statement.rqStat != null) {
                    ++this.statement.rqStat.recordCount;
                }
                ++this.rowsFetched;
            }
            boolean bl = r;
            return bl;
        }
        finally {
            this.statement.connection.hook.endLongOperation();
        }
    }

    public void close() throws SQLException {
        Core.stat.sqlRowsFetched(this.rowsFetched);
        this.statistics.sqlRowsFetched(this.rowsFetched);
        LogContext lc = LogContext.CURRENT.get();
        if (lc != null) {
            RequestStatistics.Value rqs;
            Client c = lc.client();
            if (c != null) {
                c.statistics.sqlRowsFetched(this.rowsFetched);
            }
            if ((rqs = lc.rqstat()) != null) {
                rqs.sqlRowsFetched(this.rowsFetched);
            }
        }
        this.statement.unregisterResultSet(this);
        this.result.close();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.result.wasNull();
    }

    @Override
    public int getAsInteger(int colIdx) throws SQLException {
        switch (this.getColumnTypes()[colIdx - 1]) {
            case -6: 
            case 4: 
            case 5: {
                return this.getInt(colIdx);
            }
            case -7: 
            case 16: {
                return this.getBoolean(colIdx) ? 1 : 0;
            }
        }
        return (int)this.getAsDouble(colIdx);
    }

    @Override
    public double getAsDouble(int colIdx) throws SQLException {
        switch (this.getColumnTypes()[colIdx - 1]) {
            case 91: 
            case 92: 
            case 93: {
                return this.getDateTime(colIdx);
            }
            case -7: 
            case 16: {
                return this.getBoolean(colIdx) ? 1.0 : 0.0;
            }
        }
        return this.getDouble(colIdx);
    }
}

