/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect;

import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.db.connect.AbstractStatement;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.scripts.SSContext;
import java.sql.SQLException;

public class Statement
extends AbstractStatement {
    private String currentSql;

    public Statement(DatabaseConnection connection, java.sql.Statement statement) {
        super(connection, statement);
    }

    public final boolean execute(SSContext ssContext, String sql) throws SQLException {
        long startNanoTime;
        this.connection.possibleWriteOperation();
        this.currentSql = sql;
        if (Ini.TraceSql) {
            Core.logger.logSql(this.getLogMessage(), this.connection);
        }
        if (Core.logger.getCollectSql()) {
            Core.logger.collectSql(this.connection, this.currentSql);
        }
        this.beforeExecute(ssContext, sql);
        this.rqStat.startTimeNano = startNanoTime = System.nanoTime();
        this.rqStat.startTime = System.currentTimeMillis();
        this.connection.hook.beginLongOperation(this.rqStat.startTime, this.queryTimeout);
        try {
            long nanoTime;
            boolean result = this.statement().execute(sql);
            if (!result && this.isLogDangerSQL) {
                this.logDangerSql();
            }
            this.rqStat.executeDurationNano = nanoTime = System.nanoTime() - startNanoTime;
            this.longSQLMessage(nanoTime / 1000000L, Ini.TraceSql, true);
            if (!result) {
                int updateCount = this.statement().getUpdateCount();
                this.rqStat.recordCount = updateCount;
                this.statRMod(updateCount);
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            this.connection.setDirty();
            SQLException generatedError = this.generateError(e);
            this.rqStat.exception = generatedError;
            throw generatedError;
        }
        finally {
            long executeNanoTime;
            this.connection.hook.endLongOperation();
            this.rqStat.executeDurationNano = executeNanoTime = System.nanoTime() - startNanoTime;
            this.rqStat.finished = true;
            this.rqStat = null;
            this.statSql(executeNanoTime / 1000000L);
        }
    }

    @Override
    protected void generateLogMessage(StringBuilder msg) {
        msg.append("\"").append(this.currentSql).append("\"");
        msg.append(" ");
    }
}

