/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect.generic;

import inform.adt.InformException;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import java.sql.DriverManager;
import java.sql.SQLException;

public class Connection
extends DatabaseConnection {
    public Connection(DatabaseDescriptor descriptor) throws InformException, SQLException {
        super(descriptor);
    }

    private String getDriver() {
        return this.descriptor.getJdbcDriver();
    }

    private String getUrl() {
        Object url = this.descriptor.getJdbcUrl();
        if (url == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d JDBC-URL");
        }
        if (this.descriptor.getScheme() != null) {
            url = (String)url + "/" + this.descriptor.getScheme();
        }
        return url;
    }

    @Override
    protected String connectionString() {
        return this.getDriver() + "#" + this.getUrl() + "@" + this.descriptor.getUserName();
    }

    @Override
    protected java.sql.Connection establishConnection() throws SQLException, InformException {
        String driver = this.getDriver();
        String url = this.getUrl();
        if (driver == null || driver.isEmpty()) {
            throw new InformException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0434\u0440\u0430\u0439\u0432\u0435\u0440 \u0434\u043b\u044f \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043a \u0411\u0414");
        }
        try {
            Class<?> cls = Class.forName(driver);
            if (!cls.isInstance(DriverManager.getDriver(url))) {
                throw new InformException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043a\u043b\u0430\u0441\u0441 \u0434\u0440\u0430\u0439\u0432\u0435\u0440\u0430");
            }
        }
        catch (Throwable ex) {
            throw InformException.detail(ex, this.descriptor.getLogConnectionString(null));
        }
        return DriverManager.getConnection(url, this.descriptor.getUserName(), this.descriptor.getPassword());
    }
}

