/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect.h2;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.Plan;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.connect.h2.Compat;
import inform.agent.db.connect.h2.PreparedStatement;
import inform.agent.db.connect.h2.schema.Scheme;
import inform.agent.db.schema.DbScheme;
import inform.agent.scripts.SSContext;
import java.io.File;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;

public class Connection
extends DatabaseConnection {
    private static final int CACHE_SIZE = 128;
    private static final String TCP = "tcp:";
    private static final String MEM = "mem:";
    private static final String DEFAULT_NAME = "microservice";

    public Connection(DatabaseDescriptor descriptor) throws InformException, SQLException {
        super(descriptor);
    }

    @Override
    protected String connectionString() {
        return this.descriptor.getServer() + "@" + this.descriptor.getUserName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected java.sql.Connection establishConnection() throws SQLException, InformException {
        Object ss = this.descriptor.getServer();
        if (ss == null || ((String)ss).isEmpty()) {
            throw new SQLException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0438\u043c\u044f \u0411\u0414 H2");
        }
        boolean keepActive = false;
        if (((String)ss).startsWith(MEM)) {
            String url = ((String)ss).substring(MEM.length());
            String[] items = url.split(";");
            if (items == null || items.length == 0 || Strings.isVoid(items[0])) {
                if (items == null || items.length <= 1) {
                    ss = "mem:microservice";
                } else {
                    StringBuilder nn = new StringBuilder();
                    nn.append(MEM).append(DEFAULT_NAME);
                    if (items != null) {
                        for (int i = 1; i < items.length; ++i) {
                            nn.append(';').append(items[i]);
                        }
                    }
                    ss = nn.toString();
                }
            } else if (items.length > 1) {
                throw new InformException("\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0441 \u0431\u0430\u0437\u043e\u0439 \u0434\u0430\u043d\u043d\u044b\u0439 \u0432 \u043f\u0430\u043c\u044f\u0442\u0438 \u0441 \u043f\u0435\u0440\u0435\u0434\u0430\u0447\u0435\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e,\n\u043f\u0435\u0440\u0435\u0434\u0430\u043d\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b: " + String.join((CharSequence)";", (CharSequence[])Arrays.stream(items, 1, items.length).toArray(String[]::new)));
            }
            keepActive = true;
        } else if (!Ini.EmbeddedMode && !((String)ss).startsWith(TCP)) {
            if (((String)ss).contains(":")) {
                try {
                    if (!Ini.H2Legacy) {
                        int index = ((String)ss).indexOf(59);
                        Object checkPath = index < 0 ? ss : ((String)ss).substring(0, index);
                        File checkFile = new File(Core.mountfs.resolvePath((String)checkPath + ".h2.db"));
                        if (checkFile.exists() && !(checkFile = new File(Core.mountfs.resolvePath((String)checkPath + ".mv.db"))).exists()) {
                            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f \u0444\u0430\u0439\u043b\u0430 \u0411\u0414 \u0441\u0442\u0430\u0440\u043e\u0433\u043e \u0444\u043e\u0440\u043c\u0430\u0442\u0430 \u043d\u043e\u0432\u044b\u043c \u0434\u0440\u0430\u0439\u0432\u0435\u0440\u043e\u043c \u0421\u0423\u0411\u0414 H2. \u0414\u043b\u044f \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043a \u0441\u0442\u0430\u0440\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 \u0411\u0414 (" + (String)ss + ") \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u043a\u043e\u043c\u0430\u043d\u0434\u043d\u043e\u0439 \u0441\u0442\u0440\u043e\u043a\u0438 \u0430\u0433\u0435\u043d\u0442\u0430 --db.h2.legacy");
                        }
                    }
                    Core.mountfs.checkPath((String)ss);
                    if (!Ini.H2Legacy) {
                        ss = "file:" + Core.mountfs.resolvePath((String)ss);
                    }
                    ss = Core.mountfs.resolvePath((String)ss);
                }
                catch (Exception e) {
                    throw InformException.wrap(e);
                }
            } else {
                throw new InformException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430 \u0442\u043e\u0447\u043a\u0430 \u043c\u043e\u043d\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u043b\u044f '" + this.descriptor.getLogConnectionString((String)ss) + "'");
            }
        }
        String lss = ((String)ss).toLowerCase();
        if (!lss.contains("cache_size=")) {
            ss = (String)ss + ";cache_size=131072";
        }
        if (Ini.H2Legacy && !lss.contains("mvcc=")) {
            ss = (String)ss + ";mvcc=true";
        }
        if (Ini.H2SyncCommit && !lss.contains("write_delay=")) {
            ss = (String)ss + ";WRITE_DELAY=0";
        }
        if (keepActive && !lss.contains("db_close_delay=")) {
            ss = (String)ss + ";DB_CLOSE_DELAY=-1";
        }
        String url = "jdbc:h2:" + (String)ss;
        java.sql.Connection c = DriverManager.getConnection(url, this.descriptor.getUserName(), this.descriptor.getPassword());
        try (Statement st = c.createStatement();){
            Compat.init(st);
        }
        return c;
    }

    @Override
    public DbScheme openScheme(String name) {
        return new Scheme(name, this, this.jdbcMetadata);
    }

    @Override
    protected Plan newExplainPlan(boolean trace, String sqlText) throws SQLException, InformException {
        return new Plan(this.prepareStatement("explain " + (trace ? "analyze " : "") + sqlText)){

            @Override
            public ResultSet explain(SSContext ssContext) throws SQLException {
                return this.statement.executeQuery(ssContext);
            }
        };
    }

    @Override
    public boolean isUniqueIndexConstraintException(SQLException ex) {
        return "23505".equals(ex.getSQLState());
    }

    @Override
    protected PreparedStatement newPreparedStatement(String comment, String sql) throws SQLException {
        return new PreparedStatement(comment, sql, this.connection.prepareStatement(sql), this);
    }
}

