/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect.mssql.schema;

import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.mssql.Connection;
import inform.agent.db.connect.mssql.schema.Table;
import inform.agent.db.schema.DbScheme;
import inform.agent.db.schema.DbTable;
import inform.agent.db.types.DataType;
import java.sql.DatabaseMetaData;

public class Scheme
extends DbScheme {
    public Scheme(String name, Connection connection, DatabaseMetaData metaData) {
        super(connection, metaData, name);
    }

    @Override
    protected void genConstraintSql(StringBuilder sql, TableDescriptor table, String primaryKeyName) {
        if (primaryKeyName == null) {
            return;
        }
        sql.append(", PRIMARY KEY ");
        if (table.isHasClusteredIndex()) {
            sql.append("NONCLUSTERED ");
        }
        sql.append('(').append(primaryKeyName).append(')');
    }

    @Override
    protected DbTable newTableObject(String name) {
        return new Table(name, this);
    }

    @Override
    public String ct2sql(DataType type, FieldDescriptor.BlobRawType brt, int size, boolean keyable) {
        switch (type) {
            case FLOAT: 
            case INTERVAL: 
            case DIRECTORY: 
            case METATREE_NODE: 
            case PRIMARY_KEY: {
                return "FLOAT";
            }
            case INTEGER: 
            case BOOLEAN: {
                return "INTEGER";
            }
            case STRING: {
                return "VARCHAR(" + size + ")";
            }
            case UNICODE: {
                return "NVARCHAR(" + size + ")";
            }
            case DATE_TIME: {
                return "DATETIME";
            }
            case BLOB: {
                if (brt == FieldDescriptor.BlobRawType.TEXT) {
                    return "TEXT";
                }
                return "IMAGE";
            }
            case FILE: {
                return "VARCHAR(256)";
            }
        }
        return super.ct2sql(type, brt, size, keyable);
    }

    @Override
    public String toCaseIfNeed(String name) {
        return name.toUpperCase();
    }

    @Override
    public String nameFromDb(String name) {
        return name.toUpperCase();
    }
}

